/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.notifications.cachelistener.cluster.RehashClusterListenerTest")
public class RehashClusterListenerTest
extends MultipleCacheManagersTest {
    protected static final String CACHE_NAME = "cluster-listener";
    protected static final String KEY = "key";
    protected static final String VALUE = "value";
    protected ConfigurationBuilder builderUsed;
    protected final ControlledConsistentHashFactory factory;

    public RehashClusterListenerTest() {
        this.factory = null;
    }

    public RehashClusterListenerTest(ControlledConsistentHashFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new RehashClusterListenerTest(new ControlledConsistentHashFactory.Default(1, 2)).cacheMode(CacheMode.DIST_SYNC)};
    }

    @BeforeMethod
    protected void beforeMethod() throws Exception {
        this.factory.setOwnerIndexes(1, 2);
        this.factory.triggerRebalance(this.cache(0, CACHE_NAME));
        TestingUtil.waitForNoRebalance(this.caches(CACHE_NAME));
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(this.cacheMode).hash().consistentHashFactory((ConsistentHashFactory)this.factory).numSegments(1);
        this.createClusteredCaches(3, CACHE_NAME, this.builderUsed);
    }

    public void testClusterListenerNodeBecomingPrimaryFromNotAnOwner() throws Exception {
        final Cache cache0 = this.cache(0, CACHE_NAME);
        Cache cache1 = this.cache(1, CACHE_NAME);
        Cache cache2 = this.cache(2, CACHE_NAME);
        cache1.put((Object)KEY, (Object)VALUE);
        ClusterListener listener = new ClusterListener();
        cache0.addListener((Object)listener);
        this.factory.setOwnerIndexes(0, 1);
        log.trace((Object)"Triggering rebalance to cause segment ownership to change");
        this.factory.triggerRebalance(cache0);
        RehashClusterListenerTest.eventually(new AbstractInfinispanTest.Condition(){
            final /* synthetic */ RehashClusterListenerTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isSatisfied() throws Exception {
                return cache0.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).containsKey((Object)RehashClusterListenerTest.KEY);
            }
        });
        TestingUtil.waitForNoRebalance(cache0, cache1, cache2);
        Assert.assertEquals((int)listener.events.size(), (int)0);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testClusterListenerNodeBecomingBackupFromNotAnOwner() throws Exception {
        final Cache cache0 = this.cache(0, CACHE_NAME);
        Cache cache1 = this.cache(1, CACHE_NAME);
        Cache cache2 = this.cache(2, CACHE_NAME);
        cache1.put((Object)KEY, (Object)VALUE);
        ClusterListener listener = new ClusterListener();
        cache0.addListener((Object)listener);
        this.factory.setOwnerIndexes(1, 0);
        log.trace((Object)"Triggering rebalance to cause segment ownership to change");
        this.factory.triggerRebalance(cache0);
        RehashClusterListenerTest.eventually(new AbstractInfinispanTest.Condition(){
            final /* synthetic */ RehashClusterListenerTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isSatisfied() throws Exception {
                return cache0.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).containsKey((Object)RehashClusterListenerTest.KEY);
            }
        });
        TestingUtil.waitForNoRebalance(cache0, cache1, cache2);
        Assert.assertEquals((int)listener.events.size(), (int)0);
    }

    public void testOtherNodeBecomingBackupFromNotAnOwner() throws Exception {
        final Cache cache0 = this.cache(0, CACHE_NAME);
        Cache cache1 = this.cache(1, CACHE_NAME);
        final Cache cache2 = this.cache(2, CACHE_NAME);
        cache1.put((Object)KEY, (Object)VALUE);
        ClusterListener listener = new ClusterListener();
        cache2.addListener((Object)listener);
        this.factory.setOwnerIndexes(1, 0);
        log.trace((Object)"Triggering rebalance to cause segment ownership to change");
        this.factory.triggerRebalance(cache0);
        RehashClusterListenerTest.eventually(new AbstractInfinispanTest.Condition(){
            final /* synthetic */ RehashClusterListenerTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isSatisfied() throws Exception {
                if (this.this$0.cacheMode.isDistributed()) {
                    return cache0.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK}).containsKey((Object)RehashClusterListenerTest.KEY);
                }
                return cache2.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK}).containsKey((Object)RehashClusterListenerTest.KEY);
            }
        });
        TestingUtil.waitForNoRebalance(cache0, cache1, cache2);
        Assert.assertEquals((int)listener.events.size(), (int)0);
    }

    public void testOtherNodeBecomingPrimaryFromNotAnOwner() throws Exception {
        final Cache cache0 = this.cache(0, CACHE_NAME);
        Cache cache1 = this.cache(1, CACHE_NAME);
        Cache cache2 = this.cache(2, CACHE_NAME);
        cache1.put((Object)KEY, (Object)VALUE);
        ClusterListener listener = new ClusterListener();
        cache2.addListener((Object)listener);
        this.factory.setOwnerIndexes(0, 1);
        log.trace((Object)"Triggering rebalance to cause segment ownership to change");
        this.factory.triggerRebalance(cache0);
        RehashClusterListenerTest.eventually(new AbstractInfinispanTest.Condition(){
            final /* synthetic */ RehashClusterListenerTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isSatisfied() throws Exception {
                return cache0.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).containsKey((Object)RehashClusterListenerTest.KEY);
            }
        });
        TestingUtil.waitForNoRebalance(cache0, cache1, cache2);
        Assert.assertEquals((int)listener.events.size(), (int)0);
    }

    @Listener(clustered=true)
    protected static class ClusterListener {
        List<CacheEntryEvent> events = Collections.synchronizedList(new ArrayList());

        protected ClusterListener() {
        }

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        public void onCacheEvent(CacheEntryEvent event) {
            log.debugf("Adding new cluster event %s", (Object)event);
            this.events.add(event);
        }
    }
}

