/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CacheListenerVisibilityTest")
@CleanupAfterMethod
public class CacheListenerVisibilityTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager(true);
    }

    public void testSizeVisibility() throws Exception {
        this.updateCache(Visibility.SIZE);
    }

    public void testGetVisibility() throws Exception {
        this.updateCache(Visibility.GET);
    }

    public void testGetVisibilityWithinEntryCreatedListener() throws Exception {
        this.updateCacheAssertInListener(new EntryCreatedWithAssertListener(new CountDownLatch(1)));
    }

    public void testGetVisibilityWithinEntryModifiedListener() throws Exception {
        this.updateCacheAssertInListener(new EntryModifiedWithAssertListener(new CountDownLatch(1)));
    }

    public void testRemoveVisibility() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        CountDownLatch after = new CountDownLatch(1);
        CountDownLatch afterContinue = new CountDownLatch(1);
        CountDownLatch before = new CountDownLatch(1);
        this.cache.addListener((Object)new EntryListener(before, afterContinue, after));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
        Future<Void> ignore = this.fork(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CacheListenerVisibilityTest.this.cache.remove((Object)1);
                return null;
            }
        });
        boolean signalled = before.await(30L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((String)"Timed out while waiting for before listener notification", (boolean)signalled);
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
        afterContinue.countDown();
        signalled = after.await(30L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((String)"Timed out while waiting for after listener notification", (boolean)signalled);
        AssertJUnit.assertEquals(null, (Object)this.cache.get((Object)1));
        ignore.get(5L, TimeUnit.SECONDS);
    }

    public void testEvictOnCacheEntryEvictedVisibility() throws Exception {
        this.checkEvictVisibility(false);
    }

    public void testEvictOnCacheEntriesEvictedVisibility() throws Exception {
        this.checkEvictVisibility(true);
    }

    private void checkEvictVisibility(boolean isCacheEntriesEvicted) throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        CountDownLatch after = new CountDownLatch(1);
        Object listener = isCacheEntriesEvicted ? new EntriesEvictedListener(after) : new EntryListener(null, null, after);
        this.cache.addListener(listener);
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
        Future<Void> ignore = this.fork(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CacheListenerVisibilityTest.this.cache.evict((Object)1);
                return null;
            }
        });
        boolean signalled = after.await(30L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((String)"Timed out while waiting for after listener notification", (boolean)signalled);
        AssertJUnit.assertEquals(null, (Object)this.cache.get((Object)1));
        ignore.get(5L, TimeUnit.SECONDS);
    }

    public void testClearVisibility() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.cache.put((Object)2, (Object)"v1");
        this.cache.put((Object)3, (Object)"v1");
        CyclicBarrier after = new CyclicBarrier(2);
        CountDownLatch afterContinue = new CountDownLatch(1);
        CountDownLatch before = new CountDownLatch(1);
        this.cache.addListener((Object)new CacheClearListener(before, afterContinue, after));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)2));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)3));
        Future<Void> ignore = this.fork(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CacheListenerVisibilityTest.this.cache.clear();
                return null;
            }
        });
        boolean signalled = before.await(30L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((String)"Timed out while waiting for before listener notification", (boolean)signalled);
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)2));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)3));
        afterContinue.countDown();
        after.await(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals(null, (Object)this.cache.get((Object)1));
        after.await(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals(null, (Object)this.cache.get((Object)2));
        after.await(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals(null, (Object)this.cache.get((Object)3));
        AssertJUnit.assertTrue((boolean)this.cache.isEmpty());
        ignore.get(5L, TimeUnit.SECONDS);
    }

    private void updateCacheAssertInListener(WithAssertListener listener) throws Exception {
        this.cache.addListener((Object)listener);
        Future<Void> ignore = this.fork(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CacheListenerVisibilityTest.this.cache.put((Object)"k", (Object)"v");
                return null;
            }
        });
        listener.latch.await(30L, TimeUnit.SECONDS);
        assert (listener.assertNotNull);
        assert (listener.assertValue);
        ignore.get(5L, TimeUnit.SECONDS);
    }

    private void updateCache(Visibility visibility) throws Exception {
        final String key = "k-" + String.valueOf((Object)visibility);
        final String value = "k-" + String.valueOf((Object)visibility);
        CountDownLatch after = new CountDownLatch(1);
        CountDownLatch afterContinue = new CountDownLatch(1);
        CountDownLatch before = new CountDownLatch(1);
        this.cache.addListener((Object)new EntryListener(before, afterContinue, after));
        switch (visibility.ordinal()) {
            case 0: {
                AssertJUnit.assertEquals((int)0, (int)this.cache.size());
                break;
            }
            case 1: {
                AssertJUnit.assertNull((Object)this.cache.get((Object)key));
            }
        }
        Future<Void> ignore = this.fork(new Callable<Void>(){
            final /* synthetic */ CacheListenerVisibilityTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void call() throws Exception {
                this.this$0.cache.put((Object)key, (Object)value);
                return null;
            }
        });
        boolean signalled = before.await(30L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((String)"Timed out while waiting for before listener notification", (boolean)signalled);
        switch (visibility.ordinal()) {
            case 0: {
                AssertJUnit.assertEquals((int)0, (int)this.cache.size());
                break;
            }
            case 1: {
                AssertJUnit.assertNull((Object)this.cache.get((Object)key));
            }
        }
        afterContinue.countDown();
        signalled = after.await(30L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((String)"Timed out while waiting for after listener notification", (boolean)signalled);
        switch (visibility.ordinal()) {
            case 0: {
                AssertJUnit.assertEquals((int)1, (int)this.cache.size());
                break;
            }
            case 1: {
                Object retVal = this.cache.get((Object)key);
                AssertJUnit.assertNotNull((Object)retVal);
                AssertJUnit.assertEquals((Object)retVal, (Object)value);
            }
        }
        ignore.get(5L, TimeUnit.SECONDS);
    }

    private static enum Visibility {
        SIZE,
        GET;

    }

    @Listener
    public static class EntryCreatedWithAssertListener
    extends WithAssertListener {
        protected EntryCreatedWithAssertListener(CountDownLatch latch) {
            super(latch);
        }

        @CacheEntryCreated
        public void entryCreated(CacheEntryEvent e) {
            this.assertCacheContents(e);
        }
    }

    public static abstract class WithAssertListener {
        Log log = LogFactory.getLog(WithAssertListener.class);
        final CountDownLatch latch;
        volatile boolean assertNotNull;
        volatile boolean assertValue;

        protected WithAssertListener(CountDownLatch latch) {
            this.latch = latch;
        }

        protected void assertCacheContents(CacheEntryEvent e) {
            if (!e.isPre()) {
                this.log.info((Object)"Cache entry created, now check cache contents");
                Object value = e.getCache().get((Object)"k");
                if (value == null) {
                    this.assertNotNull = false;
                    this.assertValue = false;
                } else {
                    this.assertNotNull = true;
                    this.assertValue = value.equals("v");
                }
                this.latch.countDown();
            }
        }
    }

    @Listener
    public static class EntryModifiedWithAssertListener
    extends WithAssertListener {
        protected EntryModifiedWithAssertListener(CountDownLatch latch) {
            super(latch);
        }

        @CacheEntryCreated
        @CacheEntryModified
        public void entryCreated(CacheEntryEvent e) {
            this.assertCacheContents(e);
        }
    }

    @Listener
    public static class EntryListener {
        Log log = LogFactory.getLog(EntryListener.class);
        final CountDownLatch after;
        final CountDownLatch before;
        final CountDownLatch afterContinue;

        public EntryListener(CountDownLatch before, CountDownLatch afterContinue, CountDownLatch after) {
            this.before = before;
            this.after = after;
            this.afterContinue = afterContinue;
        }

        @CacheEntriesEvicted
        public void entryEvicted(Event e) {
            this.log.info((Object)"Cache entry evicted, now check in different thread");
            this.after.countDown();
            TestingUtil.sleepThread(1000L);
        }

        @CacheEntryCreated
        @CacheEntryRemoved
        public void entryTouched(Event e) {
            if (!e.isPre()) {
                this.log.info((Object)"Cache entry touched, now check in different thread");
                this.after.countDown();
                TestingUtil.sleepThread(1000L);
            } else {
                this.before.countDown();
                try {
                    boolean signalled = this.afterContinue.await(30L, TimeUnit.SECONDS);
                    AssertJUnit.assertTrue((String)"Timed out while waiting for post listener event to execute", (boolean)signalled);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Listener
    public static class EntriesEvictedListener {
        Log log = LogFactory.getLog(EntriesEvictedListener.class);
        final CountDownLatch after;

        public EntriesEvictedListener(CountDownLatch after) {
            this.after = after;
        }

        @CacheEntriesEvicted
        public void entryEvicted(Event e) {
            this.log.info((Object)"Cache entries evicted, now check in different thread");
            this.after.countDown();
            TestingUtil.sleepThread(1000L);
        }
    }

    @Listener
    public static class CacheClearListener {
        Log log = LogFactory.getLog(CacheClearListener.class);
        final CyclicBarrier after;
        final CountDownLatch before;
        final CountDownLatch afterContinue;

        public CacheClearListener(CountDownLatch before, CountDownLatch afterContinue, CyclicBarrier after) {
            this.before = before;
            this.after = after;
            this.afterContinue = afterContinue;
        }

        @CacheEntryRemoved
        public void entryTouched(Event e) {
            if (!e.isPre()) {
                this.log.infof("Cache entry removed, event is: %s", (Object)e);
                try {
                    this.after.await(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                catch (BrokenBarrierException e1) {
                    throw new IllegalStateException(e1);
                }
                catch (TimeoutException e1) {
                    throw new IllegalStateException(e1);
                }
                TestingUtil.sleepThread(1000L);
            } else {
                this.before.countDown();
                try {
                    boolean signalled = this.afterContinue.await(30L, TimeUnit.SECONDS);
                    AssertJUnit.assertTrue((String)"Timed out while waiting for post listener event to execute", (boolean)signalled);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

