/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.event.MergeEvent;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.protocols.DISCARD;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.MergeViewTest")
public class MergeViewTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(MergeViewTest.class);
    private DISCARD discard;
    private MergeListener ml0;
    private MergeListener ml1;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager(MergeViewTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true), new TransportFlags().withMerge(true));
        this.ml0 = new MergeListener();
        this.manager(0).addListener((Object)this.ml0);
        this.discard = TestingUtil.getDiscardForCache(this.manager(0));
        this.discard.discardAll(true);
        this.addClusterEnabledCacheManager(MergeViewTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true), new TransportFlags().withMerge(true));
        this.ml1 = new MergeListener();
        this.manager(1).addListener((Object)this.ml1);
        this.cache(0).put((Object)"k", (Object)"v0");
        this.cache(1).put((Object)"k", (Object)"v1");
        Thread.sleep(2000L);
        assert (this.advancedCache(0).getRpcManager().getTransport().getMembers().size() == 1);
        assert (this.advancedCache(1).getRpcManager().getTransport().getMembers().size() == 1);
    }

    public void testMergeViewHappens() {
        this.discard.discardAll(false);
        TestingUtil.blockUntilViewsReceived(60000L, this.cache(0), this.cache(1));
        TestingUtil.waitForNoRebalance(this.cache(0), this.cache(1));
        assert (this.ml0.isMerged && this.ml1.isMerged);
        this.cache(0).put((Object)"k", (Object)"v2");
        AssertJUnit.assertEquals((Object)this.cache(0).get((Object)"k"), (Object)"v2");
        AssertJUnit.assertEquals((Object)this.cache(1).get((Object)"k"), (Object)"v2");
    }

    @Listener
    public static class MergeListener {
        volatile boolean isMerged;

        @Merged
        public void viewMerged(MergeEvent vce) {
            log.info((Object)("vce = " + String.valueOf(vce)));
            this.isMerged = true;
        }
    }
}

