/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.DefensiveCopyTest")
public class DefensiveCopyTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().storageType(StorageType.BINARY);
        return TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, builder);
    }

    public void testOriginalReferenceSafety() {
        Person key = new Person("Key1");
        Person value = new Person("Mr Infinispan");
        this.cache().put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        value.setName("Ms Hibernate");
        AssertJUnit.assertEquals((Object)new Person("Mr Infinispan"), (Object)this.cache.get((Object)key));
        key.setName("Key2");
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
    }

    public void testSafetyAfterRetrieving() {
        Integer k = 2;
        Person person = new Person("Mr Coe");
        this.cache().put((Object)k, (Object)person);
        Person cachedPerson = (Person)this.cache().get((Object)k);
        AssertJUnit.assertEquals((Object)person, (Object)cachedPerson);
        cachedPerson.setName("Mr Digweed");
        AssertJUnit.assertEquals((Object)person, (Object)this.cache.get((Object)k));
    }
}

