/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.Cache;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.distribution.VersionedDistributionInterceptor;
import org.infinispan.lock.FailInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="lock.StaleLocksOnPrepareFailureTest", groups={"functional"})
@CleanupAfterMethod
public class StaleLocksOnPrepareFailureTest
extends MultipleCacheManagersTest {
    private static final int NUM_CACHES = 10;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = StaleLocksOnPrepareFailureTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        cfg.clustering().hash().numOwners(10).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        for (int i = 0; i < 10; ++i) {
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(cfg);
            this.registerCacheManager(new CacheContainer[]{cm});
        }
        this.waitForClusterToForm();
    }

    public void testModsCommit() throws Exception {
        Cache c1 = this.cache(0);
        Cache c2 = this.cache(5);
        FailInterceptor interceptor = new FailInterceptor();
        interceptor.failFor(VersionedPrepareCommand.class);
        AsyncInterceptorChain ic = TestingUtil.extractInterceptorChain(c2);
        ic.addInterceptorBefore((AsyncInterceptor)interceptor, VersionedDistributionInterceptor.class);
        MagicKey k1 = new MagicKey("k1", c1);
        this.tm(c1).begin();
        c1.put((Object)k1, (Object)"v1");
        try {
            this.tm(c1).commit();
            assert (false) : "Commit should have failed";
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 10; ++i) {
            this.assertEventuallyNotLocked(this.cache(i), k1);
        }
    }
}

