/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.testng.AssertJUnit;

public abstract class AbstractGlobalStateRestartTest
extends MultipleCacheManagersTest {
    public static final int DATA_SIZE = 100;
    public static final String CACHE_NAME = "testCache";

    protected abstract int getClusterSize();

    @Override
    protected boolean cleanupAfterMethod() {
        return true;
    }

    @Override
    protected boolean cleanupAfterTest() {
        return false;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName()}));
        this.createStatefulCacheManagers(true, -1, false);
    }

    protected void createStatefulCacheManagers(boolean clear, int extraneousNodePosition, boolean reverse) {
        int totalNodes = this.getClusterSize() + (extraneousNodePosition < 0 ? 0 : 1);
        int node = reverse ? this.getClusterSize() - 1 : 0;
        int step = reverse ? -1 : 1;
        for (int i = 0; i < totalNodes; ++i) {
            if (i == extraneousNodePosition) {
                this.createStatefulCacheManager(Character.toString('@'), true);
                continue;
            }
            this.createStatefulCacheManager(Character.toString((char)(65 + node)), clear);
            node += step;
        }
    }

    void createStatefulCacheManager(String id, boolean clear) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id});
        if (clear) {
            Util.recursiveFileRemove((String)stateDirectory);
        }
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory);
        ConfigurationBuilder config = new ConfigurationBuilder();
        this.applyCacheManagerClusteringConfiguration(id, config);
        config.persistence().addSingleFileStore().location(stateDirectory).fetchPersistentState(true);
        config.clustering().stateTransfer().timeout(90L, TimeUnit.SECONDS);
        EmbeddedCacheManager manager = this.addClusterEnabledCacheManager(global, null);
        manager.defineConfiguration(CACHE_NAME, config.build());
    }

    protected abstract void applyCacheManagerClusteringConfiguration(ConfigurationBuilder var1);

    protected void applyCacheManagerClusteringConfiguration(String id, ConfigurationBuilder config) {
        this.applyCacheManagerClusteringConfiguration(config);
    }

    protected void shutdownAndRestart(int extraneousNodePosition, boolean reverse) throws Throwable {
        int i;
        Map<JGroupsAddress, PersistentUUID> addressMappings = this.createInitialCluster();
        ConsistentHash oldConsistentHash = this.advancedCache(0, CACHE_NAME).getDistributionManager().getWriteConsistentHash();
        this.cache(0, CACHE_NAME).shutdown();
        TestingUtil.killCacheManagers(this.cacheManagers);
        for (i = 0; i < this.getClusterSize(); ++i) {
            String persistentLocation = this.manager(i).getCacheManagerConfiguration().globalState().persistentLocation();
            Object[] listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
            AssertJUnit.assertEquals((String)Arrays.toString(listFiles), (int)1, (int)listFiles.length);
        }
        this.cacheManagers.clear();
        this.createStatefulCacheManagers(false, extraneousNodePosition, reverse);
        if (reverse) {
            LinkedHashMap<JGroupsAddress, PersistentUUID> reversed = new LinkedHashMap<JGroupsAddress, PersistentUUID>();
            this.reverseLinkedMap(addressMappings.entrySet().iterator(), reversed);
            addressMappings = reversed;
        }
        switch (extraneousNodePosition) {
            case -1: {
                this.assertHealthyCluster(addressMappings, oldConsistentHash);
                break;
            }
            case 0: {
                for (i = 1; i < this.cacheManagers.size(); ++i) {
                    try {
                        this.cache(i, CACHE_NAME);
                        AssertJUnit.fail((String)"Cache with state should not have joined coordinator without state");
                        continue;
                    }
                    catch (CacheException e) {
                        log.debugf("Got expected exception: %s", (Object)e);
                    }
                }
                break;
            }
            default: {
                Future<Cache> extraneousCreate = null;
                for (int i2 = 0; i2 < this.managers().length; ++i2) {
                    if (i2 == extraneousNodePosition) {
                        extraneousCreate = this.fork(() -> this.cache(extraneousNodePosition, CACHE_NAME));
                        continue;
                    }
                    this.cache(i2, CACHE_NAME);
                }
                Assertions.assertThat(extraneousCreate).isNotNull();
                extraneousCreate.get(10L, TimeUnit.SECONDS);
                this.checkClusterRestartedCorrectly(addressMappings);
                this.checkData();
            }
        }
    }

    protected void assertHealthyCluster(Map<JGroupsAddress, PersistentUUID> addressMappings, ConsistentHash oldConsistentHash) throws Throwable {
        this.waitForClusterToForm(CACHE_NAME);
        this.checkClusterRestartedCorrectly(addressMappings);
        this.checkData();
        ConsistentHash newConsistentHash = this.advancedCache(0, CACHE_NAME).getDistributionManager().getWriteConsistentHash();
        PersistentUUIDManager persistentUUIDManager = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), PersistentUUIDManager.class);
        this.assertEquivalent(addressMappings, oldConsistentHash, newConsistentHash, persistentUUIDManager);
    }

    protected void restartWithoutGracefulShutdown() {
        int i;
        for (i = 0; i < this.getClusterSize(); ++i) {
            String persistentLocation = this.manager(i).getCacheManagerConfiguration().globalState().persistentLocation();
            Object[] listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
            AssertJUnit.assertEquals((String)Arrays.toString(listFiles), (int)0, (int)listFiles.length);
        }
        for (i = this.getClusterSize() - 1; i >= 0; --i) {
            this.killMember(i, CACHE_NAME, false);
        }
        this.createStatefulCacheManagers(false, 0, false);
        for (i = 0; i <= this.getClusterSize(); ++i) {
            this.cache(i, CACHE_NAME);
        }
    }

    void assertEquivalent(Map<JGroupsAddress, PersistentUUID> addressMappings, ConsistentHash oldConsistentHash, ConsistentHash newConsistentHash, PersistentUUIDManager persistentUUIDManager) {
        AssertJUnit.assertTrue((boolean)this.isEquivalent(addressMappings, oldConsistentHash, newConsistentHash, persistentUUIDManager));
    }

    void checkClusterRestartedCorrectly(Map<JGroupsAddress, PersistentUUID> addressMappings) throws Exception {
        LocalTopologyManager ltm;
        int i;
        Iterator<Map.Entry<JGroupsAddress, PersistentUUID>> addressIterator = addressMappings.entrySet().iterator();
        HashSet<PersistentUUID> uuids = new HashSet<PersistentUUID>();
        for (i = 0; i < this.cacheManagers.size(); ++i) {
            ltm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(i), LocalTopologyManager.class);
            AssertJUnit.assertTrue((boolean)uuids.add(ltm.getPersistentUUID()));
        }
        for (i = 0; i < this.cacheManagers.size() && addressIterator.hasNext(); ++i) {
            ltm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(i), LocalTopologyManager.class);
            Map.Entry<JGroupsAddress, PersistentUUID> entry = addressIterator.next();
            AssertJUnit.assertTrue((String)(String.valueOf(entry.getKey()) + " is mapping to the wrong UUID: Expected: " + String.valueOf(entry.getValue()) + " not found in: " + String.valueOf(uuids)), (boolean)uuids.contains(entry.getValue()));
            AssertJUnit.assertTrue((boolean)ltm.isCacheRebalancingEnabled(CACHE_NAME));
        }
    }

    void checkData() {
        AssertJUnit.assertEquals((int)100, (int)this.cache(0, CACHE_NAME).size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertEquals((Object)this.cache(0, CACHE_NAME).get((Object)String.valueOf(i)), (Object)String.valueOf(i));
        }
    }

    Map<JGroupsAddress, PersistentUUID> createInitialCluster() {
        this.waitForClusterToForm(CACHE_NAME);
        LinkedHashMap<JGroupsAddress, PersistentUUID> addressMappings = new LinkedHashMap<JGroupsAddress, PersistentUUID>();
        for (int i = 0; i < this.getClusterSize(); ++i) {
            LocalTopologyManager ltm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(i), LocalTopologyManager.class);
            PersistentUUID uuid = ltm.getPersistentUUID();
            AssertJUnit.assertNotNull((Object)uuid);
            addressMappings.put((JGroupsAddress)this.manager(i).getAddress(), uuid);
        }
        this.fillData();
        this.checkData();
        return addressMappings;
    }

    private void fillData() {
        for (int i = 0; i < 100; ++i) {
            this.cache(0, CACHE_NAME).put((Object)String.valueOf(i), (Object)String.valueOf(i));
        }
    }

    private boolean isEquivalent(Map<JGroupsAddress, PersistentUUID> addressMapping, ConsistentHash oldConsistentHash, ConsistentHash newConsistentHash, PersistentUUIDManager persistentUUIDManager) {
        if (oldConsistentHash.getNumSegments() != newConsistentHash.getNumSegments()) {
            return false;
        }
        for (int i = 0; i < oldConsistentHash.getMembers().size(); ++i) {
            Set newSegmentsForOwner;
            JGroupsAddress newAddress;
            JGroupsAddress oldAddress = (JGroupsAddress)oldConsistentHash.getMembers().get(i);
            JGroupsAddress remappedOldAddress = (JGroupsAddress)persistentUUIDManager.getAddress(addressMapping.get(oldAddress));
            if (!remappedOldAddress.equals((Object)(newAddress = (JGroupsAddress)newConsistentHash.getMembers().get(i)))) {
                return false;
            }
            Set oldSegmentsForOwner = oldConsistentHash.getSegmentsForOwner((Address)oldAddress);
            if (oldSegmentsForOwner.equals(newSegmentsForOwner = newConsistentHash.getSegmentsForOwner((Address)newAddress))) continue;
            return false;
        }
        return true;
    }

    private void checkStateDirNotEmpty(String location) {
        File[] listFiles = new File(location).listFiles();
        AssertJUnit.assertTrue((listFiles.length > 0 ? 1 : 0) != 0);
    }

    private void reverseLinkedMap(Iterator<Map.Entry<JGroupsAddress, PersistentUUID>> iterator, Map<JGroupsAddress, PersistentUUID> reversed) {
        if (iterator.hasNext()) {
            Map.Entry<JGroupsAddress, PersistentUUID> entry = iterator.next();
            this.reverseLinkedMap(iterator, reversed);
            reversed.put(entry.getKey(), entry.getValue());
        }
    }
}

