/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.TestException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.UnknownCacheStartTest")
public class UnknownCacheStartTest
extends AbstractInfinispanTest {
    ConfigurationBuilder configuration;
    EmbeddedCacheManager cm1;
    EmbeddedCacheManager cm2;

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        this.configuration = AbstractCacheTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm1, this.cm2);
    }

    @Test(expectedExceptions={CacheException.class, TestException.class}, timeOut=60000L)
    public void testStartingUnknownCaches() throws Throwable {
        TestResourceTracker.testThreadStarted((String)this.getTestName());
        this.cm1 = TestCacheManagerFactory.createCacheManager(this.configuration);
        this.cm1.defineConfiguration("new_1", this.configuration.build());
        Cache c1 = this.cm1.getCache();
        Cache c1_new = this.cm1.getCache("new_1");
        c1.put((Object)"k", (Object)"v");
        c1_new.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)c1.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v", (String)((String)c1_new.get((Object)"k")));
        this.cm2 = TestCacheManagerFactory.createCacheManager(this.configuration);
        this.cm2.defineConfiguration("new_2", this.configuration.build());
        Cache c2 = this.cm2.getCache();
        Cache c2_new = this.cm2.getCache("new_AND_DEFINITELY_UNKNOWN_cache_2");
        c2.put((Object)"k", (Object)"v");
        c2_new.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)c2.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v", (String)((String)c2_new.get((Object)"k")));
        TestingUtil.blockUntilViewsReceived(60000L, false, c2, c2_new);
        TestingUtil.waitForNoRebalance(c2, c2_new);
        AssertJUnit.fail((String)"Should have thrown an exception!");
    }
}

