/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Queue;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolvers;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.MemoryStorageConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="configuration.EvictionConfigurationTest")
public class EvictionConfigurationTest
extends AbstractInfinispanTest {
    private static final ParserRegistry REGISTRY = new ParserRegistry();

    @Test
    public void testReuseLegacyBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().size(200L);
        Configuration configuration = builder.build();
        AssertJUnit.assertEquals((long)configuration.memory().maxSizeBytes(), (long)-1L);
        AssertJUnit.assertEquals((long)configuration.memory().maxCount(), (long)200L);
        AssertJUnit.assertEquals((Object)configuration.memory().storageType(), (Object)StorageType.HEAP);
        Configuration fromSameBuilder = builder.build();
        AssertJUnit.assertEquals((Object)configuration, (Object)fromSameBuilder);
    }

    @Test
    public void testReuseChangeLegacy() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().storageType(StorageType.OBJECT).size(12L);
        Configuration conf1 = builder.build();
        AssertJUnit.assertEquals((Object)conf1.memory().storageType(), (Object)StorageType.OBJECT);
        AssertJUnit.assertEquals((long)conf1.memory().size(), (long)12L);
        builder.memory().storageType(StorageType.BINARY);
        Configuration build2 = builder.build();
        AssertJUnit.assertEquals((Object)build2.memory().storageType(), (Object)StorageType.BINARY);
        AssertJUnit.assertEquals((long)build2.memory().size(), (long)12L);
    }

    @Test
    public void testEvictionDisabled() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().storageType(StorageType.BINARY);
        Configuration configuration = builder.build();
        AssertJUnit.assertEquals((Object)configuration.memory().storageType(), (Object)StorageType.BINARY);
        AssertJUnit.assertEquals((long)configuration.memory().maxSizeBytes(), (long)-1L);
        AssertJUnit.assertEquals((long)configuration.memory().maxCount(), (long)-1L);
        Configuration same = builder.build();
        AssertJUnit.assertEquals((Object)configuration, (Object)same);
    }

    @Test
    public void testLegacyConfigAvailable() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().maxSize("1.5 GB").storage(StorageType.HEAP).whenFull(EvictionStrategy.REMOVE);
        builder.encoding().mediaType("application/x-protostream");
        Configuration configuration = builder.build();
        AssertJUnit.assertEquals((long)configuration.memory().maxSizeBytes(), (long)1500000000L);
        AssertJUnit.assertEquals((long)configuration.memory().maxCount(), (long)-1L);
        AssertJUnit.assertEquals((Object)configuration.memory().whenFull(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((Object)configuration.memory().storageType(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((Object)configuration.memory().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((long)configuration.memory().size(), (long)1500000000L);
        AssertJUnit.assertEquals((Object)configuration.memory().evictionType(), (Object)EvictionType.MEMORY);
        Configuration same = builder.build();
        AssertJUnit.assertEquals((Object)configuration.memory(), (Object)same.memory());
        Configuration larger = builder.memory().maxSize("2.0 GB").build();
        AssertJUnit.assertEquals((long)larger.memory().maxSizeBytes(), (long)2000000000L);
        AssertJUnit.assertEquals((long)larger.memory().maxCount(), (long)-1L);
        AssertJUnit.assertEquals((Object)larger.memory().whenFull(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((Object)larger.memory().storage(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((Object)larger.memory().storageType(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((Object)larger.memory().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((long)larger.memory().size(), (long)2000000000L);
        AssertJUnit.assertEquals((Object)larger.memory().evictionType(), (Object)EvictionType.MEMORY);
    }

    public void testUseDefaultEviction() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().mediaType("application/x-protostream");
        Configuration configuration = builder.build();
        AssertJUnit.assertFalse((boolean)configuration.memory().isEvictionEnabled());
        AssertJUnit.assertEquals((Object)configuration.memory().storage(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((Object)configuration.memory().storageType(), (Object)StorageType.HEAP);
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testPreventUsingLegacyAndNew() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().size(44L).evictionType(EvictionType.COUNT);
        Configuration conf = builder.build();
        AssertJUnit.assertEquals((long)conf.memory().maxCount(), (long)44L);
        builder.memory().maxCount(10L).size(12L);
        builder.build();
    }

    @Test
    public void testMinimal() {
        Configuration configuration = new ConfigurationBuilder().build();
        AssertJUnit.assertFalse((boolean)configuration.memory().isOffHeap());
        AssertJUnit.assertEquals((long)configuration.memory().maxCount(), (long)-1L);
        AssertJUnit.assertEquals((long)configuration.memory().maxSizeBytes(), (long)-1L);
        AssertJUnit.assertEquals((Object)configuration.memory().storageType(), (Object)StorageType.HEAP);
    }

    @Test
    public void testChangeFromMinimal() {
        ConfigurationBuilder initial = new ConfigurationBuilder();
        Configuration initialConfig = initial.build();
        AssertJUnit.assertEquals((Object)initialConfig.memory().storageType(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((long)initialConfig.memory().size(), (long)-1L);
        initial.memory().size(3L);
        Configuration larger = initial.build();
        AssertJUnit.assertEquals((Object)larger.memory().storageType(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((long)larger.memory().size(), (long)3L);
        AssertJUnit.assertEquals((long)larger.memory().maxCount(), (long)3L);
        AssertJUnit.assertEquals((Object)larger.memory().storage(), (Object)StorageType.HEAP);
    }

    @Test
    public void testRuntimeConfigChanges() {
        Configuration countBounded = new ConfigurationBuilder().memory().maxCount(1000L).build();
        Configuration sizeBounded = new ConfigurationBuilder().memory().maxSize("10 MB").storage(StorageType.OFF_HEAP).build();
        countBounded.memory().maxCount(1200L);
        sizeBounded.memory().maxSize("20MB");
        AssertJUnit.assertEquals((long)countBounded.memory().maxCount(), (long)1200L);
        AssertJUnit.assertEquals((long)sizeBounded.memory().maxSizeBytes(), (long)20000000L);
        Exceptions.expectException(CacheConfigurationException.class, () -> countBounded.memory().maxSize("30MB"));
        Exceptions.expectException(CacheConfigurationException.class, () -> sizeBounded.memory().maxCount(2000L));
    }

    @Test
    public void testParseXML() {
        String xml = "<infinispan>\n   <cache-container>\n      <local-cache name=\"local\">\n         <memory storage=\"OFF_HEAP\" max-size=\"200 MB\" when-full=\"MANUAL\" />\n      </local-cache>\n   </cache-container>\n</infinispan>";
        this.testSerializationAndBack(xml);
        ConfigurationBuilderHolder parsed = new ParserRegistry().parse(xml);
        ConfigurationBuilder parsedBuilder = (ConfigurationBuilder)parsed.getNamedConfigurationBuilders().get("local");
        Configuration afterParsing = parsedBuilder.build();
        AssertJUnit.assertEquals((long)afterParsing.memory().maxSizeBytes(), (long)200000000L);
        AssertJUnit.assertEquals((long)afterParsing.memory().maxCount(), (long)-1L);
        AssertJUnit.assertEquals((Object)afterParsing.memory().storageType(), (Object)StorageType.OFF_HEAP);
        AssertJUnit.assertEquals((Object)afterParsing.memory().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((long)afterParsing.memory().size(), (long)200000000L);
        AssertJUnit.assertEquals((Object)afterParsing.memory().evictionType(), (Object)EvictionType.MEMORY);
        AssertJUnit.assertEquals((Object)afterParsing.memory().heapConfiguration().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
    }

    @Test
    public void testParseXML2() {
        String xmlNew = "<infinispan>\n   <cache-container>\n      <local-cache name=\"local\">\n         <memory max-count=\"2000\" when-full=\"REMOVE\" />\n      </local-cache>\n   </cache-container>\n</infinispan>";
        this.testSerializationAndBack(xmlNew);
        ConfigurationBuilderHolder parsed = new ParserRegistry().parse(xmlNew);
        ConfigurationBuilder parsedBuilder = (ConfigurationBuilder)parsed.getNamedConfigurationBuilders().get("local");
        Configuration afterParsing = parsedBuilder.build();
        AssertJUnit.assertEquals((long)afterParsing.memory().maxCount(), (long)2000L);
        AssertJUnit.assertEquals((Object)afterParsing.memory().whenFull(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((Object)afterParsing.memory().storageType(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((Object)afterParsing.memory().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((long)afterParsing.memory().size(), (long)2000L);
        AssertJUnit.assertEquals((Object)afterParsing.memory().evictionType(), (Object)EvictionType.COUNT);
        AssertJUnit.assertEquals((Object)afterParsing.memory().heapConfiguration().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
    }

    @Test
    public void testParseXML3() {
        String xmlNew = "<infinispan>\n   <cache-container>\n      <local-cache name=\"local\">\n         <encoding media-type=\"application/json\" />\n         <memory storage=\"HEAP\" max-size=\"1MB\" when-full=\"REMOVE\"/>\n      </local-cache>\n   </cache-container>\n</infinispan>";
        this.testSerializationAndBack(xmlNew);
        ConfigurationBuilderHolder parsed = new ParserRegistry().parse(xmlNew);
        ConfigurationBuilder parsedBuilder = (ConfigurationBuilder)parsed.getNamedConfigurationBuilders().get("local");
        Configuration afterParsing = parsedBuilder.build();
        AssertJUnit.assertTrue((boolean)afterParsing.memory().isEvictionEnabled());
        AssertJUnit.assertEquals((Object)afterParsing.memory().storage(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((long)afterParsing.memory().maxSizeBytes(), (long)1000000L);
        AssertJUnit.assertEquals((Object)afterParsing.memory().whenFull(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((Object)afterParsing.memory().storageType(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((long)afterParsing.memory().size(), (long)1000000L);
        AssertJUnit.assertEquals((Object)afterParsing.memory().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((Object)afterParsing.memory().evictionType(), (Object)EvictionType.MEMORY);
    }

    @Test
    public void testParseJSON() {
        ConfigurationBuilderHolder holder = new ParserRegistry().parse("{\"local-cache\":{ \"memory\":{\"storage\":\"HEAP\",\"when-full\":\"REMOVE\",\"max-count\":5000}}}}", MediaType.APPLICATION_JSON);
        Configuration fromJson = holder.getCurrentConfigurationBuilder().build();
        AssertJUnit.assertEquals((long)fromJson.memory().maxSizeBytes(), (long)-1L);
        AssertJUnit.assertEquals((long)fromJson.memory().maxCount(), (long)5000L);
        AssertJUnit.assertEquals((Object)fromJson.memory().storageType(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((Object)fromJson.memory().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((long)fromJson.memory().size(), (long)5000L);
        AssertJUnit.assertEquals((Object)fromJson.memory().evictionType(), (Object)EvictionType.COUNT);
        AssertJUnit.assertEquals((Object)fromJson.memory().heapConfiguration().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
    }

    @Test
    public void testParseLegacyJSON() {
        ConfigurationBuilderHolder holder = new ParserRegistry().parse("{\"local-cache\":{ \"memory\":{\"storage\":\"OBJECT\", \"when-full\":\"REMOVE\",\"max-count\":5000}}}", MediaType.APPLICATION_JSON);
        Configuration fromJson = holder.getCurrentConfigurationBuilder().build();
        AssertJUnit.assertEquals((long)fromJson.memory().maxSizeBytes(), (long)-1L);
        AssertJUnit.assertEquals((long)fromJson.memory().maxCount(), (long)5000L);
        AssertJUnit.assertEquals((Object)fromJson.memory().storageType(), (Object)StorageType.OBJECT);
        AssertJUnit.assertEquals((Object)fromJson.memory().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
        AssertJUnit.assertEquals((long)fromJson.memory().size(), (long)5000L);
        AssertJUnit.assertEquals((Object)fromJson.memory().evictionType(), (Object)EvictionType.COUNT);
        AssertJUnit.assertEquals((Object)fromJson.memory().heapConfiguration().evictionStrategy(), (Object)EvictionStrategy.REMOVE);
    }

    @Test
    public void testBuildWithLegacyConfiguration() {
        ConfigurationBuilder configBuilder = new ConfigurationBuilder();
        configBuilder.memory().storageType(StorageType.OFF_HEAP).size(1000L).evictionType(EvictionType.COUNT);
        Configuration configuration = configBuilder.build();
        Configuration afterRead = new ConfigurationBuilder().read(configuration, Combine.DEFAULT).build();
        AssertJUnit.assertEquals((Object)StorageType.OFF_HEAP, (Object)afterRead.memory().storage());
        AssertJUnit.assertEquals((Object)EvictionStrategy.REMOVE, (Object)afterRead.memory().whenFull());
        AssertJUnit.assertEquals((long)1000L, (long)afterRead.memory().maxCount());
        AssertJUnit.assertEquals((long)-1L, (long)afterRead.memory().maxSizeBytes());
        AssertJUnit.assertEquals((Object)StorageType.OFF_HEAP, (Object)afterRead.memory().storageType());
        AssertJUnit.assertEquals((Object)EvictionStrategy.REMOVE, (Object)afterRead.memory().evictionStrategy());
        AssertJUnit.assertEquals((long)1000L, (long)afterRead.memory().size());
        AssertJUnit.assertEquals((Object)EvictionType.COUNT, (Object)afterRead.memory().evictionType());
        AssertJUnit.assertEquals((Object)EvictionStrategy.REMOVE, (Object)afterRead.memory().heapConfiguration().evictionStrategy());
    }

    @Test
    public void testBuildWithLegacyConfiguration2() {
        ConfigurationBuilder configBuilder = new ConfigurationBuilder();
        configBuilder.memory().storageType(StorageType.HEAP).size(120L);
        Configuration afterRead = new ConfigurationBuilder().read(configBuilder.build(), Combine.DEFAULT).build();
        AssertJUnit.assertEquals((long)afterRead.memory().maxSizeBytes(), (long)-1L);
        AssertJUnit.assertEquals((long)afterRead.memory().maxCount(), (long)120L);
        AssertJUnit.assertEquals((Object)afterRead.memory().storageType(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((long)afterRead.memory().size(), (long)120L);
        AssertJUnit.assertEquals((Object)afterRead.memory().evictionType(), (Object)EvictionType.COUNT);
        ConfigurationBuilder override = new ConfigurationBuilder().read(afterRead, Combine.DEFAULT);
        Configuration overridden = override.memory().size(400L).build();
        AssertJUnit.assertEquals((long)overridden.memory().maxSizeBytes(), (long)-1L);
        AssertJUnit.assertEquals((long)overridden.memory().maxCount(), (long)400L);
        AssertJUnit.assertEquals((Object)overridden.memory().storageType(), (Object)StorageType.HEAP);
        AssertJUnit.assertEquals((long)overridden.memory().size(), (long)400L);
        AssertJUnit.assertEquals((Object)overridden.memory().evictionType(), (Object)EvictionType.COUNT);
    }

    public void testListenToCountChanges() {
        ConfigurationBuilder countBuilder = new ConfigurationBuilder();
        countBuilder.memory().storage(StorageType.HEAP).maxCount(20L);
        Configuration configuration = countBuilder.build();
        AssertJUnit.assertEquals((Object)EvictionType.COUNT, (Object)configuration.memory().evictionType());
        ArrayDeque<Object> sizeListenerQueue = new ArrayDeque<Object>(1);
        ArrayDeque<Object> maxCountListenerQueue = new ArrayDeque<Object>(1);
        ArrayDeque<Object> maxSizeListenerQueue = new ArrayDeque<Object>(1);
        this.setUpListeners(configuration, sizeListenerQueue, maxCountListenerQueue, maxSizeListenerQueue);
        configuration.memory().size(100L);
        this.assertCountUpdate(configuration, 100L, sizeListenerQueue, maxCountListenerQueue, maxSizeListenerQueue);
        configuration.memory().heapConfiguration().size(200L);
        this.assertCountUpdate(configuration, 200L, sizeListenerQueue, maxCountListenerQueue, maxSizeListenerQueue);
        configuration.memory().maxCount(300L);
        this.assertCountUpdate(configuration, 300L, sizeListenerQueue, maxCountListenerQueue, maxSizeListenerQueue);
    }

    public void testListenToSizeChanges() {
        ConfigurationBuilder sizeBuilder = new ConfigurationBuilder();
        sizeBuilder.memory().storage(StorageType.HEAP).maxSize("20");
        sizeBuilder.encoding().mediaType("application/x-protostream");
        Configuration configuration = sizeBuilder.build();
        AssertJUnit.assertEquals((Object)EvictionType.MEMORY, (Object)configuration.memory().evictionType());
        ArrayDeque<Object> sizeListenerQueue = new ArrayDeque<Object>(1);
        ArrayDeque<Object> maxSizeListenerQueue = new ArrayDeque<Object>(1);
        ArrayDeque<Object> maxCountListenerQueue = new ArrayDeque<Object>(1);
        this.setUpListeners(configuration, sizeListenerQueue, maxCountListenerQueue, maxSizeListenerQueue);
        configuration.memory().size(100L);
        this.assertSizeUpdate(configuration, 100L, sizeListenerQueue, maxCountListenerQueue, maxSizeListenerQueue);
        configuration.memory().heapConfiguration().size(200L);
        this.assertSizeUpdate(configuration, 200L, sizeListenerQueue, maxCountListenerQueue, maxSizeListenerQueue);
        configuration.memory().maxSize("300");
        this.assertSizeUpdate(configuration, 300L, sizeListenerQueue, maxCountListenerQueue, maxSizeListenerQueue);
    }

    private void setUpListeners(Configuration configuration, Queue<Object> sizeListenerQueue, Queue<Object> maxCountListenerQueue, Queue<Object> maxSizeListenerQueue) {
        configuration.memory().heapConfiguration().attributes().attribute(MemoryStorageConfiguration.SIZE).addListener((attribute, oldValue) -> sizeListenerQueue.add(attribute.get()));
        configuration.memory().attributes().attribute(MemoryConfiguration.MAX_COUNT).addListener((attribute, oldValue) -> maxCountListenerQueue.add(attribute.get()));
        configuration.memory().attributes().attribute(MemoryConfiguration.MAX_SIZE).addListener((attribute, oldValue) -> maxSizeListenerQueue.add(attribute.get()));
    }

    private void assertCountUpdate(Configuration configuration, long newValue, Queue<Object> sizeListenerQueue, Queue<Object> maxCountListenerQueue, Queue<Object> maxSizeListenerQueue) {
        AssertJUnit.assertEquals((long)newValue, (long)configuration.memory().size());
        AssertJUnit.assertEquals((Object)newValue, (Object)sizeListenerQueue.poll());
        AssertJUnit.assertEquals((long)newValue, (long)configuration.memory().maxCount());
        AssertJUnit.assertEquals((Object)newValue, (Object)maxCountListenerQueue.poll());
        AssertJUnit.assertEquals((long)-1L, (long)configuration.memory().maxSizeBytes());
        AssertJUnit.assertEquals((int)0, (int)maxSizeListenerQueue.size());
    }

    private void assertSizeUpdate(Configuration configuration, long newValue, Queue<Object> sizeListenerQueue, Queue<Object> maxCountListenerQueue, Queue<Object> maxSizeListenerQueue) {
        AssertJUnit.assertEquals((long)newValue, (long)configuration.memory().size());
        AssertJUnit.assertEquals((Object)newValue, (Object)sizeListenerQueue.poll());
        AssertJUnit.assertEquals((String)String.valueOf(newValue), (String)configuration.memory().maxSize());
        AssertJUnit.assertEquals((long)newValue, (long)configuration.memory().maxSizeBytes());
        AssertJUnit.assertEquals((Object)String.valueOf(newValue), (Object)maxSizeListenerQueue.poll());
        AssertJUnit.assertEquals((long)-1L, (long)configuration.memory().maxCount());
        AssertJUnit.assertEquals((int)0, (int)maxCountListenerQueue.size());
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp=".*Cannot configure both maxCount and maxSize.*")
    public void testErrorForMultipleThresholds() {
        ConfigurationBuilder configBuilder = new ConfigurationBuilder();
        configBuilder.memory().storage(StorageType.OFF_HEAP).maxCount(10L).maxSize("10TB").build();
    }

    private void testSerializationAndBack(String xml) {
        ConfigurationBuilderHolder configurationBuilderHolder = REGISTRY.parse(xml);
        ConfigurationBuilder builder = (ConfigurationBuilder)configurationBuilderHolder.getNamedConfigurationBuilders().get("local");
        Configuration before = builder.build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        REGISTRY.serialize((OutputStream)baos, "local", before);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ConfigurationBuilderHolder holderAfter = REGISTRY.parse((InputStream)bais, ConfigurationResourceResolvers.DEFAULT, MediaType.APPLICATION_XML);
        ConfigurationBuilder afterParsing = (ConfigurationBuilder)holderAfter.getNamedConfigurationBuilders().get("local");
        Configuration after = afterParsing.build();
        AssertJUnit.assertEquals((Object)after.memory(), (Object)before.memory());
    }
}

