/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.Arrays;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.ByteArrayCacheTest")
@CleanupAfterMethod
public class ByteArrayCacheTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    public void testByteArrayValueOnlyReplace() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            @Override
            public void call() {
                Cache cache = this.cm.getCache();
                Integer key = 2;
                byte[] value = new byte[]{1, 2, 3};
                cache.put((Object)key, (Object)value);
                byte[] oldValue = new byte[]{1, 2, 3};
                byte[] newValue = new byte[]{4, 5, 6};
                AssertJUnit.assertTrue((boolean)cache.replace((Object)key, (Object)oldValue, (Object)newValue));
            }
        });
    }

    public void testByteArrayGet() {
        Cache<byte[], byte[]> map = this.cache();
        byte[] key = new byte[]{1, 2, 3};
        byte[] value = new byte[]{4, 5, 6};
        map.put(key, value);
        byte[] lookupKey = new byte[]{1, 2, 3};
        AssertJUnit.assertTrue((String)String.format("Expected key=%s to return value=%s", Util.toStr((Object)lookupKey), Util.toStr((Object)value)), (boolean)Arrays.equals(value, (byte[])map.get(lookupKey)));
    }
}

