/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Arrays;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="tx.TransactionsSpanningReplicatedCachesTest")
public class TransactionsSpanningReplicatedCachesTest
extends MultipleCacheManagersTest {
    public TransactionsSpanningReplicatedCachesTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Exception {
        ConfigurationBuilder c = this.getConfiguration();
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.defineConfigurationOnAllManagers("c1", c);
        this.defineConfigurationOnAllManagers("c2", c);
        this.defineConfigurationOnAllManagers("cache1", c);
        this.defineConfigurationOnAllManagers("cache2", c);
        this.waitForClusterToForm("c1", "c2", "cache1", "cache2", this.getDefaultCacheName());
    }

    protected ConfigurationBuilder getConfiguration() {
        ConfigurationBuilder c = TransactionsSpanningReplicatedCachesTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        c.statistics().enable();
        return c;
    }

    public void testReadOnlyTransaction() throws Exception {
        Cache c1 = this.cache(0);
        Cache c2 = this.cache(1);
        RpcManagerImpl ri = (RpcManagerImpl)c1.getAdvancedCache().getRpcManager();
        c1.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)c1.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v", (String)((String)c2.get((Object)"k")));
        long oldRC = ri.getReplicationCount();
        c1.getAdvancedCache().getTransactionManager().begin();
        AssertJUnit.assertEquals((String)"v", (String)((String)c1.get((Object)"k")));
        c1.getAdvancedCache().getTransactionManager().commit();
        AssertJUnit.assertEquals((long)ri.getReplicationCount(), (long)oldRC);
    }

    public void testCommitSpanningCaches() throws Exception {
        Cache c1 = this.cache(0, "c1");
        Cache c1Replica = this.cache(1, "c1");
        Cache c2 = this.cache(0, "c2");
        Cache c2Replica = this.cache(1, "c2");
        AssertJUnit.assertTrue((boolean)c1.isEmpty());
        AssertJUnit.assertTrue((boolean)c2.isEmpty());
        AssertJUnit.assertTrue((boolean)c1Replica.isEmpty());
        AssertJUnit.assertTrue((boolean)c2Replica.isEmpty());
        c1.put((Object)"c1key", (Object)"c1value");
        c2.put((Object)"c2key", (Object)"c2value");
        this.assertInitialValues(c1, c1Replica, c2, c2Replica);
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        c1.put((Object)"c1key", (Object)"c1value_new");
        c2.put((Object)"c2key", (Object)"c2value_new");
        AssertJUnit.assertEquals((String)((String)c1.get((Object)"c1key")), (String)"c1value_new");
        AssertJUnit.assertEquals((String)((String)c1Replica.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c2.get((Object)"c2key")), (String)"c2value_new");
        AssertJUnit.assertEquals((String)((String)c2Replica.get((Object)"c2key")), (String)"c2value");
        Transaction tx = tm.suspend();
        this.assertInitialValues(c1, c1Replica, c2, c2Replica);
        tm.resume(tx);
        log.trace((Object)"before commit...");
        tm.commit();
        AssertJUnit.assertEquals((String)((String)c1.get((Object)"c1key")), (String)"c1value_new");
        AssertJUnit.assertEquals((String)((String)c1Replica.get((Object)"c1key")), (String)"c1value_new");
        AssertJUnit.assertEquals((String)((String)c2.get((Object)"c2key")), (String)"c2value_new");
        AssertJUnit.assertEquals((String)((String)c2Replica.get((Object)"c2key")), (String)"c2value_new");
    }

    public void testRollbackSpanningCaches() throws Exception {
        Cache c1 = this.cache(0, "c1");
        Cache c1Replica = this.cache(1, "c1");
        Cache c2 = this.cache(0, "c2");
        Cache c2Replica = this.cache(1, "c2");
        AssertJUnit.assertTrue((boolean)c1.isEmpty());
        AssertJUnit.assertTrue((boolean)c2.isEmpty());
        AssertJUnit.assertTrue((boolean)c1Replica.isEmpty());
        AssertJUnit.assertTrue((boolean)c2Replica.isEmpty());
        c1.put((Object)"c1key", (Object)"c1value");
        c2.put((Object)"c2key", (Object)"c2value");
        this.assertInitialValues(c1, c1Replica, c2, c2Replica);
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        c1.put((Object)"c1key", (Object)"c1value_new");
        c2.put((Object)"c2key", (Object)"c2value_new");
        AssertJUnit.assertEquals((String)((String)c1.get((Object)"c1key")), (String)"c1value_new");
        AssertJUnit.assertEquals((String)((String)c1Replica.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c2.get((Object)"c2key")), (String)"c2value_new");
        AssertJUnit.assertEquals((String)((String)c2Replica.get((Object)"c2key")), (String)"c2value");
        Transaction tx = tm.suspend();
        AssertJUnit.assertEquals((String)((String)c1.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c1Replica.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c2.get((Object)"c2key")), (String)"c2value");
        AssertJUnit.assertEquals((String)((String)c2Replica.get((Object)"c2key")), (String)"c2value");
        tm.resume(tx);
        tm.rollback();
        AssertJUnit.assertEquals((String)((String)c1.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c1Replica.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c2.get((Object)"c2key")), (String)"c2value");
        AssertJUnit.assertEquals((String)"c2value", (String)((String)c2Replica.get((Object)"c2key")));
    }

    private void assertInitialValues(Cache<String, String> c1, Cache<String, String> c1Replica, Cache<String, String> c2, Cache<String, String> c2Replica) {
        for (Cache c : Arrays.asList(c1, c1Replica)) {
            AssertJUnit.assertEquals((int)c.size(), (int)1);
            AssertJUnit.assertEquals((String)((String)c.get((Object)"c1key")), (String)"c1value");
        }
        for (Cache c : Arrays.asList(c2, c2Replica)) {
            AssertJUnit.assertEquals((int)c.size(), (int)1);
            AssertJUnit.assertEquals((String)((String)c.get((Object)"c2key")), (String)"c2value");
        }
    }

    public void testRollbackSpanningCaches2() throws Exception {
        Cache c1 = this.cache(0, "c1");
        AssertJUnit.assertTrue((boolean)c1.getCacheConfiguration().clustering().cacheMode().isClustered());
        Cache c1Replica = this.cache(1, "c1");
        AssertJUnit.assertTrue((boolean)c1.isEmpty());
        AssertJUnit.assertTrue((boolean)c1Replica.isEmpty());
        c1.put((Object)"c1key", (Object)"c1value");
        AssertJUnit.assertEquals((String)((String)c1.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c1Replica.get((Object)"c1key")), (String)"c1value");
    }

    public void testSimpleCommit() throws Exception {
        Cache c1 = this.cache(0, "c1");
        Cache c1Replica = this.cache(1, "c1");
        AssertJUnit.assertTrue((boolean)c1.isEmpty());
        AssertJUnit.assertTrue((boolean)c1Replica.isEmpty());
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        c1.put((Object)"c1key", (Object)"c1value");
        tm.commit();
        AssertJUnit.assertEquals((String)((String)c1.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c1Replica.get((Object)"c1key")), (String)"c1value");
    }

    public void testPutIfAbsent() throws Exception {
        Cache c1 = this.cache(0, "c1");
        Cache c1Replica = this.cache(1, "c1");
        AssertJUnit.assertTrue((boolean)c1.isEmpty());
        AssertJUnit.assertTrue((boolean)c1Replica.isEmpty());
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        c1.put((Object)"c1key", (Object)"c1value");
        tm.commit();
        AssertJUnit.assertEquals((String)((String)c1.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c1Replica.get((Object)"c1key")), (String)"c1value");
        tm.begin();
        c1.putIfAbsent((Object)"c1key", (Object)"SHOULD_NOT_GET_INSERTED");
        tm.commit();
        AssertJUnit.assertEquals((String)((String)c1.get((Object)"c1key")), (String)"c1value");
        AssertJUnit.assertEquals((String)((String)c1Replica.get((Object)"c1key")), (String)"c1value");
    }

    public void testTwoNamedCachesSameNode() throws Exception {
        this.runTest(this.cache(0, "cache1"), this.cache(0, "cache2"));
    }

    public void testDefaultCacheAndNamedCacheSameNode() throws Exception {
        this.runTest(this.cache(0), this.cache(0, "cache1"));
    }

    public void testTwoNamedCachesDifferentNodes() throws Exception {
        this.runTest(this.cache(0, "cache1"), this.cache(1, "cache2"));
    }

    public void testDefaultCacheAndNamedCacheDifferentNodes() throws Exception {
        this.runTest(this.cache(0), this.cache(1, "cache1"));
    }

    private void runTest(Cache<String, String> cache1, Cache<String, String> cache2) throws Exception {
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"a"));
        AssertJUnit.assertFalse((boolean)cache2.containsKey((Object)"b"));
        TransactionManager tm = TestingUtil.getTransactionManager(cache1);
        tm.begin();
        cache1.put((Object)"a", (Object)"value1");
        cache2.put((Object)"b", (Object)"value2");
        tm.commit();
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache1.get((Object)"a")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"b")));
        tm.begin();
        cache1.remove((Object)"a");
        cache2.remove((Object)"b");
        tm.commit();
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"a"));
        AssertJUnit.assertFalse((boolean)cache2.containsKey((Object)"b"));
    }
}

