/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.Transaction;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.ContextAffectsTransactionReadCommittedTest")
public class ContextAffectsTransactionReadCommittedTest
extends SingleCacheManagerTest {
    protected StorageType storage;

    @Factory
    public Object[] factory() {
        return new Object[]{new ContextAffectsTransactionReadCommittedTest().withStorage(StorageType.BINARY), new ContextAffectsTransactionReadCommittedTest().withStorage(StorageType.OBJECT), new ContextAffectsTransactionReadCommittedTest().withStorage(StorageType.OFF_HEAP)};
    }

    public ContextAffectsTransactionReadCommittedTest withStorage(StorageType storage) {
        this.storage = storage;
        return this;
    }

    @Override
    protected String parameters() {
        return "[storage=" + String.valueOf(this.storage) + "]";
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.memory().storageType(this.storage);
        this.configure(builder);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    protected void configure(ConfigurationBuilder builder) {
        builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
    }

    public void testSizeAfterClearInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
            this.cache.clear();
            AssertJUnit.assertEquals((int)1, (int)this.cache.size());
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
        }
        finally {
            this.safeCommit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntrySetAfterClearInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
            this.cache.clear();
            CacheSet entrySet = this.cache.entrySet();
            AssertJUnit.assertEquals((int)1, (int)entrySet.size());
            AssertJUnit.assertTrue((boolean)entrySet.contains(TestingUtil.createMapEntry(1, "v1")));
            Iterator iterator = entrySet.iterator();
            Map.Entry entry = (Map.Entry)iterator.next();
            AssertJUnit.assertEquals((Object)1, entry.getKey());
            AssertJUnit.assertEquals((Object)"v1", entry.getValue());
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
        }
        finally {
            this.safeCommit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testKeySetAfterClearInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
            this.cache.clear();
            CacheSet keySet = this.cache.keySet();
            AssertJUnit.assertEquals((int)1, (int)keySet.size());
            AssertJUnit.assertTrue((boolean)keySet.contains(1));
            Iterator iterator = keySet.iterator();
            Object key = iterator.next();
            AssertJUnit.assertEquals((Object)1, key);
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
        }
        finally {
            this.safeCommit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValuesAfterClearInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
            this.cache.clear();
            CacheCollection values = this.cache.values();
            AssertJUnit.assertEquals((int)1, (int)values.size());
            AssertJUnit.assertTrue((boolean)values.contains("v1"));
            Iterator iterator = values.iterator();
            Object value = iterator.next();
            AssertJUnit.assertEquals((Object)"v1", value);
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
        }
        finally {
            this.safeCommit(false);
        }
    }

    public void testSizeAfterClearInBranchedTransactionOnWrite() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.put((Object)1, (Object)"v2"));
            this.cache.clear();
            AssertJUnit.assertEquals((int)1, (int)this.cache.size());
            AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get((Object)1));
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testEntrySetAfterClearInBranchedTransactionOnWrite() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.put((Object)1, (Object)"v2"));
            this.cache.clear();
            CacheSet entrySet = this.cache.entrySet();
            AssertJUnit.assertEquals((int)1, (int)entrySet.size());
            Map.Entry entry = (Map.Entry)entrySet.iterator().next();
            AssertJUnit.assertEquals((Object)1, entry.getKey());
            AssertJUnit.assertEquals((Object)"v2", entry.getValue());
            AssertJUnit.assertTrue((boolean)entrySet.contains(TestingUtil.createMapEntry(1, "v2")));
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testKeySetAfterClearInBranchedTransactionOnWrite() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.put((Object)1, (Object)"v2"));
            this.cache.clear();
            CacheSet keySet = this.cache.keySet();
            AssertJUnit.assertEquals((int)1, (int)keySet.size());
            AssertJUnit.assertTrue((boolean)keySet.contains(1));
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testValuesAfterClearInBranchedTransactionOnWrite() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.put((Object)1, (Object)"v2"));
            this.cache.clear();
            CacheCollection values = this.cache.values();
            AssertJUnit.assertEquals((int)1, (int)values.size());
            AssertJUnit.assertTrue((boolean)values.contains("v2"));
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testSizeAfterRemoveInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.cache.put((Object)2, (Object)"v2");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
            Transaction suspended = this.tm().suspend();
            this.cache.remove((Object)1);
            this.tm().resume(suspended);
            AssertJUnit.assertEquals((int)2, (int)this.cache.size());
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
            AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get((Object)2));
        }
        finally {
            this.safeCommit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntrySetAfterRemoveInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.cache.put((Object)2, (Object)"v2");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
            Transaction suspended = this.tm().suspend();
            this.cache.remove((Object)1);
            this.tm().resume(suspended);
            CacheSet entrySet = this.cache.entrySet();
            AssertJUnit.assertEquals((int)2, (int)entrySet.size());
            for (Map.Entry entry : entrySet) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (entry.getKey().equals(1)) {
                    AssertJUnit.assertEquals((Object)"v1", value);
                    continue;
                }
                if (key.equals(2)) {
                    AssertJUnit.assertEquals((Object)"v2", value);
                    continue;
                }
                AssertJUnit.fail((String)("Unexpected entry found: " + String.valueOf(entry)));
            }
            AssertJUnit.assertTrue((boolean)entrySet.contains(TestingUtil.createMapEntry(1, "v1")));
            AssertJUnit.assertTrue((boolean)entrySet.contains(TestingUtil.createMapEntry(2, "v2")));
        }
        finally {
            this.safeCommit(false);
        }
    }

    public void testKeySetAfterRemoveInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.cache.put((Object)2, (Object)"v2");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
            Transaction suspended = this.tm().suspend();
            this.cache.remove((Object)1);
            this.tm().resume(suspended);
            CacheSet keySet = this.cache.keySet();
            AssertJUnit.assertEquals((int)2, (int)keySet.size());
            AssertJUnit.assertTrue((boolean)keySet.contains(1));
            AssertJUnit.assertTrue((boolean)keySet.contains(2));
        }
        finally {
            this.safeCommit(false);
        }
    }

    public void testValuesAfterRemoveInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.cache.put((Object)2, (Object)"v2");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
            Transaction suspended = this.tm().suspend();
            this.cache.remove((Object)1);
            this.tm().resume(suspended);
            CacheCollection values = this.cache.values();
            AssertJUnit.assertEquals((int)2, (int)values.size());
            AssertJUnit.assertTrue((boolean)values.contains("v1"));
            AssertJUnit.assertTrue((boolean)values.contains("v2"));
        }
        finally {
            this.safeCommit(false);
        }
    }

    public void testSizeAfterDoubleRemoveInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.cache.put((Object)2, (Object)"v2");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            Transaction suspended = this.tm().suspend();
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            this.tm().resume(suspended);
            AssertJUnit.assertEquals((int)1, (int)this.cache.size());
            AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get((Object)2));
        }
        finally {
            this.safeCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntrySetAfterDoubleRemoveInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.cache.put((Object)2, (Object)"v2");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            Transaction suspended = this.tm().suspend();
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            this.tm().resume(suspended);
            CacheSet entrySet = this.cache.entrySet();
            AssertJUnit.assertEquals((int)1, (int)entrySet.size());
            Map.Entry entry = (Map.Entry)entrySet.iterator().next();
            AssertJUnit.assertEquals((Object)2, entry.getKey());
            AssertJUnit.assertEquals((Object)"v2", entry.getValue());
            AssertJUnit.assertTrue((boolean)entrySet.contains(TestingUtil.createMapEntry(2, "v2")));
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testKeySetAfterDoubleRemoveInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.cache.put((Object)2, (Object)"v2");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            Transaction suspended = this.tm().suspend();
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            this.tm().resume(suspended);
            CacheSet keySet = this.cache.keySet();
            AssertJUnit.assertEquals((int)1, (int)keySet.size());
            AssertJUnit.assertTrue((boolean)keySet.contains(2));
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testValuesAfterDoubleRemoveInBranchedTransaction() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.cache.put((Object)2, (Object)"v2");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            Transaction suspended = this.tm().suspend();
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            this.tm().resume(suspended);
            CacheCollection values = this.cache.values();
            AssertJUnit.assertEquals((int)1, (int)values.size());
            AssertJUnit.assertTrue((boolean)values.contains("v2"));
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testSizeAfterPutInBranchedTransactionButRemove() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            Transaction suspended = this.tm().suspend();
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.put((Object)1, (Object)"v2"));
            this.tm().resume(suspended);
            AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testEntrySetAfterPutInBranchedTransactionButRemove() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            Transaction suspended = this.tm().suspend();
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.put((Object)1, (Object)"v2"));
            this.tm().resume(suspended);
            CacheSet entrySet = this.cache.entrySet();
            AssertJUnit.assertEquals((int)0, (int)entrySet.size());
            AssertJUnit.assertFalse((boolean)entrySet.iterator().hasNext());
            AssertJUnit.assertFalse((boolean)entrySet.contains(TestingUtil.createMapEntry(1, "v2")));
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testKeySetAfterPutInBranchedTransactionButRemove() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            Transaction suspended = this.tm().suspend();
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.put((Object)1, (Object)"v2"));
            this.tm().resume(suspended);
            CacheSet keySet = this.cache.keySet();
            AssertJUnit.assertEquals((int)0, (int)keySet.size());
            AssertJUnit.assertFalse((boolean)keySet.iterator().hasNext());
            AssertJUnit.assertFalse((boolean)keySet.contains(1));
        }
        finally {
            this.safeCommit(true);
        }
    }

    public void testValuesAfterPutInBranchedTransactionButRemove() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.remove((Object)1));
            Transaction suspended = this.tm().suspend();
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.put((Object)1, (Object)"v2"));
            this.tm().resume(suspended);
            CacheCollection values = this.cache.values();
            AssertJUnit.assertEquals((int)0, (int)values.size());
            AssertJUnit.assertFalse((boolean)values.iterator().hasNext());
            AssertJUnit.assertFalse((boolean)values.contains("v2"));
        }
        finally {
            this.safeCommit(true);
        }
    }

    protected void safeCommit(boolean throwWriteSkew) throws Exception {
        this.tm().commit();
    }
}

