/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.MultiStoresFunctionalTest")
public abstract class MultiStoresFunctionalTest<TStoreConfigurationBuilder extends AbstractStoreConfigurationBuilder<?, ?>>
extends AbstractInfinispanTest {
    private static final long TIMEOUT = 10000L;

    protected abstract TStoreConfigurationBuilder buildCacheStoreConfig(PersistenceConfigurationBuilder var1, String var2) throws Exception;

    protected List<ConfigurationBuilder> configs(int n, Method method) throws Exception {
        ArrayList<ConfigurationBuilder> r = new ArrayList<ConfigurationBuilder>(n);
        for (int i = 0; i < n; ++i) {
            ConfigurationBuilder configBuilder = new ConfigurationBuilder();
            configBuilder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(2);
            this.buildCacheStoreConfig(configBuilder.persistence().passivation(false), method.getName() + i).purgeOnStartup(false).fetchPersistentState(true);
            r.add(configBuilder);
        }
        return r;
    }

    public void testStartStopOfBackupDoesntRewriteValue(Method m) throws Exception {
        final List<ConfigurationBuilder> configs = this.configs(2, m);
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createClusteredCacheManager(configs.get(0)), TestCacheManagerFactory.createClusteredCacheManager(configs.get(1))}){

            @Override
            public void call() {
                EmbeddedCacheManager cacheManager0 = this.cms[0];
                EmbeddedCacheManager cacheManager1 = this.cms[1];
                final Cache cache0 = cacheManager0.getCache();
                Cache cache1 = cacheManager1.getCache();
                TestingUtil.blockUntilViewsChanged(10000L, 2, cache0, cache1);
                cache0.put((Object)"KEY", (Object)"VALUE V1");
                AssertJUnit.assertEquals((String)"VALUE V1", (String)((String)cache1.get((Object)"KEY")));
                TestingUtil.killCacheManagers(cacheManager1);
                TestingUtil.blockUntilViewsChanged(10000L, 1, cache0);
                cache0.put((Object)"KEY", (Object)"VALUE V2");
                AssertJUnit.assertEquals((String)"VALUE V2", (String)((String)cache0.get((Object)"KEY")));
                TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)configs.get(1))){

                    @Override
                    public void call() {
                        Cache newCache = this.cm.getCache();
                        TestingUtil.blockUntilViewsChanged(10000L, 2, cache0, newCache);
                        AssertJUnit.assertEquals((String)"VALUE V2", (String)((String)newCache.get((Object)"KEY")));
                    }
                });
            }
        });
    }

    public void testStartStopOfBackupResurrectsDeletedKey(Method m) throws Exception {
        final List<ConfigurationBuilder> configs = this.configs(2, m);
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createClusteredCacheManager(configs.get(0)), TestCacheManagerFactory.createClusteredCacheManager(configs.get(1))}){

            @Override
            public void call() {
                EmbeddedCacheManager cacheManager0 = this.cms[0];
                EmbeddedCacheManager cacheManager1 = this.cms[1];
                final Cache cache0 = cacheManager0.getCache();
                Cache cache1 = cacheManager1.getCache();
                TestingUtil.blockUntilViewsChanged(10000L, 2, cache0, cache1);
                cache0.put((Object)"KEY2", (Object)"VALUE2 V1");
                AssertJUnit.assertEquals((String)"VALUE2 V1", (String)((String)cache1.get((Object)"KEY2")));
                TestingUtil.killCacheManagers(cacheManager1);
                TestingUtil.blockUntilViewsChanged(10000L, 1, cache0);
                cache0.put((Object)"KEY2", (Object)"VALUE2 V2");
                AssertJUnit.assertEquals((String)"VALUE2 V2", (String)((String)cache0.get((Object)"KEY2")));
                cache0.remove((Object)"KEY2");
                AssertJUnit.assertEquals(null, (String)((String)cache0.get((Object)"KEY2")));
                TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)configs.get(1))){

                    @Override
                    public void call() {
                        Cache newCache = this.cm.getCache();
                        TestingUtil.blockUntilViewsChanged(10000L, 2, cache0, newCache);
                        AssertJUnit.assertEquals((String)"VALUE2 V1", (String)((String)newCache.get((Object)"KEY2")));
                    }
                });
            }
        });
    }
}

