/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc.repeatable_read;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockTestBase;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.repeatable_read.RepeatableReadLockTest")
public class RepeatableReadLockTest
extends LockTestBase {
    public RepeatableReadLockTest() {
        this.repeatableRead = true;
    }

    public void testRepeatableReadWithRemove() throws Exception {
        LockTestBase.LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        AssertJUnit.assertNotNull((Object)cache.get((Object)"k"));
        Transaction reader = tm.suspend();
        tm.begin();
        AssertJUnit.assertNotNull((Object)cache.remove((Object)"k"));
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        tm.commit();
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        tm.resume(reader);
        AssertJUnit.assertNotNull((Object)cache.get((Object)"k"));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        tm.commit();
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        this.assertNoLocks();
    }

    public void testRepeatableReadWithEvict() throws Exception {
        LockTestBase.LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        AssertJUnit.assertNotNull((Object)cache.get((Object)"k"));
        Transaction reader = tm.suspend();
        tm.begin();
        cache.evict((Object)"k");
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        tm.commit();
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        tm.resume(reader);
        AssertJUnit.assertNotNull((Object)cache.get((Object)"k"));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        tm.commit();
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        this.assertNoLocks();
    }

    public void testRepeatableReadWithNull() throws Exception {
        LockTestBase.LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        tm.begin();
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        Transaction reader = tm.suspend();
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertNotNull((Object)cache.get((Object)"k"));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        tm.commit();
        AssertJUnit.assertNotNull((Object)cache.get((Object)"k"));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        tm.resume(reader);
        AssertJUnit.assertEquals(null, (String)((String)cache.get((Object)"k")));
        tm.commit();
        AssertJUnit.assertNotNull((Object)cache.get((Object)"k"));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        this.assertNoLocks();
    }

    public void testRepeatableReadWithNullRemoval() throws Exception {
        LockTestBase.LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        tm.begin();
        cache.get((Object)"a");
        Transaction tx = tm.suspend();
        cache.put((Object)"a", (Object)"v2");
        AssertJUnit.assertEquals((String)((String)cache.get((Object)"a")), (String)"v2");
        tm.resume(tx);
        AssertJUnit.assertEquals(null, (String)((String)cache.get((Object)"a")));
        cache.remove((Object)"a");
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        AssertJUnit.assertEquals((String)((String)cache.get((Object)"a")), (String)"v2");
    }

    @Override
    public void testLocksOnPutKeyVal() throws Exception {
        LockTestBase.LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        tm.getTransaction().runPrepare();
        this.assertLocked("k");
        tm.getTransaction().runCommit(false);
        tm.suspend();
        this.assertNoLocks();
        tm.begin();
        AssertJUnit.assertEquals((String)((String)cache.get((Object)"k")), (String)"v");
        this.assertNotLocked("k");
        tm.commit();
        this.assertNoLocks();
        tm.begin();
        cache.remove((Object)"k");
        tm.getTransaction().runPrepare();
        this.assertLocked("k");
        tm.getTransaction().runCommit(false);
        this.assertNoLocks();
    }
}

