/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor7;
import org.immutables.value.processor.encode.Type;

public final class TypeExtractor {
    public final Type.Factory factory;
    public final Type.Parameters parameters;
    public final Type.Parser parser;
    private final TypeConverter converter = new TypeConverter();

    public TypeExtractor(Type.Factory factory, Parameterizable context) {
        this.factory = factory;
        this.parameters = this.initParameters(context);
        this.parser = new Type.Parser(factory, this.parameters);
    }

    public TypeExtractor(Type.Factory factory, Type.Parameters parameters) {
        this.factory = factory;
        this.parameters = parameters;
        this.parser = new Type.Parser(factory, parameters);
    }

    public TypeExtractor withParameter(String name, Iterable<? extends Type.Defined> bounds) {
        return new TypeExtractor(this.factory, this.parameters.introduce(name, bounds));
    }

    ImmutableList<Type.Defined> getDefined(Iterable<? extends TypeMirror> bounds) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TypeMirror typeMirror : bounds) {
            builder.add((Object)((Type.Defined)this.get(typeMirror)));
        }
        return builder.build();
    }

    private Type.Parameters initParameters(Parameterizable context) {
        Type.Parameters parameters = this.factory.parameters();
        for (TypeParameterElement typeParameterElement : context.getTypeParameters()) {
            String name = typeParameterElement.getSimpleName().toString();
            Type.Parameters parameterForRecursion = parameters.recursive(name);
            List<Type.Defined> bounds = this.getBounds(parameterForRecursion, typeParameterElement);
            parameters = parameters.introduce(name, bounds);
        }
        return parameters;
    }

    private List<Type.Defined> getBounds(Type.Parameters parameters, TypeParameterElement p) {
        ArrayList<Type.Defined> bounds = new ArrayList<Type.Defined>();
        for (TypeMirror typeMirror : p.getBounds()) {
            bounds.add((Type.Defined)typeMirror.accept(this.converter, parameters));
        }
        return bounds;
    }

    public Type get(TypeMirror type) {
        return type.accept(this.converter, this.parameters);
    }

    class TypeConverter
    extends AbstractTypeVisitor7<Type, Type.Parameters> {
        TypeConverter() {
        }

        @Override
        public Type visitPrimitive(PrimitiveType t, Type.Parameters p) {
            return TypeExtractor.this.factory.primitive(t.toString());
        }

        @Override
        public Type visitArray(ArrayType t, Type.Parameters p) {
            return TypeExtractor.this.factory.array(t.getComponentType().accept(this, p));
        }

        @Override
        public Type visitDeclared(DeclaredType t, Type.Parameters p) {
            Type.Reference reference = TypeExtractor.this.factory.reference(this.qualifiedNameOf(t));
            List<? extends TypeMirror> typeArguments = t.getTypeArguments();
            if (typeArguments.isEmpty()) {
                return reference;
            }
            ArrayList<Type.Nonprimitive> args = new ArrayList<Type.Nonprimitive>();
            for (TypeMirror typeMirror : typeArguments) {
                args.add((Type.Nonprimitive)typeMirror.accept(this, p));
            }
            return TypeExtractor.this.factory.parameterized(reference, args);
        }

        private String qualifiedNameOf(DeclaredType t) {
            return ((TypeElement)t.asElement()).getQualifiedName().toString();
        }

        @Override
        public Type visitTypeVariable(TypeVariable t, Type.Parameters p) {
            String v = t.asElement().getSimpleName().toString();
            return p.variable(v);
        }

        @Override
        public Type visitWildcard(WildcardType t, Type.Parameters p) {
            TypeMirror superBound = t.getSuperBound();
            if (superBound != null) {
                return TypeExtractor.this.factory.superWildcard((Type.Defined)superBound.accept(this, p));
            }
            TypeMirror extendsBound = t.getExtendsBound();
            if (extendsBound != null) {
                return TypeExtractor.this.factory.extendsWildcard((Type.Defined)extendsBound.accept(this, p));
            }
            return TypeExtractor.this.factory.extendsWildcard(Type.OBJECT);
        }

        @Override
        public Type visitNoType(NoType t, Type.Parameters p) {
            return Type.Primitive.VOID;
        }

        @Override
        public Type visitError(ErrorType t, Type.Parameters p) {
            throw new UnsupportedOperationException("ErrorType type not supported");
        }

        @Override
        public Type visitExecutable(ExecutableType t, Type.Parameters p) {
            throw new UnsupportedOperationException("ExecutableType type not supported");
        }

        @Override
        public Type visitUnion(UnionType t, Type.Parameters p) {
            throw new UnsupportedOperationException("UnionType type not supported");
        }

        @Override
        public Type visitNull(NullType t, Type.Parameters p) {
            throw new UnsupportedOperationException("NullType type not supported");
        }
    }
}

