/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.htmlunit.corejs.javascript.Slot;
import org.htmlunit.corejs.javascript.SlotMap;

public class EmbeddedSlotMap
implements SlotMap {
    private Slot[] slots;
    private Slot firstAdded;
    private Slot lastAdded;
    private int count;
    private static final int INITIAL_SLOT_SIZE = 4;

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Iterator<Slot> iterator() {
        return new Iter(this.firstAdded);
    }

    @Override
    public Slot query(Object key, int index) {
        if (this.slots == null) {
            return null;
        }
        int indexOrHash = key != null ? key.hashCode() : index;
        int slotIndex = EmbeddedSlotMap.getSlotIndex(this.slots.length, indexOrHash);
        Slot slot = this.slots[slotIndex];
        while (slot != null) {
            if (indexOrHash == slot.indexOrHash && Objects.equals(slot.name, key)) {
                return slot;
            }
            slot = slot.next;
        }
        return null;
    }

    @Override
    public Slot modify(Object key, int index, int attributes) {
        int indexOrHash;
        int n = indexOrHash = key != null ? key.hashCode() : index;
        if (this.slots != null) {
            int slotIndex = EmbeddedSlotMap.getSlotIndex(this.slots.length, indexOrHash);
            Slot slot = this.slots[slotIndex];
            while (!(slot == null || indexOrHash == slot.indexOrHash && Objects.equals(slot.name, key))) {
                slot = slot.next;
            }
            if (slot != null) {
                return slot;
            }
        }
        Slot newSlot = new Slot(key, index, attributes);
        this.createNewSlot(newSlot);
        return newSlot;
    }

    private void createNewSlot(Slot newSlot) {
        if (this.count == 0) {
            this.slots = new Slot[4];
        }
        if (4 * (this.count + 1) > 3 * this.slots.length) {
            Slot[] newSlots = new Slot[this.slots.length * 2];
            EmbeddedSlotMap.copyTable(this.slots, newSlots);
            this.slots = newSlots;
        }
        this.insertNewSlot(newSlot);
    }

    @Override
    public <S extends Slot> S compute(Object key, int index, SlotMap.SlotComputer<S> c) {
        S newSlot;
        int indexOrHash;
        int n = indexOrHash = key != null ? key.hashCode() : index;
        if (this.slots != null) {
            Slot prev;
            int slotIndex = EmbeddedSlotMap.getSlotIndex(this.slots.length, indexOrHash);
            Slot slot = prev = this.slots[slotIndex];
            while (!(slot == null || indexOrHash == slot.indexOrHash && Objects.equals(slot.name, key))) {
                prev = slot;
                slot = slot.next;
            }
            if (slot != null) {
                S newSlot2 = c.compute(key, index, slot);
                if (newSlot2 == null) {
                    this.removeSlot(slot, prev, slotIndex, key);
                } else if (!Objects.equals(slot, newSlot2)) {
                    if (prev == slot) {
                        this.slots[slotIndex] = newSlot2;
                    } else {
                        prev.next = newSlot2;
                    }
                    ((Slot)newSlot2).next = slot.next;
                    if (slot == this.firstAdded) {
                        this.firstAdded = newSlot2;
                    } else {
                        Slot ps = this.firstAdded;
                        while (ps != null && ps.orderedNext != slot) {
                            ps = ps.orderedNext;
                        }
                        if (ps != null) {
                            ps.orderedNext = newSlot2;
                        }
                    }
                    ((Slot)newSlot2).orderedNext = slot.orderedNext;
                    if (slot == this.lastAdded) {
                        this.lastAdded = newSlot2;
                    }
                }
                return newSlot2;
            }
        }
        if ((newSlot = c.compute(key, index, null)) != null) {
            this.createNewSlot((Slot)newSlot);
        }
        return newSlot;
    }

    @Override
    public void add(Slot newSlot) {
        if (this.slots == null) {
            this.slots = new Slot[4];
        }
        this.insertNewSlot(newSlot);
    }

    private void insertNewSlot(Slot newSlot) {
        ++this.count;
        if (this.lastAdded != null) {
            this.lastAdded.orderedNext = newSlot;
        }
        if (this.firstAdded == null) {
            this.firstAdded = newSlot;
        }
        this.lastAdded = newSlot;
        EmbeddedSlotMap.addKnownAbsentSlot(this.slots, newSlot);
    }

    private void removeSlot(Slot slot, Slot prev, int ix, Object key) {
        --this.count;
        if (prev == slot) {
            this.slots[ix] = slot.next;
        } else {
            prev.next = slot.next;
        }
        if (slot == this.firstAdded) {
            prev = null;
            this.firstAdded = slot.orderedNext;
        } else {
            prev = this.firstAdded;
            while (prev.orderedNext != slot) {
                prev = prev.orderedNext;
            }
            prev.orderedNext = slot.orderedNext;
        }
        if (slot == this.lastAdded) {
            this.lastAdded = prev;
        }
    }

    private static void copyTable(Slot[] oldSlots, Slot[] newSlots) {
        for (Slot slot : oldSlots) {
            while (slot != null) {
                Slot nextSlot = slot.next;
                EmbeddedSlotMap.addKnownAbsentSlot(newSlots, slot);
                slot = nextSlot;
            }
        }
    }

    private static void addKnownAbsentSlot(Slot[] addSlots, Slot slot) {
        int insertPos = EmbeddedSlotMap.getSlotIndex(addSlots.length, slot.indexOrHash);
        slot.next = addSlots[insertPos];
        addSlots[insertPos] = slot;
    }

    private static int getSlotIndex(int tableSize, int indexOrHash) {
        return indexOrHash & tableSize - 1;
    }

    private static final class Iter
    implements Iterator<Slot> {
        private Slot next;

        Iter(Slot slot) {
            this.next = slot;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Slot next() {
            Slot ret = this.next;
            if (ret == null) {
                throw new NoSuchElementException();
            }
            this.next = this.next.orderedNext;
            return ret;
        }
    }
}

