/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.EnumSet;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.DecompilerFlag;
import org.htmlunit.corejs.javascript.DefaultErrorReporter;
import org.htmlunit.corejs.javascript.ErrorReporter;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeFunction;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SerializableCallable;
import org.htmlunit.corejs.javascript.Undefined;

class NativeScript
extends BaseFunction {
    private static final long serialVersionUID = -6795101161980121700L;
    private static final Object SCRIPT_TAG = "Script";
    private Script script;

    static LambdaConstructor init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor obj = new LambdaConstructor(scope, "Script", 1, NativeScript::js_constructorCall, NativeScript::js_constructor);
        NativeScript proto = new NativeScript(null);
        proto.setPrototypeProperty(null);
        obj.setPrototypeProperty(proto);
        Scriptable function = (Scriptable)ScriptableObject.getProperty(scope, "Function");
        Scriptable functionProto = (Scriptable)ScriptableObject.getProperty(function, "prototype");
        proto.setPrototype(functionProto);
        NativeScript.defineMethod(obj, scope, "toString", 0, NativeScript::js_toString);
        NativeScript.defineMethod(obj, scope, "exec", 0, NativeScript::js_exec);
        NativeScript.defineMethod(obj, scope, "compile", 0, NativeScript::js_compile);
        ScriptableObject.defineProperty(scope, "Script", obj, 2);
        if (sealed) {
            obj.sealObject();
            ((ScriptableObject)obj.getPrototypeProperty()).sealObject();
        }
        return obj;
    }

    private static void defineMethod(LambdaConstructor typedArray, Scriptable scope, String name, int length, SerializableCallable target) {
        typedArray.definePrototypeMethod(scope, name, length, target, 2, 3);
    }

    @Deprecated
    static void init(Scriptable scope, boolean sealed) {
        NativeScript.init(Context.getContext(), scope, sealed);
    }

    private NativeScript(Script script) {
        this.script = script;
    }

    @Override
    public String getClassName() {
        return "Script";
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (this.script != null) {
            return this.script.exec(cx, scope);
        }
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw Context.reportRuntimeErrorById("msg.script.is.not.constructor", new Object[0]);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    String decompile(int indent, EnumSet<DecompilerFlag> flags) {
        if (this.script instanceof NativeFunction) {
            return ((NativeFunction)((Object)this.script)).decompile(indent, flags);
        }
        return super.decompile(indent, flags);
    }

    private static Object js_compile(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativeScript real = NativeScript.realThis(thisObj, "compile");
        String source = ScriptRuntime.toString(args, 0);
        real.script = NativeScript.compile(cx, source);
        return real;
    }

    private static Object js_exec(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        throw Context.reportRuntimeErrorById("msg.cant.call.indirect", "exec");
    }

    private static Object js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativeScript real = NativeScript.realThis(thisObj, "toString");
        Script realScript = real.script;
        if (realScript == null) {
            return "";
        }
        return cx.decompileScript(realScript, 0);
    }

    private static Scriptable js_constructorCall(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeScript.js_constructor(cx, scope, args);
    }

    private static Scriptable js_constructor(Context cx, Scriptable scope, Object[] args) {
        String source = args.length == 0 ? "" : ScriptRuntime.toString(args[0]);
        Script script = NativeScript.compile(cx, source);
        NativeScript nscript = new NativeScript(script);
        ScriptRuntime.setObjectProtoAndParent(nscript, scope);
        return nscript;
    }

    private static NativeScript realThis(Scriptable thisObj, String name) {
        return NativeScript.ensureType(thisObj, NativeScript.class, name);
    }

    private static Script compile(Context cx, String source) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        if (filename == null) {
            filename = "<Script object>";
            linep[0] = 1;
        }
        ErrorReporter reporter = DefaultErrorReporter.forEval(cx.getErrorReporter());
        return cx.compileString(source, null, reporter, filename, linep[0], null, null);
    }
}

