/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.Lob;
import jakarta.persistence.MapKey;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.AuditMappedBy;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.CollectionAuditTable;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.RelationTargetNotFoundAction;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.internal.ModifiedColumnNameResolver;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditJoinTableData;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditOverrideData;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.DynamicProperty;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;

public class AuditedPropertiesReader {
    private static final AuditJoinTableData DEFAULT_AUDIT_JOIN_TABLE = new AuditJoinTableData();
    public static final String NO_PREFIX = "";
    private final PersistentPropertiesSource persistentPropertiesSource;
    private final AuditedPropertiesHolder auditedPropertiesHolder;
    private final EnversMetadataBuildingContext metadataBuildingContext;
    private final String propertyNamePrefix;
    private final Map<String, String> propertyAccessedPersistentProperties;
    private final Set<String> fieldAccessedPersistentProperties;
    private final Map<String, String> propertiesGroupMapping;
    private final Set<XProperty> overriddenAuditedProperties;
    private final Set<XProperty> overriddenNotAuditedProperties;
    private final Map<XProperty, AuditJoinTable> overriddenAuditedPropertiesJoinTables;
    private final Set<XClass> overriddenAuditedClasses;
    private final Set<XClass> overriddenNotAuditedClasses;
    private static final Audited DEFAULT_AUDITED = new Audited(){

        @Override
        public RelationTargetAuditMode targetAuditMode() {
            return RelationTargetAuditMode.AUDITED;
        }

        @Override
        public RelationTargetNotFoundAction targetNotFoundAction() {
            return RelationTargetNotFoundAction.DEFAULT;
        }

        @Override
        public Class[] auditParents() {
            return new Class[0];
        }

        @Override
        public boolean withModifiedFlag() {
            return false;
        }

        @Override
        public String modifiedColumnName() {
            return AuditedPropertiesReader.NO_PREFIX;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }
    };

    public AuditedPropertiesReader(EnversMetadataBuildingContext metadataBuildingContext, PersistentPropertiesSource persistentPropertiesSource, AuditedPropertiesHolder auditedPropertiesHolder) {
        this(metadataBuildingContext, persistentPropertiesSource, auditedPropertiesHolder, NO_PREFIX);
    }

    public AuditedPropertiesReader(EnversMetadataBuildingContext metadataBuildingContext, PersistentPropertiesSource persistentPropertiesSource, AuditedPropertiesHolder auditedPropertiesHolder, String propertyNamePrefix) {
        this.persistentPropertiesSource = persistentPropertiesSource;
        this.auditedPropertiesHolder = auditedPropertiesHolder;
        this.metadataBuildingContext = metadataBuildingContext;
        this.propertyNamePrefix = propertyNamePrefix;
        this.propertyAccessedPersistentProperties = Tools.newHashMap();
        this.fieldAccessedPersistentProperties = Tools.newHashSet();
        this.propertiesGroupMapping = Tools.newHashMap();
        this.overriddenAuditedProperties = Tools.newHashSet();
        this.overriddenNotAuditedProperties = Tools.newHashSet();
        this.overriddenAuditedPropertiesJoinTables = Tools.newHashMap();
        this.overriddenAuditedClasses = Tools.newHashSet();
        this.overriddenNotAuditedClasses = Tools.newHashSet();
    }

    public void read() {
        this.read(null);
    }

    public void read(Audited allClassAudited) {
        this.readPersistentPropertiesAccess();
        if (this.persistentPropertiesSource.isDynamicComponent()) {
            this.addPropertiesFromDynamicComponent(this.persistentPropertiesSource);
        } else {
            XClass clazz = this.persistentPropertiesSource.getXClass();
            if (this.persistentPropertiesSource.hasCompositeUserType()) {
                Value propertyValue;
                Property property;
                for (String propertyName : this.fieldAccessedPersistentProperties) {
                    property = this.persistentPropertiesSource.getProperty(propertyName);
                    propertyValue = property.getValue();
                    if (propertyValue instanceof Component) {
                        this.addFromComponentProperty(property, "field", (Component)propertyValue, allClassAudited);
                        continue;
                    }
                    this.addFromNotComponentProperty(property, "field", allClassAudited);
                }
                for (String propertyName : this.propertyAccessedPersistentProperties.keySet()) {
                    property = this.persistentPropertiesSource.getProperty(propertyName);
                    propertyValue = property.getValue();
                    if (propertyValue instanceof Component) {
                        this.addFromComponentProperty(property, "property", (Component)propertyValue, allClassAudited);
                        continue;
                    }
                    this.addFromNotComponentProperty(property, "property", allClassAudited);
                }
            } else {
                this.readAuditOverrides(clazz);
                this.addPropertiesFromClass(clazz);
            }
        }
    }

    private void readAuditOverrides(XClass clazz) {
        ReflectionManager reflectionManager = this.metadataBuildingContext.getReflectionManager();
        Audited allClassAudited = (Audited)clazz.getAnnotation(Audited.class);
        if (allClassAudited != null && allClassAudited.auditParents().length > 0) {
            for (Class c : allClassAudited.auditParents()) {
                XClass parentClass = reflectionManager.toXClass(c);
                this.checkSuperclass(clazz, parentClass);
                if (this.overriddenNotAuditedClasses.contains(parentClass)) continue;
                this.overriddenAuditedClasses.add(parentClass);
            }
        }
        List<AuditOverride> auditOverrides = this.computeAuditOverrides(clazz);
        for (AuditOverride auditOverride : auditOverrides) {
            if (auditOverride.forClass() == Void.TYPE) continue;
            XClass overrideClass = reflectionManager.toXClass(auditOverride.forClass());
            this.checkSuperclass(clazz, overrideClass);
            String propertyName = auditOverride.name();
            if (!StringTools.isEmpty(propertyName)) {
                XProperty property = this.getProperty(overrideClass, propertyName);
                if (auditOverride.isAudited()) {
                    if (this.overriddenNotAuditedProperties.contains(property)) continue;
                    this.overriddenAuditedProperties.add(property);
                    this.overriddenAuditedPropertiesJoinTables.put(property, auditOverride.auditJoinTable());
                    continue;
                }
                if (this.overriddenAuditedProperties.contains(property)) continue;
                this.overriddenNotAuditedProperties.add(property);
                continue;
            }
            if (auditOverride.isAudited()) {
                if (this.overriddenNotAuditedClasses.contains(overrideClass)) continue;
                this.overriddenAuditedClasses.add(overrideClass);
                continue;
            }
            if (this.overriddenAuditedClasses.contains(overrideClass)) continue;
            this.overriddenNotAuditedClasses.add(overrideClass);
        }
        XClass superclass = clazz.getSuperclass();
        if (!clazz.isInterface() && !Object.class.getName().equals(superclass.getName())) {
            this.readAuditOverrides(superclass);
        }
    }

    private List<AuditOverride> computeAuditOverrides(XClass clazz) {
        AuditOverrides auditOverrides = (AuditOverrides)clazz.getAnnotation(AuditOverrides.class);
        AuditOverride auditOverride = (AuditOverride)clazz.getAnnotation(AuditOverride.class);
        if (auditOverrides == null && auditOverride != null) {
            return Arrays.asList(auditOverride);
        }
        if (auditOverrides != null && auditOverride == null) {
            return Arrays.asList(auditOverrides.value());
        }
        if (auditOverrides != null && auditOverride != null) {
            throw new EnversMappingException("@AuditOverrides annotation should encapsulate all @AuditOverride declarations. Please revise Envers annotations applied to class " + clazz.getName() + ".");
        }
        return Collections.emptyList();
    }

    private void checkSuperclass(XClass child, XClass parent) {
        if (!parent.isAssignableFrom(child)) {
            throw new EnversMappingException("Class " + parent.getName() + " is not assignable from " + child.getName() + ". Please revise Envers annotations applied to " + child.getName() + " type.");
        }
    }

    private XProperty getProperty(XClass clazz, String propertyName) {
        XProperty property = ReflectionTools.getProperty(clazz, propertyName);
        if (property == null) {
            throw new EnversMappingException("Property '" + propertyName + "' not found in class " + clazz.getName() + ". Please revise Envers annotations applied to class " + this.persistentPropertiesSource.getXClass() + ".");
        }
        return property;
    }

    private void readPersistentPropertiesAccess() {
        Iterator<Property> propertyIter = this.persistentPropertiesSource.getPropertyIterator();
        while (propertyIter.hasNext()) {
            Property property = propertyIter.next();
            this.addPersistentProperty(property);
            if (!"embedded".equals(property.getPropertyAccessorName()) || "_identifierMapper".equals(property.getName())) continue;
            this.createPropertiesGroupMapping(property);
        }
    }

    private void addPersistentProperty(Property property) {
        if ("field".equals(property.getPropertyAccessorName())) {
            this.fieldAccessedPersistentProperties.add(property.getName());
        } else {
            this.propertyAccessedPersistentProperties.put(property.getName(), property.getPropertyAccessorName());
        }
    }

    private void createPropertiesGroupMapping(Property property) {
        Component component = (Component)property.getValue();
        for (Property componentProperty : component.getProperties()) {
            this.propertiesGroupMapping.put(componentProperty.getName(), property.getName());
        }
    }

    private Audited computeAuditConfiguration(XClass clazz) {
        Audited allClassAudited = (Audited)clazz.getAnnotation(Audited.class);
        if (allClassAudited == null && this.overriddenAuditedClasses.contains(clazz)) {
            allClassAudited = (Audited)this.persistentPropertiesSource.getXClass().getAnnotation(Audited.class);
            if (allClassAudited == null) {
                allClassAudited = DEFAULT_AUDITED;
            }
        } else if (allClassAudited != null && this.overriddenNotAuditedClasses.contains(clazz)) {
            return null;
        }
        return allClassAudited;
    }

    private void addPropertiesFromDynamicComponent(PersistentPropertiesSource propertiesSource) {
        Audited audited = this.computeAuditConfiguration(propertiesSource.getXClass());
        if (!this.fieldAccessedPersistentProperties.isEmpty()) {
            throw new EnversMappingException("Audited dynamic component cannot have properties with access=\"field\" for properties: " + this.fieldAccessedPersistentProperties + ". \n Change properties access=\"property\", to make it work)");
        }
        for (Map.Entry<String, String> entry : this.propertyAccessedPersistentProperties.entrySet()) {
            String property = entry.getKey();
            String accessType = entry.getValue();
            if (this.auditedPropertiesHolder.contains(property)) continue;
            Value propertyValue = this.persistentPropertiesSource.getProperty(property).getValue();
            if (propertyValue instanceof Component) {
                this.addFromComponentProperty(new DynamicProperty(propertiesSource, property), accessType, (Component)propertyValue, audited);
                continue;
            }
            this.addFromNotComponentProperty(new DynamicProperty(propertiesSource, property), accessType, audited);
        }
    }

    private void addPropertiesFromClass(XClass clazz) {
        Audited allClassAudited = this.computeAuditConfiguration(clazz);
        this.addFromProperties(clazz.getDeclaredProperties("field"), it -> "field", this.fieldAccessedPersistentProperties, allClassAudited);
        this.addFromProperties(clazz.getDeclaredProperties("property"), this.propertyAccessedPersistentProperties::get, this.propertyAccessedPersistentProperties.keySet(), allClassAudited);
        if (this.isClassHierarchyTraversalNeeded(allClassAudited)) {
            XClass superclazz = clazz.getSuperclass();
            if (!clazz.isInterface() && !"java.lang.Object".equals(superclazz.getName())) {
                this.addPropertiesFromClass(superclazz);
            }
        }
    }

    protected boolean isClassHierarchyTraversalNeeded(Audited allClassAudited) {
        return allClassAudited != null || !this.auditedPropertiesHolder.isEmpty();
    }

    private void addFromProperties(Iterable<XProperty> properties, Function<String, String> accessTypeProvider, Set<String> persistentProperties, Audited allClassAudited) {
        for (XProperty property : properties) {
            String embeddedName;
            String accessType = accessTypeProvider.apply(property.getName());
            if (persistentProperties.contains(property.getName()) && !this.auditedPropertiesHolder.contains(property.getName())) {
                Value propertyValue = this.persistentPropertiesSource.getProperty(property.getName()).getValue();
                if (propertyValue instanceof Component) {
                    this.addFromComponentProperty(property, accessType, (Component)propertyValue, allClassAudited);
                    continue;
                }
                this.addFromNotComponentProperty(property, accessType, allClassAudited);
                continue;
            }
            if (!this.propertiesGroupMapping.containsKey(property.getName()) || this.auditedPropertiesHolder.contains(embeddedName = this.propertiesGroupMapping.get(property.getName()))) continue;
            Value propertyValue = this.persistentPropertiesSource.getProperty(embeddedName).getValue();
            this.addFromPropertiesGroup(embeddedName, property, accessType, (Component)propertyValue, allClassAudited);
        }
    }

    private void addFromPropertiesGroup(String embeddedName, XProperty property, String accessType, Component propertyValue, Audited allClassAudited) {
        ComponentAuditingData componentData = new ComponentAuditingData();
        boolean isAudited = this.fillPropertyData(property, (PropertyAuditingData)componentData, accessType, allClassAudited);
        if (isAudited) {
            componentData.setName(embeddedName);
            componentData.setBeanName(null);
            PersistentPropertiesSource componentPropertiesSource = PersistentPropertiesSource.forComponent(this.metadataBuildingContext, propertyValue);
            AuditedPropertiesReader audPropReader = new AuditedPropertiesReader(this.metadataBuildingContext, componentPropertiesSource, componentData, this.propertyNamePrefix + MappingTools.createComponentPrefix(embeddedName));
            audPropReader.read();
            this.auditedPropertiesHolder.addPropertyAuditingData(embeddedName, componentData);
        }
    }

    private void addFromComponentProperty(XProperty property, String accessType, Component propertyValue, Audited allClassAudited) {
        PersistentPropertiesSource componentPropertiesSource;
        ComponentAuditingData componentData = new ComponentAuditingData();
        boolean isAudited = this.fillPropertyData(property, (PropertyAuditingData)componentData, accessType, allClassAudited);
        if (propertyValue.isDynamic()) {
            XClass xClass = this.metadataBuildingContext.getReflectionManager().toXClass(Map.class);
            componentPropertiesSource = PersistentPropertiesSource.forComponent(propertyValue, xClass, true);
        } else {
            componentPropertiesSource = PersistentPropertiesSource.forComponent(this.metadataBuildingContext, propertyValue);
        }
        ComponentAuditedPropertiesReader audPropReader = new ComponentAuditedPropertiesReader(this.metadataBuildingContext, componentPropertiesSource, componentData, this.propertyNamePrefix + MappingTools.createComponentPrefix(property.getName()));
        audPropReader.read(allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), componentData);
        }
    }

    private void addFromNotComponentProperty(XProperty property, String accessType, Audited allClassAudited) {
        PropertyAuditingData propertyData = new PropertyAuditingData();
        boolean isAudited = this.fillPropertyData(property, propertyData, accessType, allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), propertyData);
        }
    }

    private boolean fillPropertyData(XProperty property, PropertyAuditingData propertyData, String accessType, Audited allClassAudited) {
        String modifiedFlagsSuffix;
        Version jpaVer;
        NotAudited unVer = (NotAudited)property.getAnnotation(NotAudited.class);
        if (unVer != null && !this.overriddenAuditedProperties.contains(property) || this.overriddenNotAuditedProperties.contains(property)) {
            return false;
        }
        if (this.metadataBuildingContext.getConfiguration().isDoNotAuditOptimisticLockingField() && (jpaVer = (Version)property.getAnnotation(Version.class)) != null) {
            return false;
        }
        String propertyName = this.propertyNamePrefix + property.getName();
        if (!this.checkAudited(property, propertyData, propertyName, allClassAudited, modifiedFlagsSuffix = this.metadataBuildingContext.getConfiguration().getModifiedFlagsSuffix())) {
            return false;
        }
        this.validateLobMappingSupport(property);
        propertyData.setName(propertyName);
        propertyData.setBeanName(property.getName());
        propertyData.setAccessType(accessType);
        this.addPropertyJoinTables(property, propertyData);
        this.addPropertyCollectionAuditTable(property, propertyData);
        this.addPropertyAuditingOverrides(property, propertyData);
        if (!this.processPropertyAuditingOverrides(property, propertyData)) {
            return false;
        }
        this.addPropertyMapKey(property, propertyData);
        this.setPropertyAuditMappedBy(property, propertyData);
        this.setPropertyRelationMappedBy(property, propertyData);
        return true;
    }

    private void addFromComponentProperty(Property property, String accessType, Component propertyValue, Audited allClassAudited) {
        PersistentPropertiesSource componentPropertiesSource;
        ComponentAuditingData componentData = new ComponentAuditingData();
        boolean isAudited = this.fillPropertyData(property, (PropertyAuditingData)componentData, accessType, allClassAudited);
        if (propertyValue.isDynamic()) {
            XClass xClass = this.metadataBuildingContext.getReflectionManager().toXClass(Map.class);
            componentPropertiesSource = PersistentPropertiesSource.forComponent(propertyValue, xClass, true);
        } else {
            componentPropertiesSource = PersistentPropertiesSource.forComponent(this.metadataBuildingContext, propertyValue);
        }
        ComponentAuditedPropertiesReader audPropReader = new ComponentAuditedPropertiesReader(this.metadataBuildingContext, componentPropertiesSource, componentData, this.propertyNamePrefix + MappingTools.createComponentPrefix(property.getName()));
        audPropReader.read(allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), componentData);
        }
    }

    private void addFromNotComponentProperty(Property property, String accessType, Audited allClassAudited) {
        PropertyAuditingData propertyData = new PropertyAuditingData();
        boolean isAudited = this.fillPropertyData(property, propertyData, accessType, allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), propertyData);
        }
    }

    private boolean fillPropertyData(Property property, PropertyAuditingData propertyData, String accessType, Audited allClassAudited) {
        String modifiedFlagsSuffix;
        String propertyName = this.propertyNamePrefix + property.getName();
        if (!this.checkAudited(property, propertyData, propertyName, allClassAudited, modifiedFlagsSuffix = this.metadataBuildingContext.getConfiguration().getModifiedFlagsSuffix())) {
            return false;
        }
        propertyData.setName(propertyName);
        propertyData.setBeanName(property.getName());
        propertyData.setAccessType(accessType);
        propertyData.setJoinTable(DEFAULT_AUDIT_JOIN_TABLE);
        return this.processPropertyAuditingOverrides(property, propertyData);
    }

    private void validateLobMappingSupport(XProperty property) {
        try {
            if (property.isAnnotationPresent(ElementCollection.class) && property.isAnnotationPresent(Lob.class) && !property.getCollectionClass().isAssignableFrom(Map.class)) {
                throw new EnversMappingException("@ElementCollection combined with @Lob is only supported for Map collection types.");
            }
        }
        catch (EnversMappingException e) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Invalid mapping in [%s] for property [%s]", property.getDeclaringClass().getName(), property.getName()), (Throwable)((Object)e));
        }
    }

    protected boolean checkAudited(XProperty property, PropertyAuditingData propertyData, String propertyName, Audited allClassAudited, String modifiedFlagSuffix) {
        Audited aud;
        Audited audited = aud = property.isAnnotationPresent(Audited.class) ? (Audited)property.getAnnotation(Audited.class) : allClassAudited;
        if (aud == null && this.overriddenAuditedProperties.contains(property) && !this.overriddenNotAuditedProperties.contains(property)) {
            aud = DEFAULT_AUDITED;
        }
        if (aud != null) {
            propertyData.setRelationTargetAuditMode(aud.targetAuditMode());
            propertyData.setRelationTargetNotFoundAction(this.getRelationNotFoundAction(property, allClassAudited));
            propertyData.setUsingModifiedFlag(this.checkUsingModifiedFlag(aud));
            propertyData.setModifiedFlagName(ModifiedColumnNameResolver.getName(propertyName, modifiedFlagSuffix));
            if (!StringTools.isEmpty(aud.modifiedColumnName())) {
                propertyData.setExplicitModifiedFlagName(aud.modifiedColumnName());
            }
            return true;
        }
        return false;
    }

    protected boolean checkAudited(Property property, PropertyAuditingData propertyData, String propertyName, Audited allClassAudited, String modifiedFlagSuffix) {
        if (allClassAudited != null) {
            propertyData.setRelationTargetAuditMode(allClassAudited.targetAuditMode());
            propertyData.setRelationTargetNotFoundAction(allClassAudited == null ? RelationTargetNotFoundAction.DEFAULT : allClassAudited.targetNotFoundAction());
            propertyData.setUsingModifiedFlag(this.checkUsingModifiedFlag(allClassAudited));
            propertyData.setModifiedFlagName(ModifiedColumnNameResolver.getName(propertyName, modifiedFlagSuffix));
            if (!StringTools.isEmpty(allClassAudited.modifiedColumnName())) {
                propertyData.setExplicitModifiedFlagName(allClassAudited.modifiedColumnName());
            }
            return true;
        }
        return false;
    }

    protected boolean checkUsingModifiedFlag(Audited aud) {
        if (this.metadataBuildingContext.getConfiguration().hasSettingForUseModifiedFlag()) {
            return this.metadataBuildingContext.getConfiguration().isModifiedFlagsEnabled() || aud.withModifiedFlag();
        }
        return aud.withModifiedFlag();
    }

    private void setPropertyRelationMappedBy(XProperty property, PropertyAuditingData propertyData) {
        OneToMany oneToMany = (OneToMany)property.getAnnotation(OneToMany.class);
        if (oneToMany != null && StringHelper.isNotEmpty((String)oneToMany.mappedBy())) {
            propertyData.setRelationMappedBy(oneToMany.mappedBy());
        }
    }

    private void setPropertyAuditMappedBy(XProperty property, PropertyAuditingData propertyData) {
        AuditMappedBy auditMappedBy = (AuditMappedBy)property.getAnnotation(AuditMappedBy.class);
        if (auditMappedBy != null) {
            propertyData.setAuditMappedBy(auditMappedBy.mappedBy());
            if (StringHelper.isNotEmpty((String)auditMappedBy.positionMappedBy())) {
                propertyData.setPositionMappedBy(auditMappedBy.positionMappedBy());
            }
        }
    }

    private void addPropertyMapKey(XProperty property, PropertyAuditingData propertyData) {
        MapKey mapKey = (MapKey)property.getAnnotation(MapKey.class);
        if (mapKey != null) {
            propertyData.setMapKey(mapKey.name());
        } else {
            MapKeyEnumerated mapKeyEnumerated = (MapKeyEnumerated)property.getAnnotation(MapKeyEnumerated.class);
            if (mapKeyEnumerated != null) {
                propertyData.setMapKeyEnumType(mapKeyEnumerated.value());
            }
        }
    }

    private void addPropertyJoinTables(XProperty property, PropertyAuditingData propertyData) {
        AuditJoinTable overrideJoinTable = this.overriddenAuditedPropertiesJoinTables.get(property);
        if (overrideJoinTable != null) {
            propertyData.setJoinTable(new AuditJoinTableData(overrideJoinTable));
        } else {
            AuditJoinTable propertyJoinTable = (AuditJoinTable)property.getAnnotation(AuditJoinTable.class);
            if (propertyJoinTable != null) {
                propertyData.setJoinTable(new AuditJoinTableData(propertyJoinTable));
            } else {
                propertyData.setJoinTable(DEFAULT_AUDIT_JOIN_TABLE);
            }
        }
    }

    private void addPropertyCollectionAuditTable(XProperty property, PropertyAuditingData propertyAuditingData) {
        CollectionAuditTable collectionAuditTableAnn = (CollectionAuditTable)property.getAnnotation(CollectionAuditTable.class);
        if (collectionAuditTableAnn != null) {
            propertyAuditingData.setCollectionAuditTable(collectionAuditTableAnn);
        }
    }

    private void addPropertyAuditingOverrides(XProperty property, PropertyAuditingData propertyData) {
        AuditOverrides annotationOverrides;
        AuditOverride annotationOverride = (AuditOverride)property.getAnnotation(AuditOverride.class);
        if (annotationOverride != null) {
            propertyData.addAuditingOverride(annotationOverride);
        }
        if ((annotationOverrides = (AuditOverrides)property.getAnnotation(AuditOverrides.class)) != null) {
            propertyData.addAuditingOverrides(annotationOverrides);
        }
    }

    private boolean processPropertyAuditingOverrides(XProperty property, PropertyAuditingData propertyData) {
        for (AuditOverrideData override : this.auditedPropertiesHolder.getAuditingOverrides()) {
            if (!property.getName().equals(override.getName())) continue;
            if (!override.isAudited()) {
                return false;
            }
            if (override.getAuditJoinTableData() == null) continue;
            propertyData.setJoinTable(override.getAuditJoinTableData());
        }
        return true;
    }

    private boolean processPropertyAuditingOverrides(Property property, PropertyAuditingData propertyData) {
        for (AuditOverrideData override : this.auditedPropertiesHolder.getAuditingOverrides()) {
            if (!property.getName().equals(override.getName())) continue;
            if (!override.isAudited()) {
                return false;
            }
            if (override.getAuditJoinTableData() == null) continue;
            propertyData.setJoinTable(override.getAuditJoinTableData());
        }
        return true;
    }

    protected boolean isOverriddenNotAudited(XProperty property) {
        return this.overriddenNotAuditedProperties.contains(property);
    }

    protected boolean isOverriddenNotAudited(XClass clazz) {
        return this.overriddenNotAuditedClasses.contains(clazz);
    }

    protected boolean isOverriddenAudited(XProperty property) {
        return this.overriddenAuditedProperties.contains(property);
    }

    protected boolean isOverriddenAudited(XClass clazz) {
        return this.overriddenAuditedClasses.contains(clazz);
    }

    private RelationTargetNotFoundAction getRelationNotFoundAction(XProperty property, Audited classAudited) {
        Audited propertyAudited = (Audited)property.getAnnotation(Audited.class);
        if (classAudited == null) {
            if (propertyAudited == null) {
                return RelationTargetNotFoundAction.DEFAULT;
            }
            return propertyAudited.targetNotFoundAction();
        }
        RelationTargetNotFoundAction action = classAudited.targetNotFoundAction();
        if (propertyAudited != null && !propertyAudited.targetNotFoundAction().equals((Object)RelationTargetNotFoundAction.DEFAULT)) {
            action = propertyAudited.targetNotFoundAction();
        }
        return action;
    }
}

