/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.util.List;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.spatial.Spatial;
import org.hibernate.type.Type;

class WrappedOGCFunction
extends StandardSQLFunction {
    private final boolean[] geomArrays;
    private final boolean isGeometryTyped;

    WrappedOGCFunction(String name, Type type, boolean[] geomArrays) {
        super(name, type);
        if (this.isSpatial(type)) {
            throw new IllegalArgumentException("This constructor is only valid for functions returning non-spatial values.");
        }
        this.geomArrays = geomArrays;
        this.isGeometryTyped = false;
    }

    WrappedOGCFunction(String name, boolean[] geomArrays) {
        super(name);
        this.geomArrays = geomArrays;
        this.isGeometryTyped = true;
    }

    public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
        StringBuilder buf = new StringBuilder();
        buf.append("MDSYS.").append(this.getName()).append("(");
        for (int i = 0; i < args.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            if (this.geomArrays[i]) {
                buf.append("MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(").append(args.get(i)).append(")");
                continue;
            }
            buf.append(args.get(i));
        }
        buf.append(")");
        return this.isGeometryTyped ? buf.append(".geom").toString() : buf.toString();
    }

    private boolean isSpatial(Type type) {
        return Spatial.class.isAssignableFrom(type.getClass());
    }
}

