/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.AddWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.UpdateWorkExecutor;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ByTermUpdateWorkExecutor
extends UpdateWorkExecutor {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final AddWorkExecutor addDelegate;
    private final Workspace workspace;

    ByTermUpdateWorkExecutor(Workspace workspace, AddWorkExecutor addDelegate) {
        super(null, null);
        this.workspace = workspace;
        this.addDelegate = addDelegate;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        IndexedTypeIdentifier managedType = work.getEntityType();
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(managedType);
        this.doPerformWork(work, delegate, monitor, managedType, builder, DeleteWorkExecutor.isIdNumeric(builder));
    }

    protected void doPerformWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor, IndexedTypeIdentifier managedType, DocumentBuilderIndexedEntity builder, boolean isIdNumeric) {
        Serializable id = work.getId();
        String tenantId = work.getTenantId();
        log.tracef("Updating %s#%s by id using an IndexWriter.", managedType, id);
        try {
            if (tenantId == null) {
                this.updateWithoutTenant(work, delegate, monitor, builder, isIdNumeric, id);
            } else {
                this.updateWithTenant(work, delegate, monitor, builder, isIdNumeric, tenantId, id);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to update " + managedType + "#" + id + " in index.";
            throw new SearchException(message, e);
        }
        if (monitor != null) {
            monitor.documentsAdded(1L);
        }
    }

    private void updateWithTenant(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor, DocumentBuilderIndexedEntity builder, boolean isIdNumeric, String tenantId, Serializable id) throws IOException {
        BooleanQuery.Builder termDeleteQueryBuilder = new BooleanQuery.Builder();
        TermQuery tenantTermQuery = new TermQuery(new Term("__HSearch_TenantId", tenantId));
        termDeleteQueryBuilder.add((Query)tenantTermQuery, BooleanClause.Occur.FILTER);
        if (isIdNumeric) {
            Query exactMatchQuery = NumericFieldUtils.createExactMatchQuery(builder.getIdFieldName(), id);
            termDeleteQueryBuilder.add(exactMatchQuery, BooleanClause.Occur.FILTER);
        } else {
            Term idTerm = new Term(builder.getIdFieldName(), work.getIdInString());
            termDeleteQueryBuilder.add((Query)new TermQuery(idTerm), BooleanClause.Occur.FILTER);
        }
        BooleanQuery termDeleteQuery = termDeleteQueryBuilder.build();
        delegate.deleteDocuments((Query)termDeleteQuery);
        this.addDelegate.performWork(work, delegate, monitor);
    }

    private void updateWithoutTenant(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor, DocumentBuilderIndexedEntity builder, boolean isIdNumeric, Serializable id) throws IOException {
        if (isIdNumeric) {
            delegate.deleteDocuments(NumericFieldUtils.createExactMatchQuery(builder.getIdFieldName(), id));
            this.addDelegate.performWork(work, delegate, monitor);
        } else {
            Term idTerm = new Term(builder.getIdFieldName(), work.getIdInString());
            Map<String, String> fieldToAnalyzerMap = work.getFieldToAnalyzerMap();
            ScopedAnalyzerReference analyzerReference = builder.getAnalyzerReference();
            analyzerReference = AddWorkExecutor.updateAnalyzerMappings(this.workspace, analyzerReference, fieldToAnalyzerMap);
            delegate.updateDocument(idTerm, work.getDocument(), analyzerReference);
        }
    }
}

