/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.NFITypeLibrary;

abstract class ConvertTypeNode
extends Node {
    ConvertTypeNode() {
    }

    abstract Object execute(NFIType var1, Object var2);

    static OptimizedConvertTypeNode createOptimizedToNative(NFIType.TypeCachedState state) {
        ConvertToNativeNode impl = ConvertTypeNodeFactory.ConvertToNativeNodeGen.create();
        return new OptimizedConvertTypeNode(state, impl);
    }

    static OptimizedConvertTypeNode createOptimizedFromNative(NFIType.TypeCachedState state) {
        ConvertFromNativeNode impl = ConvertTypeNodeFactory.ConvertFromNativeNodeGen.create();
        return new OptimizedConvertTypeNode(state, impl);
    }

    @GenerateUncached
    static abstract class ConvertFromNativeNode
    extends ConvertTypeImplNode {
        ConvertFromNativeNode() {
        }

        @Specialization(limit="3")
        Object doConvert(NFIType.TypeCachedState typeState, NFIType type, Object value, @CachedLibrary(value="typeState") NFITypeLibrary library) {
            return library.convertFromNative(typeState, type, value);
        }
    }

    @GenerateUncached
    static abstract class ConvertToNativeNode
    extends ConvertTypeImplNode {
        ConvertToNativeNode() {
        }

        @Specialization(limit="3")
        Object doConvert(NFIType.TypeCachedState typeState, NFIType type, Object value, @CachedLibrary(value="typeState") NFITypeLibrary library) {
            return library.convertToNative(typeState, type, value);
        }
    }

    static abstract class ConvertTypeImplNode
    extends ConvertTypeNode {
        ConvertTypeImplNode() {
        }

        abstract Object execute(NFIType.TypeCachedState var1, NFIType var2, Object var3);

        @Override
        final Object execute(NFIType type, Object value) {
            return this.execute(type.cachedState, type, value);
        }
    }

    static class OptimizedConvertTypeNode
    extends ConvertTypeNode {
        final NFIType.TypeCachedState typeState;
        @Node.Child
        ConvertTypeImplNode convert;

        OptimizedConvertTypeNode(NFIType.TypeCachedState typeState, ConvertTypeImplNode convert) {
            this.typeState = typeState;
            this.convert = convert;
        }

        @Override
        Object execute(NFIType type, Object value) {
            assert (this.typeState == type.cachedState);
            return this.convert.execute(this.typeState, type, value);
        }
    }
}

