/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.phases;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisGraphDecoder;
import com.oracle.svm.util.ClassUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;

public class InlineBeforeAnalysis {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StructuredGraph decodeGraph(PointsToAnalysis bb, AnalysisMethod method, AnalysisParsedGraph analysisParsedGraph) {
        DebugContext.Description description = new DebugContext.Description((Object)method, ClassUtil.getUnqualifiedName(method.getClass()) + ":" + method.getId());
        DebugContext debug = new DebugContext.Builder(bb.getOptions(), (DebugHandlersFactory)new GraalDebugHandlersFactory(bb.getProviders().getSnippetReflection())).description(description).build();
        StructuredGraph result = new StructuredGraph.Builder(bb.getOptions(), debug).method((ResolvedJavaMethod)method).recordInlinedMethods(false).trackNodeSourcePosition(analysisParsedGraph.getEncodedGraph().trackNodeSourcePosition()).build();
        try (DebugContext.Scope s = debug.scope((Object)"InlineBeforeAnalysis", (Object)result);){
            Object decoder;
            if (bb.strengthenGraalGraphs() && ((Boolean)Options.InlineBeforeAnalysis.getValue(bb.getOptions())).booleanValue()) {
                decoder = new InlineBeforeAnalysisGraphDecoder(bb, bb.getHostVM().inlineBeforeAnalysisPolicy(), result);
                decoder.decode((ResolvedJavaMethod)method, false, result.trackNodeSourcePosition());
            } else {
                decoder = new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, result);
                decoder.decode(analysisParsedGraph.getEncodedGraph());
            }
            debug.dump(1, (Object)result, "InlineBeforeAnalysis after decode");
            StructuredGraph structuredGraph = result;
            return structuredGraph;
        }
        catch (Throwable ex) {
            throw debug.handle(ex);
        }
    }

    public static class Options {
        @Option(help={"Inline methods before static analysis"})
        public static final OptionKey<Boolean> InlineBeforeAnalysis = new OptionKey((Object)true);
    }
}

