/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AccessFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;

public abstract class StoreFieldTypeFlow
extends AccessFieldTypeFlow {
    protected StoreFieldTypeFlow(ValueNode node, AnalysisField field) {
        super(node, field);
    }

    protected StoreFieldTypeFlow(StoreFieldTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState newState) {
        return this.declaredTypeFilter(bb, newState);
    }

    public static class StoreInstanceFieldTypeFlow
    extends StoreFieldTypeFlow {
        private final TypeFlow<?> valueFlow;
        private TypeFlow<?> objectFlow;

        StoreInstanceFieldTypeFlow(ValueNode node, AnalysisField field, TypeFlow<?> valueFlow, TypeFlow<?> objectFlow) {
            super(node, field);
            this.valueFlow = valueFlow;
            this.objectFlow = objectFlow;
        }

        StoreInstanceFieldTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, StoreInstanceFieldTypeFlow original) {
            super(original, methodFlows);
            this.valueFlow = methodFlows.lookupCloneOf(bb, original.valueFlow);
            this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
        }

        public StoreInstanceFieldTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new StoreInstanceFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public TypeFlow<?> receiver() {
            return this.objectFlow;
        }

        @Override
        public void setObserved(TypeFlow<?> newObjectFlow) {
            this.objectFlow = newObjectFlow;
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            objectState = this.filterObjectState(bb, objectState);
            for (AnalysisObject receiver : objectState.objects()) {
                FieldTypeFlow fieldFlow = receiver.getInstanceFieldFlow(bb, this.objectFlow, (BytecodePosition)this.source, this.field, true);
                this.addUse(bb, fieldFlow);
            }
        }

        @Override
        public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
            assert (this.isClone());
            this.replaceObservedWith(bb, this.field.getDeclaringClass());
        }

        @Override
        public String toString() {
            return "StoreInstanceFieldTypeFlow<" + this.getState() + ">";
        }
    }

    public static class StoreStaticFieldTypeFlow
    extends StoreFieldTypeFlow {
        private final FieldTypeFlow fieldFlow;
        private final TypeFlow<?> valueFlow;

        StoreStaticFieldTypeFlow(ValueNode node, AnalysisField field, TypeFlow<?> valueFlow, FieldTypeFlow fieldFlow) {
            super(node, field);
            this.valueFlow = valueFlow;
            this.fieldFlow = fieldFlow;
        }

        StoreStaticFieldTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, StoreStaticFieldTypeFlow original) {
            super(original, methodFlows);
            this.valueFlow = methodFlows.lookupCloneOf(bb, original.valueFlow);
            this.fieldFlow = original.fieldFlow;
        }

        public StoreFieldTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new StoreStaticFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void initClone(PointsToAnalysis bb) {
            this.addUse(bb, this.fieldFlow);
        }

        @Override
        public String toString() {
            return "StoreStaticFieldTypeFlow<" + this.getState() + ">";
        }
    }
}

