/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.websocket.platform.processors;



import org.glassfish.websocket.api.annotations.WebSocketRemote;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

import javax.annotation.processing.*;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.*;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import java.util.*;
/**
 *
 * @author dannycoward
 */



public class RemoteProcessor {
    private ProcessingEnvironment processingEnv;
    private Map<Element, Element> methodToClassMap;
    private Map<Element, List<Element>> classToMethodListMap;
    private Map<String, String> interfaceToImplementationFQClassnames = new HashMap<String, String>();

    public RemoteProcessor(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public String getImplementationFor(String remoteInterfaceName) {
        //System.out.println("get implementation for: " + remoteInterfaceName);

        return interfaceToImplementationFQClassnames.get(remoteInterfaceName);

    }

    public static String getWrapperClassnameFor(String classname) {
        String className = classname.substring(classname.lastIndexOf(".")+1, classname.length());
        return className + "_RemoteImpl"; // FIXIT this should be based on long classnames
    }

    private boolean createRemoteImpls(Set annotations, RoundEnvironment roundEnv) {
        try {
            this.classToMethodListMap = new HashMap<Element, List<Element>>();
            for (Element nextClass : roundEnv.getRootElements()) {

                WebSocketRemote wsr = nextClass.getAnnotation(WebSocketRemote.class);

                if (wsr != null && this.getMethods(nextClass) != null) {
                    List<Element> aMethods = this.getMethods(nextClass);
                    this.checkImplementsPeer(nextClass);
                    classToMethodListMap.put(nextClass, aMethods);

                    //System.out.println("----" + classToMethodListMap);
                    String nextClazzQualName = ((TypeElement) nextClass).getQualifiedName().toString();
                    String wrapperPackage = ProcessorUtils.getWrapperPackageNameFor(nextClazzQualName);
                    String wrapperClassname = getWrapperClassnameFor(nextClazzQualName);
                    //System.out.println("->"+wrapperPackage);
                    //System.out.println("->"+wrapperClassname);
                    String wrapperFQName = wrapperPackage + "." + wrapperClassname;
                    interfaceToImplementationFQClassnames.put(nextClazzQualName, wrapperFQName);
                    JavaFileObject f = processingEnv.getFiler().
                                createSourceFile(wrapperFQName);

                    processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE,
                            "Creating " + f.toUri());
                    Writer w = f.openWriter();
                    try {
                        PrintWriter pw = new PrintWriter(w);
                        RemoteClassWriter.writePackageAndImports(pw, wrapperPackage);

                        pw.println();
                        RemoteClassWriter.writeClassDeclaration(nextClass, pw, nextClazzQualName, wrapperClassname, aMethods, wsr);
                        pw.println();
                        pw.close();
                    } catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }

        return true;
    }

    private void checkImplementsPeer(Element nextClass) {
        //System.out.println(nextClass);
        boolean ok = false;
        TypeElement te = (TypeElement) nextClass;
        List interfaces = te.getInterfaces();
        String wsRemoteName = org.glassfish.websocket.api.Peer.class.getName();
        for (TypeMirror nextInterface : te.getInterfaces()) {
            System.out.println(nextInterface.toString());
            if (wsRemoteName.equals(nextInterface.toString())) {
                ok = true;
            }
        }
        if (!ok) {
            throw new RuntimeException(nextClass + "does not implement WSRemote");
        }
    }

    private List<Element> getMethods(Element clazz) {
        List<Element> l = new ArrayList<Element>();
        if (clazz instanceof TypeElement) {
                for (Element next : clazz.getEnclosedElements()) {
                    if (next.getKind() == ElementKind.METHOD
                            && next.getEnclosingElement() == clazz) {

                        l.add(next);

                    }
                }
        }
        return l;
    }

    private List<Element> getAnnotatedMethods(Element clazz) {
        List<Element> l = new ArrayList<Element>();
        if (clazz instanceof TypeElement) {
                for (Element annotatedThing : clazz.getEnclosedElements()) {
                    if (annotatedThing.getKind() == ElementKind.METHOD
                            && annotatedThing.getEnclosingElement() == clazz) {
                        WebSocketRemote remoteAn = annotatedThing.getAnnotation(WebSocketRemote.class);
                        if (remoteAn != null) {
                            l.add(annotatedThing);
                        }
                    }
                }
        }
        return l;
    }

    public boolean process(Set annotations, RoundEnvironment roundEnv) {
        return this.createRemoteImpls(annotations, roundEnv);
    }

    private Map<Element, Element> analyzeAnnotatedElements(Set annotations,
                                                        RoundEnvironment roundEnv) {
        Map<Element, Element> methodToClassMap = new HashMap<Element, Element>();
        for (Element nextClass : roundEnv.getRootElements()) {
            if (nextClass instanceof TypeElement) {
                for (Element annotatedThing : nextClass.getEnclosedElements()) {
                    if (annotatedThing.getKind() == ElementKind.METHOD
                            && annotatedThing.getEnclosingElement() == nextClass) {
                        WebSocketRemote remoteAn = annotatedThing.getAnnotation(WebSocketRemote.class);
                        if (remoteAn != null) {
                            methodToClassMap.put(annotatedThing, nextClass);
                        }
                    }
                }
            }
        }
        return methodToClassMap;
    }
}
