/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.websocket.platform.processors;

import org.glassfish.websocket.api.annotations.WebSocket;
import org.glassfish.websocket.api.annotations.WebSocketError;
import org.glassfish.websocket.platform.WebSocketEndpoint;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.*;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.element.AnnotationMirror;
/**
 *
 * @author dannycoward
 */
public class MethodWriter {

    static String getClassLevelPath(Element clazz) {
        WebSocket ws = clazz.getAnnotation(org.glassfish.websocket.api.annotations.WebSocket.class);
        if (ws != null) {
            return ws.path();
        } else {
            return "";
        }
    }

    static void writeExceptionHandlerMethodBody(TypeElement clazz, Set<Element> methods, PrintWriter pw) {
        for (Element method : methods) {
            WebSocketError wse = method.getAnnotation(org.glassfish.websocket.api.annotations.WebSocketError.class);
            if (wse != null) {
                String endPointPath = getClassLevelPath(clazz);
                pw.println("\t\tif (true) {");
                pw.println("\t\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");

                pw.println("\t\t\tbean." + method.getSimpleName() + "(e, wsw);");
                pw.println("\t\t}");
            }
        }
    }

    static boolean checkRemoteMatching(TypeElement clazz, String remoteImpl, RemoteProcessor rp) {
        boolean match = false;
        String classDeclaredRemoteImpl = "";
        WebSocket wsa = clazz.getAnnotation(WebSocket.class);
        String classLevelRemoteIfc = MethodWriter.getRemoteClassFromWebSocket(wsa);
        if (!classLevelRemoteIfc.equals("java.lang.Object")) {
            classDeclaredRemoteImpl = rp.getImplementationFor(classLevelRemoteIfc);
            match =  classDeclaredRemoteImpl.equals(remoteImpl);
        }
        if (!match) {
            throw new RuntimeException("Syntax error ?  A method on class :"+clazz.getQualifiedName()+": is looking for an :" + remoteImpl + ": But its class declares :" + classLevelRemoteIfc + ": as a remote ifc with impl is :" + classDeclaredRemoteImpl + ":. ???" );
        }
        return true;
    }

    static void writeOnOpenMethod(TypeElement clazz,
                                    Element method,
                                    RemoteProcessor rp,
                                    PrintWriter pw) {
        String openMethodName = method.getSimpleName().toString();
        ExecutableElement eMethod = (ExecutableElement) method;

        pw.println("\tpublic void onConnect(WebSocket socket) {");
        pw.println("\t\tsuper.onConnect(socket);");
        if (eMethod.getParameters().size() == 1) {
            VariableElement ve = eMethod.getParameters().get(0);
            String remoteInterface = ve.asType().toString();
            String riclz = rp.getImplementationFor(remoteInterface);
            if (riclz == null) {
                pw.println("\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");
            } else {
                checkRemoteMatching(clazz, riclz, rp);
                pw.println("\t\t\t"+riclz+" wsw = ("+riclz+") WebSocketWrapper.getWebSocketWrapper(socket, this);");
            }
        } else {
            throw new RuntimeException("onConnect method "+openMethodName+"must have one parameter");
        }



        //pw.println("\t\tWebSocketWrapper wsw = WSBeanServer.createWebSocketWrapper(socket);");
        pw.println("\t\tbean." + openMethodName + "(wsw);");
        pw.println("\t}");
    }

    static void writeOnMessageMethod(TypeElement clazz,
                                    List<Element> methods,
                                    RemoteProcessor rp,
                                    PrintWriter pw) throws IOException {
        pw.println("\tpublic void onMessage(WebSocket socket, String messageString) {");
        //pw.println("\tSystem.out.println(\"START on message: \" +messageString);");
        //pw.println("\t\tString messageString = frame.getTextPayload();");
        for (Element nextMethod : methods) {
            MethodWriter.writeOnMessageCallbackBlockFor(clazz, nextMethod, rp, pw);
         }
         //pw.println("\tSystem.out.println(\"END on message: \" +messageString);");
         pw.println("\t}");

    }


    private static void writeOnMessageCallbackBlockFor(TypeElement clazz,
                                                        Element method,
                                                        RemoteProcessor rp,
                                                        PrintWriter pw) throws IOException {
        ExecutableElement methodAsMethod = (ExecutableElement) method;
        OnMessageMethodHelper onMessageMethodHelper = new OnMessageMethodHelper(methodAsMethod);

        String endPointPath = getClassLevelPath(clazz);
        String dynamicPath = onMessageMethodHelper.getAnnotation().dynamicPath();

        pw.println("\t\tif (super.doesPathMatch(\"" + dynamicPath + "\")) {");
        //pw.println("System.out.println(\"here\");");
        if (onMessageMethodHelper.getPeerParameterElement() == null) {
            pw.println("\t\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");
        } else {
            String remoteInterface = onMessageMethodHelper.getPeerParameterElement().asType().toString();
            String riclz = rp.getImplementationFor(remoteInterface);
            if (riclz == null) { // ordinary Peer
                pw.println("\t\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");
            } else { // custom peer
                checkRemoteMatching(clazz, riclz, rp);
                pw.println("\t\t\t"+riclz+" wsw = ("+riclz+") WebSocketWrapper.getWebSocketWrapper(socket, this);");
            }
        }
        // end declaration of web socket wrapper

        // now we will try to invoke the method
        // first determine the decoder to use
        //pw.println("System.out.println(\"in the on message wrapper impl\");");

        pw.println("\t\t\ttry {");
        String varNameForDecodedMessage = "decodedMessage";
        String dataParameterClassname = onMessageMethodHelper.getDataParameterElement().asType().toString();
        String boxedDataParameterClassname = WebSocketEndpoint.getClassTypeForTypeThatMightBePrimitive(dataParameterClassname);
        pw.println("\t\t\t\t" + boxedDataParameterClassname + " " + varNameForDecodedMessage + " = ("+boxedDataParameterClassname+") super.doDecode(messageString, \"" +dataParameterClassname+"\");");
        pw.println("\t\t\t\tif ("+varNameForDecodedMessage+" != null) {");

        // trying to create this string: parametersToWrite
        String parametersToWrite = varNameForDecodedMessage;

        if (onMessageMethodHelper.getDynamicPathParameterElement() != null) {
            pw.println("\t\t\t\t\tString pathSegment = super.getPathSegment();");
            parametersToWrite = parametersToWrite + ", pathSegment";
        }
        if (onMessageMethodHelper.getPeerParameterElement() != null) {
            parametersToWrite = parametersToWrite + ", wsw";
        }
        // done creating this string: parametersToWrite


        if (!onMessageMethodHelper.hasReturn()) { // this is the typical void case
            pw.println("\t\t\t\t\tbean." + method.getSimpleName() + "("+parametersToWrite + ");");
        } else {
            String returnClassname = onMessageMethodHelper.getReturnTypeMirror().toString();
            returnClassname = ProcessorUtils.convertPrimitiveToClassIfNec(returnClassname);
            pw.println("\t\t\t\t\t"+returnClassname+" returnMessage = bean." + onMessageMethodHelper.getMethodName() + "("+parametersToWrite + ");");
            pw.println("\t\t\t\t\tString returnMessageAsString = super.doEncode(returnMessage);");

            pw.println("\t\t\t\t\twsw.sendMessage(returnMessageAsString);");
        }
        pw.println("\t\t\t\t}");
        pw.println("\t\t\t} catch (Exception exception) {");
        pw.println("\t\t\t\tthis.handleException(socket, exception);");
        pw.println("\t\t\t}");

        pw.println("\t\t}");
    }

     // well known hack for dealing with classes in annotations
    static String getRemoteClassFromWebSocket(WebSocket wsa) {
        TypeMirror value = null;
        try {
            wsa.remote();
        } catch( MirroredTypeException mte ) {
            value = mte.getTypeMirror();
            return value.toString();

        }
        throw new RuntimeException("Error getting decoder name from " + wsa);
    }

    // known verbosity of annotation processing api :(
    static String getDecoderClassFromWebSocketForType(TypeElement clazz, String firstParameterClassname) {
        Class[] decoders = null;
        WebSocket wsa = clazz.getAnnotation(WebSocket.class);

        for( AnnotationMirror am : clazz.getAnnotationMirrors() ) {
            //System.out.println(am.getAnnotationType());
            //System.out.println(am.getElementValues());
            // I know...
            boolean isAmWebSocketTypeMirror = am.getAnnotationType().toString().equals(WebSocket.class.getCanonicalName());

            if (isAmWebSocketTypeMirror) {
                for (ExecutableElement elt : am.getElementValues().keySet()) {
                    //System.out.println(elt.getSimpleName() + " decoders");

                    if (elt.getSimpleName().toString().equals("decoders")) { // yuck
                        //System.out.println("IUYJBS");
                        List decodersL = (List) am.getElementValues().get(elt).getValue();
                        //System.out.println(decodersL);
                        for (Object nextDecoderClassnameDotClass : decodersL) {
                            //System.out.println("-" + next);
                            //System.out.println("-" + next.getClass());
                            // ok now we need to decide which of the decoders can cope with the method parameter
                            System.out.println("*" + nextDecoderClassnameDotClass);
                            boolean works = doesDecoderWorkFor(nextDecoderClassnameDotClass.toString(), firstParameterClassname);
                            if (works) {
                                return nextDecoderClassnameDotClass.toString();
                            }


                        }
                        throw new RuntimeException("Stop !!");


                    }
                }
            }


        }


        return null;
    }

    static boolean doesDecoderWorkFor(String decoderClassname, String type) {
        try {
            Class decoderClass = Class.forName(decoderClassname.substring(0, decoderClassname.length() - 6));
            System.out.println("--" + decoderClass);
            System.out.println("**" + decoderClass.getGenericInterfaces());
            // is the decoder parametrised with the type of
            Class typeClass = Class.forName(type.substring(0, type.length()-5));


            return false;
        } catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return false;
    }



    private static String createVariableDeclarationForDecodedMessage(String firstParameterClassname, String varNameForDecodedMessage) {
        String variableDeclarationForDecodedMessage = "";
        if (firstParameterClassname.equals("java.lang.String")) {
        // assume its a string
            variableDeclarationForDecodedMessage = "String "+varNameForDecodedMessage+" = messageString;";
            //pw.println("\t\t\tString "+varNameForDecodedMessage+" = messageString;");
        } else if (firstParameterClassname.equals("boolean")) {
            variableDeclarationForDecodedMessage = "boolean "+varNameForDecodedMessage+" = (new Boolean(messageString)).booleanValue();";
        } else if (firstParameterClassname.equals("int")) {
            variableDeclarationForDecodedMessage = "int "+varNameForDecodedMessage+" = (new Integer(messageString)).intValue();";
        } else if (firstParameterClassname.equals("short")) {
            variableDeclarationForDecodedMessage = "short "+varNameForDecodedMessage+" = (new Short(messageString)).shortValue();";
        } else if (firstParameterClassname.equals("long")) {
            variableDeclarationForDecodedMessage = "long "+varNameForDecodedMessage+" = (new Long(messageString)).longValue();";
        } else if (firstParameterClassname.equals("char")) {
            // FIXIT could use a more stringesnt test here rather than cherry picking the first character.
            variableDeclarationForDecodedMessage = "char "+varNameForDecodedMessage+" = messageString.charAt(0);";
        } else if (firstParameterClassname.equals("float")) {
            variableDeclarationForDecodedMessage = "float "+varNameForDecodedMessage+" = (new Float(messageString)).floatValue();";
        } else if (firstParameterClassname.equals("double")) {
            variableDeclarationForDecodedMessage = "double "+varNameForDecodedMessage+" = (new Double(messageString)).doubleValue();";
         } else if (typeHasSingleStringConstructor(firstParameterClassname)) {
            variableDeclarationForDecodedMessage = firstParameterClassname+" "+varNameForDecodedMessage+" = new "+firstParameterClassname+"(messageString);";
         } else if (!"".equals(typeHasFactoryMethod(firstParameterClassname)) ) {
            String methodName = typeHasFactoryMethod(firstParameterClassname);
            variableDeclarationForDecodedMessage = firstParameterClassname+" "+varNameForDecodedMessage+" = " + firstParameterClassname+"."+methodName+"(messageString);";
        } else {
            System.out.println("AAAAAGH, ok it works , but don't do this !");
            variableDeclarationForDecodedMessage = "byte[] " +varNameForDecodedMessage+ " = messageString.getBytes();";

        }
        return variableDeclarationForDecodedMessage;

    }

    // return true for a class that can be loaded and that has a constructor with
    // a single string argument. e.g. new Thread(name);
    private static boolean typeHasSingleStringConstructor(String firstParameterClassname) {
        //System.out.println(" test " + firstParameterClassname);
        try {
            Class c = Class.forName(firstParameterClassname); // FIXIT think about the classloader for this...
            for (Constructor cons : c.getConstructors()) {
                if ( cons.getParameterTypes().length == 1 ) {
                    if (cons.getParameterTypes()[0].equals(java.lang.String.class)) {
                        return true;
                    }
                }
            }

        } catch (Throwable t) {
            System.out.println("Warning: cound not load " + firstParameterClassname);
        }

        return false;
    }

    private static String typeHasFactoryMethod(String firstParameterClassname) {
        //System.out.println(" test " + firstParameterClassname);
        try {
            Class c = Class.forName(firstParameterClassname); // FIXIT think about the classloader for this...
            for (Method method : c.getMethods()) {
                int modifiers = method.getModifiers();
                boolean isStatic = java.lang.reflect.Modifier.isStatic(modifiers);
                boolean isPublic = java.lang.reflect.Modifier.isPublic(modifiers);
                String name = method.getName();
                if ( !(isStatic && isPublic) ) {
                    return "";
                }

                if (name.equals("valueOf") ||
                    name.equals("fromString") ) {
                    if ( method.getParameterTypes().length == 1 ) {
                        if (method.getParameterTypes()[0].equals(java.lang.String.class)) {
                            return name;
                        }
                    }
                }
            }

        } catch (Throwable t) {
            System.out.println("Warning: cound not load " + firstParameterClassname);
        }

        return "";
    }

    static void writeOnCloseMethod(TypeElement clazz, Element method, RemoteProcessor rp, PrintWriter pw) {
        String closeMethodName = method.getSimpleName().toString();
        ExecutableElement eMethod = (ExecutableElement) method;
        pw.println("\tpublic void onClose(WebSocket socket) {");
        if (eMethod.getParameters().size() == 1) {
            VariableElement ve = eMethod.getParameters().get(0);
            String remoteInterface = ve.asType().toString();
            String riclz = rp.getImplementationFor(remoteInterface);
            if (riclz == null) {
                pw.println("\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");
            } else {
                checkRemoteMatching(clazz, riclz, rp);
                pw.println("\t\t\t"+riclz+" wsw = ("+riclz+") WebSocketWrapper.getWebSocketWrapper(socket, this);");
            }
        } else {
            throw new RuntimeException("onOpen method "+closeMethodName+"must have one parameter");
        }
        pw.println("\t\tbean." + closeMethodName + "(wsw);");
        pw.println("\t}");
    }


}
