/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.metro.api.config.management;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.Reconfigurable;
import com.sun.xml.ws.api.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.metro.api.config.management.CommunicationServer;
import com.sun.xml.ws.metro.api.config.management.ConfigReader;
import com.sun.xml.ws.metro.api.config.management.ConfigSaver;
import com.sun.xml.ws.metro.api.config.management.Configurator;
import com.sun.xml.ws.metro.api.config.management.EndpointStarter;
import com.sun.xml.ws.metro.api.config.management.ManagedHttpMetadataPublisher;
import com.sun.xml.ws.metro.api.config.management.ManagementFactory;
import com.sun.xml.ws.metro.api.config.management.ReconfigNotifier;
import com.sun.xml.ws.policy.PolicyMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedEndpoint<T>
extends WSEndpoint<T>
implements EndpointStarter {
    public static final String ENDPOINT_ID_PARAMETER_NAME = "ENDPOINT_ID";
    public static final String ENDPOINT_INSTANCE_PARAMETER_NAME = "ENDPOINT_INSTANCE";
    public static final String CREATION_ATTRIBUTES_PARAMETER_NAME = "CREATION_ATTRIBUTES";
    public static final String CLASS_LOADER_PARAMETER_NAME = "CLASS_LOADER";
    public static final String ENDPOINT_STARTER_PARAMETER_NAME = "ENDPOINT_STARTER";
    private static final Logger LOGGER = Logger.getLogger(ManagedEndpoint.class);
    private final String id;
    private WSEndpoint<T> endpointDelegate;
    private ManagedServiceAssertion assertion;
    private final CountDownLatch startSignal = new CountDownLatch(1);
    private final Collection<CommunicationServer<T>> commInterfaces;
    private final Collection<ReconfigNotifier> reconfigNotifiers = new LinkedList<ReconfigNotifier>();
    private final Configurator<T> configurator;
    private static final long ENDPOINT_DISPOSE_DELAY_DEFAULT = 120000L;
    private final long endpointDisposeDelay;
    private final ScheduledExecutorService disposeThreadPool = Executors.newScheduledThreadPool(1);

    public ManagedEndpoint(String id, WSEndpoint<T> endpoint, EndpointCreationAttributes attributes) {
        try {
            this.id = id;
            this.endpointDelegate = endpoint;
            this.assertion = ManagedServiceAssertion.getAssertion(endpoint);
            this.endpointDisposeDelay = this.assertion.getEndpointDisposeDelay(120000L);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            ManagementFactory factory = new ManagementFactory(this.assertion);
            ConfigReader reader = factory.createConfigReaderImpl(this, attributes, classLoader, this);
            ConfigSaver saver = factory.createConfigSaverImpl(this);
            this.configurator = factory.createConfiguratorImpl(this, reader, saver);
            this.commInterfaces = factory.createCommunicationImpls(this, attributes, classLoader, this.configurator, this);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5055_STARTING_CONFIGURATOR(this.configurator));
            }
            this.configurator.start();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5056_STARTED_CONFIGURATOR(this.configurator));
            }
            for (CommunicationServer<T> commInterface : this.commInterfaces) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(ManagementMessages.WSM_5057_STARTING_COMMUNICATION(commInterface));
                }
                commInterface.start();
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(ManagementMessages.WSM_5058_STARTED_COMMUNICATION(commInterface));
            }
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(ManagementMessages.WSM_5065_BLOCKING_ENDPOINT());
            }
            this.startSignal.await();
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(ManagementMessages.WSM_5066_STARTING_ENDPOINT());
            }
        }
        catch (InterruptedException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5099_START_INTERRUPTED(), (Throwable)e));
        }
    }

    public void addNotifier(ReconfigNotifier notifier) {
        this.reconfigNotifiers.add(notifier);
    }

    @Override
    public void startEndpoint() {
        this.startSignal.countDown();
        for (ReconfigNotifier notifier : this.reconfigNotifiers) {
            notifier.sendNotification();
        }
    }

    public String getId() {
        return this.id;
    }

    public synchronized void swapEndpointDelegate(WSEndpoint<T> endpoint) {
        Set<EndpointComponent> endpointComponents = endpoint.getComponentRegistry();
        endpointComponents.add(new ManagedHttpMetadataPublisher());
        WSEndpoint<T> oldEndpoint = this.endpointDelegate;
        this.endpointDelegate = endpoint;
        for (EndpointComponent component : endpointComponents) {
            Reconfigurable reconfigurable = component.getSPI(Reconfigurable.class);
            if (reconfigurable == null) continue;
            reconfigurable.reconfigure();
        }
        this.disposeDelegate(oldEndpoint);
        LOGGER.info(ManagementMessages.WSM_5000_RECONFIGURED_ENDPOINT(this.id));
    }

    @Override
    public synchronized void dispose() {
        for (CommunicationServer<T> commInterface : this.commInterfaces) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(ManagementMessages.WSM_5061_STOPPING_COMMUNICATION(commInterface));
                }
                commInterface.stop();
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(ManagementMessages.WSM_5062_STOPPED_COMMUNICATION(commInterface));
            }
            catch (WebServiceException e) {
                LOGGER.severe(ManagementMessages.WSM_5063_FAILED_COMMUNICATION_STOP(commInterface));
            }
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5059_STOPPING_CONFIGURATOR(this.configurator));
            }
            this.configurator.stop();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5060_STOPPED_CONFIGURATOR(this.configurator));
            }
        }
        catch (WebServiceException e) {
            LOGGER.severe(ManagementMessages.WSM_5064_FAILED_CONFIGURATOR_STOP(this.configurator));
        }
        this.disposeThreadPool.shutdown();
        if (this.endpointDelegate != null) {
            this.endpointDelegate.dispose();
        }
    }

    @Override
    public Codec createCodec() {
        return this.endpointDelegate.createCodec();
    }

    @Override
    public QName getServiceName() {
        return this.endpointDelegate.getServiceName();
    }

    @Override
    public QName getPortName() {
        return this.endpointDelegate.getPortName();
    }

    @Override
    public Class<T> getImplementationClass() {
        return this.endpointDelegate.getImplementationClass();
    }

    @Override
    public WSBinding getBinding() {
        return this.endpointDelegate.getBinding();
    }

    @Override
    public Container getContainer() {
        return this.endpointDelegate.getContainer();
    }

    @Override
    public WSDLPort getPort() {
        return this.endpointDelegate.getPort();
    }

    @Override
    public void setExecutor(Executor exec) {
        this.endpointDelegate.setExecutor(exec);
    }

    @Override
    public void schedule(Packet request, WSEndpoint.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        this.endpointDelegate.schedule(request, callback, interceptor);
    }

    @Override
    public void process(Packet request, WSEndpoint.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        this.endpointDelegate.process(request, callback, interceptor);
    }

    @Override
    public WSEndpoint.PipeHead createPipeHead() {
        return this.endpointDelegate.createPipeHead();
    }

    @Override
    public ServiceDefinition getServiceDefinition() {
        return this.endpointDelegate.getServiceDefinition();
    }

    @Override
    public Set<EndpointComponent> getComponentRegistry() {
        return this.endpointDelegate.getComponentRegistry();
    }

    @Override
    public SEIModel getSEIModel() {
        return this.endpointDelegate.getSEIModel();
    }

    @Override
    public PolicyMap getPolicyMap() {
        return this.endpointDelegate.getPolicyMap();
    }

    @Override
    public ManagedObjectManager getManagedObjectManager() {
        return this.endpointDelegate.getManagedObjectManager();
    }

    @Override
    public void closeManagedObjectManager() {
        this.endpointDelegate.closeManagedObjectManager();
    }

    @Override
    public ServerTubeAssemblerContext getAssemblerContext() {
        return this.endpointDelegate.getAssemblerContext();
    }

    private void disposeDelegate(final WSEndpoint<T> endpoint) {
        Runnable dispose = new Runnable(){
            final WSEndpoint<T> disposableEndpoint;
            {
                this.disposableEndpoint = endpoint;
            }

            public void run() {
                try {
                    this.disposableEndpoint.dispose();
                }
                catch (WebServiceException e) {
                    LOGGER.severe(ManagementMessages.WSM_5101_DISPOSE_FAILED(), e);
                }
            }
        };
        this.disposeThreadPool.schedule(dispose, this.endpointDisposeDelay, TimeUnit.MILLISECONDS);
    }
}

