/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.filter;

import java.util.regex.Pattern;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.filter.matcher.ContainsMatcher;
import org.fluentlenium.core.filter.matcher.EndsWithMatcher;
import org.fluentlenium.core.filter.matcher.EqualMatcher;
import org.fluentlenium.core.filter.matcher.Matcher;
import org.fluentlenium.core.filter.matcher.NotContainsMatcher;
import org.fluentlenium.core.filter.matcher.NotEndsWithMatcher;
import org.fluentlenium.core.filter.matcher.NotStartsWithMatcher;
import org.fluentlenium.core.filter.matcher.StartsWithMatcher;

public class FilterBuilder {
    String attribute;

    public FilterBuilder(String customAttribute) {
        this.attribute = customAttribute;
    }

    public FilterBuilder(FilterType filterType) {
        this.attribute = filterType.name();
    }

    public Filter equalTo(String equal) {
        return new Filter(this.attribute, (Matcher)new EqualMatcher(equal));
    }

    public Filter contains(String equal) {
        return new Filter(this.attribute, (Matcher)new ContainsMatcher(equal));
    }

    public Filter contains(Pattern equal) {
        return new Filter(this.attribute, (Matcher)new ContainsMatcher(equal));
    }

    public Filter startsWith(String equal) {
        return new Filter(this.attribute, (Matcher)new StartsWithMatcher(equal));
    }

    public Filter startsWith(Pattern equal) {
        return new Filter(this.attribute, (Matcher)new StartsWithMatcher(equal));
    }

    public Filter endsWith(String equal) {
        return new Filter(this.attribute, (Matcher)new EndsWithMatcher(equal));
    }

    public Filter endsWith(Pattern equal) {
        return new Filter(this.attribute, (Matcher)new EndsWithMatcher(equal));
    }

    public Filter notContains(String equal) {
        return new Filter(this.attribute, (Matcher)new NotContainsMatcher(equal));
    }

    public Filter notContains(Pattern equal) {
        return new Filter(this.attribute, (Matcher)new NotContainsMatcher(equal));
    }

    public Filter notStartsWith(String equal) {
        return new Filter(this.attribute, (Matcher)new NotStartsWithMatcher(equal));
    }

    public Filter notStartsWith(Pattern equal) {
        return new Filter(this.attribute, (Matcher)new NotStartsWithMatcher(equal));
    }

    public Filter notEndsWith(String equal) {
        return new Filter(this.attribute, (Matcher)new NotEndsWithMatcher(equal));
    }

    public Filter notEndsWith(Pattern equal) {
        return new Filter(this.attribute, (Matcher)new NotEndsWithMatcher(equal));
    }
}

