/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.FluentThread;
import org.fluentlenium.core.action.FillConstructor;
import org.fluentlenium.core.action.FluentDefaultActions;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchActions;
import org.fluentlenium.core.wait.FluentWait;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Fluent
implements SearchActions {
    private WebDriver driver;
    private String baseUrl;
    private Search search;

    public Fluent(WebDriver driver) {
        this.driver = driver;
        this.search = new Search((SearchContext)driver);
        FluentThread.set(this);
    }

    public Fluent withDefaultUrl(String baseUrl) {
        if (baseUrl != null) {
            if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            this.baseUrl = baseUrl;
        }
        return this;
    }

    public Fluent withDefaultPageWait(long l, TimeUnit timeUnit) {
        this.getDriver().manage().timeouts().pageLoadTimeout(l, timeUnit);
        return this;
    }

    public Fluent withDefaultSearchWait(long l, TimeUnit timeUnit) {
        this.getDriver().manage().timeouts().implicitlyWait(l, timeUnit);
        return this;
    }

    public Fluent() {
        FluentThread.set(this);
    }

    public Fluent takeScreenShot() {
        this.takeScreenShot(new Date().getTime() + ".png");
        return this;
    }

    public Fluent takeScreenShot(String fileName) {
        File scrFile = (File)((TakesScreenshot)this.getDriver()).getScreenshotAs(OutputType.FILE);
        try {
            File destFile = new File(fileName);
            FileUtils.copyFile((File)scrFile, (File)destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error when taking the snapshot", e);
        }
        return this;
    }

    protected final Fluent initFluent(WebDriver driver) {
        this.driver = driver;
        this.search = new Search((SearchContext)driver);
        return this;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public FluentWait await() {
        return new FluentWait(this.driver, this.search);
    }

    public String title() {
        return this.driver.getTitle();
    }

    public Set<Cookie> getCookies() {
        return this.driver.manage().getCookies();
    }

    public Cookie getCookie(String name) {
        return this.driver.manage().getCookieNamed(name);
    }

    public String url() {
        return this.driver.getCurrentUrl();
    }

    public String pageSource() {
        return this.driver.getPageSource();
    }

    public FluentPage goTo(FluentPage page) {
        if (page == null) {
            throw new IllegalArgumentException("Page is mandatory");
        }
        page.go();
        return page;
    }

    public Fluent goTo(String url) {
        URI uri;
        if (url == null) {
            throw new IllegalArgumentException("Url is mandatory");
        }
        if (this.baseUrl != null && !(uri = URI.create(url)).isAbsolute()) {
            url = this.baseUrl + url;
        }
        this.getDriver().get(url);
        return this;
    }

    public Fluent executeScript(String script) {
        ((JavascriptExecutor)this.driver).executeScript(script, new Object[0]);
        return this;
    }

    public FluentList<FluentWebElement> $(String name, Filter ... filters) {
        return this.search.find(name, filters);
    }

    public FluentWebElement $(String name, Integer number, Filter ... filters) {
        return this.search.find(name, number, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(String name, Filter ... filters) {
        return this.search.find(name, filters);
    }

    @Override
    public FluentWebElement find(String name, Integer number, Filter ... filters) {
        return this.search.find(name, number, filters);
    }

    @Override
    public FluentWebElement findFirst(String name, Filter ... filters) {
        return this.search.findFirst(name, filters);
    }

    public FillConstructor fill(String cssSelector, Filter ... filters) {
        return new FillConstructor(cssSelector, this.getDriver(), filters);
    }

    public FillConstructor fill(FluentDefaultActions list, Filter ... filters) {
        return new FillConstructor(list, this.getDriver(), filters);
    }

    public Fluent click(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).click();
        return this;
    }

    public Fluent clear(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).clear();
        return this;
    }

    public Fluent submit(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).submit();
        return this;
    }

    public List<String> text(String cssSelector, Filter ... filters) {
        return this.$(cssSelector, filters).getTexts();
    }

    public List<String> value(String cssSelector, Filter ... filters) {
        return this.$(cssSelector, filters).getValues();
    }

    public Fluent click(FluentDefaultActions fluentObject) {
        fluentObject.click();
        return this;
    }

    public Fluent clear(FluentList<FluentWebElement> fluentObject) {
        fluentObject.clear();
        return this;
    }

    public Fluent clear(FluentWebElement fluentObject) {
        fluentObject.clear();
        return this;
    }

    public Fluent submit(FluentDefaultActions fluentObject) {
        fluentObject.submit();
        return this;
    }
}

