/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.ee;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;

public final class StandardEEResolutionHints
implements ExecutionEnvironmentResolutionHints {
    private static final String JRE_ACTION_FALLBACK_EE = "JavaSE-1.6";
    private static final Version JRE_ACTION_FALLBACK_VERSION = Version.parseVersion((String)"1.6.0");
    private final String executionEnvironment;
    private final Map<VersionedId, IInstallableUnit> additionalUnits;
    private final Map<VersionedId, IInstallableUnit> temporaryUnits;

    public StandardEEResolutionHints(String executionEnvironment) {
        if (executionEnvironment == null) {
            throw new NullPointerException();
        }
        this.executionEnvironment = executionEnvironment;
        this.additionalUnits = StandardEEResolutionHints.computeAdditionalUnits(executionEnvironment);
        this.temporaryUnits = StandardEEResolutionHints.computeTemporaryAdditions(this.additionalUnits);
    }

    @Override
    public boolean isNonApplicableEEUnit(IInstallableUnit iu) {
        return iu.getId().startsWith("a.jre") || iu.getId().startsWith("config.a.jre");
    }

    @Override
    public boolean isEESpecificationUnit(IInstallableUnit unit) {
        throw new UnsupportedOperationException();
    }

    private static Map<VersionedId, IInstallableUnit> computeAdditionalUnits(String executionEnvironment) {
        LinkedHashMap<VersionedId, IInstallableUnit> units = new LinkedHashMap<VersionedId, IInstallableUnit>();
        StandardEEResolutionHints.addIUsFromEnvironment(executionEnvironment, units);
        StandardEEResolutionHints.ensureEEWasKnownToJREAction(executionEnvironment, units.values());
        return units;
    }

    static void addIUsFromEnvironment(String executionEnvironment, Map<VersionedId, IInstallableUnit> units) {
        PublisherResult results = new PublisherResult();
        new JREAction(executionEnvironment).perform((IPublisherInfo)new PublisherInfo(), (IPublisherResult)results, null);
        results.query(QueryUtil.ALL_UNITS, null);
        Iterator iterator = results.query(QueryUtil.ALL_UNITS, null).iterator();
        while (iterator.hasNext()) {
            StandardEEResolutionHints.put(units, (IInstallableUnit)iterator.next());
        }
    }

    private static void ensureEEWasKnownToJREAction(String executionEnvironment, Collection<IInstallableUnit> eeUnits) {
        for (IInstallableUnit unit : eeUnits) {
            if (!JRE_ACTION_FALLBACK_VERSION.equals(unit.getVersion()) || JRE_ACTION_FALLBACK_EE.equals(executionEnvironment)) continue;
            throw new RuntimeException("The execution environment '" + executionEnvironment + "' is not know by the embedded version of p2");
        }
    }

    @Override
    public Collection<IInstallableUnit> getMandatoryUnits() {
        return this.additionalUnits.values();
    }

    @Override
    public Collection<IRequirement> getMandatoryRequires() {
        return Collections.emptyList();
    }

    private static Map<VersionedId, IInstallableUnit> computeTemporaryAdditions(Map<VersionedId, IInstallableUnit> additionalUnits) {
        LinkedHashMap<VersionedId, IInstallableUnit> units = new LinkedHashMap<VersionedId, IInstallableUnit>();
        StandardEEResolutionHints.put(units, StandardEEResolutionHints.newIU("a.jre", Version.create((String)"1.6.0")));
        StandardEEResolutionHints.put(units, StandardEEResolutionHints.newIU("a.jre.javase", Version.create((String)"1.6.0")));
        StandardEEResolutionHints.put(units, StandardEEResolutionHints.newIU("config.a.jre.javase", Version.create((String)"1.6.0")));
        for (Map.Entry<VersionedId, IInstallableUnit> entry : additionalUnits.entrySet()) {
            units.remove(entry.getKey());
        }
        return units;
    }

    @Override
    public Collection<IInstallableUnit> getTemporaryAdditions() {
        return this.temporaryUnits.values();
    }

    private static IInstallableUnit newIU(String id, Version version) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        iud.setId(id);
        iud.setVersion(version);
        iud.addProvidedCapabilities(Collections.singleton(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (Version)version)));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
    }

    private static void put(Map<VersionedId, IInstallableUnit> units, IInstallableUnit unit) {
        units.put(new VersionedId(unit.getId(), unit.getVersion()), unit);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.executionEnvironment == null ? 0 : this.executionEnvironment.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StandardEEResolutionHints)) {
            return false;
        }
        StandardEEResolutionHints other = (StandardEEResolutionHints)obj;
        return StandardEEResolutionHints.eq(this.executionEnvironment, other.executionEnvironment);
    }

    private static <T> boolean eq(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }
}

