/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.HashMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyWebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(JettyWebXmlConfiguration.class);
    public static final String PROPERTY_THIS_WEB_INF_URL = "this.web-inf.url";
    public static final String XML_CONFIGURATION = "org.eclipse.jetty.webapp.JettyWebXmlConfiguration";
    public static final String JETTY_WEB_XML = "jetty-web.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(WebAppContext context) throws Exception {
        if (context.isStarted()) {
            LOG.debug("Cannot configure webapp after it is started", new Object[0]);
            return;
        }
        LOG.debug("Configuring web-jetty.xml", new Object[0]);
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource jetty = web_inf.addPath("jetty8-web.xml");
            if (!jetty.exists()) {
                jetty = web_inf.addPath(JETTY_WEB_XML);
            }
            if (!jetty.exists()) {
                jetty = web_inf.addPath("web-jetty.xml");
            }
            if (jetty.exists()) {
                String[] old_server_classes = context.getServerClasses();
                try {
                    XmlConfiguration jetty_config;
                    context.setServerClasses(null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Configure: " + jetty, new Object[0]);
                    }
                    if ((jetty_config = (XmlConfiguration)context.getAttribute(XML_CONFIGURATION)) == null) {
                        jetty_config = new XmlConfiguration(jetty.getURL());
                    } else {
                        context.removeAttribute(XML_CONFIGURATION);
                    }
                    this.setupXmlConfiguration(context, jetty_config, web_inf);
                    try {
                        jetty_config.configure((Object)context);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn("Unable to process jetty-web.xml", (Throwable)e);
                    }
                }
                finally {
                    if (context.getServerClasses() == null) {
                        context.setServerClasses(old_server_classes);
                    }
                }
            }
        }
    }

    private void setupXmlConfiguration(WebAppContext context, XmlConfiguration jetty_config, Resource web_inf) {
        this.setupXmlConfiguration(jetty_config, web_inf);
    }

    private void setupXmlConfiguration(XmlConfiguration jetty_config, Resource web_inf) {
        HashMap<String, String> props = jetty_config.getProperties();
        if (props == null) {
            props = new HashMap<String, String>();
            jetty_config.setProperties(props);
        }
        props.put(PROPERTY_THIS_WEB_INF_URL, String.valueOf(web_inf.getURL()));
    }
}

