/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncHttpConnection
extends HttpConnection {
    private static final Logger LOG = Log.getLogger(AsyncHttpConnection.class);

    public AsyncHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection handle() throws IOException {
        AsyncHttpConnection connection;
        block32: {
            Connection connection2;
            block31: {
                connection = this;
                try {
                    AsyncHttpConnection.setCurrentConnection(this);
                    boolean progress = true;
                    boolean more_in_buffer = false;
                    while (this._endp.isOpen() && (more_in_buffer || progress)) {
                        Connection switched;
                        Object var6_5;
                        progress = false;
                        try {
                            block30: {
                                try {
                                    LOG.debug("async request", new Object[]{this._request});
                                    if (this._request._async.isAsync() && !this._request._async.isComplete()) {
                                        this.handleRequest();
                                    } else if (!this._parser.isComplete() && this._parser.parseAvailable() > 0) {
                                        progress = true;
                                    }
                                    if (this._generator.isCommitted() && !this._generator.isComplete() && this._generator.flushBuffer() > 0L) {
                                        progress = true;
                                    }
                                    if (!this._endp.isBufferingOutput()) break block30;
                                    this._endp.flush();
                                }
                                catch (HttpException e) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("uri=" + this._uri, new Object[0]);
                                        LOG.debug("fields=" + this._requestFields, new Object[0]);
                                        LOG.debug((Throwable)e);
                                    }
                                    this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                                    this._parser.reset();
                                    this._endp.close();
                                    var6_5 = null;
                                    if (this._endp.isInputShutdown() && (this._parser.isIdle() || this._parser.isComplete())) {
                                        LOG.debug("complete half close {}", new Object[]{this});
                                        more_in_buffer = false;
                                        this._endp.close();
                                        this.reset(true);
                                        continue;
                                    }
                                    if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                                        if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                            this._parser.reset();
                                            this._generator.reset(true);
                                            Connection connection3 = switched;
                                            Object var10_11 = null;
                                            AsyncHttpConnection.setCurrentConnection(null);
                                            this._parser.returnBuffers();
                                            if (this._generator.isCommitted() && !this._generator.isComplete()) {
                                                ((AsyncEndPoint)this._endp).scheduleWrite();
                                                return connection3;
                                            }
                                            this._generator.returnBuffers();
                                            return connection3;
                                        }
                                        progress = true;
                                        this.reset(false);
                                        more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                                        continue;
                                    }
                                    if (this._request.isAsyncStarted()) {
                                        LOG.debug("suspended {}", new Object[]{this});
                                        more_in_buffer = false;
                                        progress = false;
                                        continue;
                                    }
                                    more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                                    continue;
                                }
                            }
                            var6_5 = null;
                        }
                        catch (Throwable throwable) {
                            var6_5 = null;
                            if (this._endp.isInputShutdown() && (this._parser.isIdle() || this._parser.isComplete())) {
                                LOG.debug("complete half close {}", new Object[]{this});
                                more_in_buffer = false;
                                this._endp.close();
                                this.reset(true);
                                throw throwable;
                            }
                            if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                                if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                    this._parser.reset();
                                    this._generator.reset(true);
                                    Connection connection4 = switched;
                                    Object var10_12 = null;
                                    AsyncHttpConnection.setCurrentConnection(null);
                                    this._parser.returnBuffers();
                                    if (this._generator.isCommitted() && !this._generator.isComplete()) {
                                        ((AsyncEndPoint)this._endp).scheduleWrite();
                                        return connection4;
                                    }
                                    this._generator.returnBuffers();
                                    return connection4;
                                }
                                progress = true;
                                this.reset(false);
                                more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                                throw throwable;
                            }
                            if (this._request.isAsyncStarted()) {
                                LOG.debug("suspended {}", new Object[]{this});
                                more_in_buffer = false;
                                progress = false;
                                throw throwable;
                            }
                            more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            throw throwable;
                        }
                        if (this._endp.isInputShutdown() && (this._parser.isIdle() || this._parser.isComplete())) {
                            LOG.debug("complete half close {}", new Object[]{this});
                            more_in_buffer = false;
                            this._endp.close();
                            this.reset(true);
                            continue;
                        }
                        if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                            if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                this._parser.reset();
                                this._generator.reset(true);
                                connection2 = switched;
                                Object var10_10 = null;
                                break block31;
                            }
                            progress = true;
                            this.reset(false);
                            more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            continue;
                        }
                        if (this._request.isAsyncStarted()) {
                            LOG.debug("suspended {}", new Object[]{this});
                            more_in_buffer = false;
                            progress = false;
                            continue;
                        }
                        more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                    }
                    break block32;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    AsyncHttpConnection.setCurrentConnection(null);
                    this._parser.returnBuffers();
                    if (this._generator.isCommitted() && !this._generator.isComplete()) {
                        ((AsyncEndPoint)this._endp).scheduleWrite();
                        throw throwable;
                    }
                    this._generator.returnBuffers();
                    throw throwable;
                }
            }
            AsyncHttpConnection.setCurrentConnection(null);
            this._parser.returnBuffers();
            if (this._generator.isCommitted() && !this._generator.isComplete()) {
                ((AsyncEndPoint)this._endp).scheduleWrite();
                return connection2;
            }
            this._generator.returnBuffers();
            return connection2;
        }
        Object var10_13 = null;
        AsyncHttpConnection.setCurrentConnection(null);
        this._parser.returnBuffers();
        if (this._generator.isCommitted() && !this._generator.isComplete()) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
            return connection;
        }
        this._generator.returnBuffers();
        return connection;
    }
}

