/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.SessionListener;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.server.HandshakeRFC6455;
import org.eclipse.jetty.websocket.server.UpgradeContext;
import org.eclipse.jetty.websocket.server.WebSocketHandshake;
import org.eclipse.jetty.websocket.server.WebSocketServerConnection;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class WebSocketServerFactory
extends ContainerLifeCycle
implements WebSocketCreator,
WebSocketServletFactory,
SessionListener {
    private static final Logger LOG = Log.getLogger(WebSocketServerFactory.class);
    private static final ThreadLocal<UpgradeContext> ACTIVE_CONTEXT = new ThreadLocal();
    private final Map<Integer, WebSocketHandshake> handshakes = new HashMap<Integer, WebSocketHandshake>();
    private final Scheduler scheduler;
    private final Queue<WebSocketSession> sessions;
    private final String supportedVersions;
    private final WebSocketPolicy defaultPolicy;
    private final EventDriverFactory eventDriverFactory;
    private final WebSocketExtensionFactory extensionFactory;
    private List<SessionFactory> sessionFactories;
    private Set<WebSocketSession> openSessions;
    private WebSocketCreator creator;
    private List<Class<?>> registeredSocketClasses;

    public static UpgradeContext getActiveUpgradeContext() {
        return ACTIVE_CONTEXT.get();
    }

    protected static void setActiveUpgradeContext(UpgradeContext connection) {
        ACTIVE_CONTEXT.set(connection);
    }

    public WebSocketServerFactory() {
        this(WebSocketPolicy.newServerPolicy(), new MappedByteBufferPool());
    }

    public WebSocketServerFactory(WebSocketPolicy policy) {
        this(policy, new MappedByteBufferPool());
    }

    public WebSocketServerFactory(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.handshakes.put(13, new HandshakeRFC6455());
        this.scheduler = new ScheduledExecutorScheduler();
        this.sessions = new ConcurrentLinkedQueue<WebSocketSession>();
        this.openSessions = new CopyOnWriteArraySet<WebSocketSession>();
        this.addBean(this.scheduler);
        this.addBean(bufferPool);
        this.registeredSocketClasses = new ArrayList();
        this.defaultPolicy = policy;
        this.eventDriverFactory = new EventDriverFactory(this.defaultPolicy);
        this.extensionFactory = new WebSocketExtensionFactory(this.defaultPolicy, bufferPool);
        this.sessionFactories = new ArrayList<SessionFactory>();
        this.sessionFactories.add(new WebSocketSessionFactory(this));
        this.creator = this;
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (int v : this.handshakes.keySet()) {
            versions.add(v);
        }
        Collections.sort(versions, Collections.reverseOrder());
        StringBuilder rv = new StringBuilder();
        Iterator i$ = versions.iterator();
        while (i$.hasNext()) {
            int v = (Integer)i$.next();
            if (rv.length() > 0) {
                rv.append(", ");
            }
            rv.append(v);
        }
        this.supportedVersions = rv.toString();
    }

    @Override
    public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.acceptWebSocket(this.getCreator(), request, response);
    }

    @Override
    public boolean acceptWebSocket(WebSocketCreator creator, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            ServletUpgradeRequest sockreq = new ServletUpgradeRequest(request);
            ServletUpgradeResponse sockresp = new ServletUpgradeResponse(response);
            UpgradeContext context = WebSocketServerFactory.getActiveUpgradeContext();
            if (context == null) {
                context = new UpgradeContext();
                WebSocketServerFactory.setActiveUpgradeContext(context);
            }
            context.setRequest(sockreq);
            context.setResponse(sockresp);
            Object websocketPojo = creator.createWebSocket(sockreq, sockresp);
            if (sockresp.isCommitted()) {
                return false;
            }
            if (websocketPojo == null) {
                response.sendError(503);
                return false;
            }
            EventDriver driver = this.eventDriverFactory.wrap(websocketPojo);
            return this.upgrade(sockreq, sockresp, driver);
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to accept websocket due to mangled URI", e);
        }
    }

    public void addSessionFactory(SessionFactory sessionFactory) {
        if (this.sessionFactories.contains(sessionFactory)) {
            return;
        }
        this.sessionFactories.add(sessionFactory);
    }

    @Override
    public void cleanup() {
        try {
            this.stop();
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    protected void closeAllConnections() {
        for (WebSocketSession session : this.sessions) {
            session.close();
        }
        this.sessions.clear();
    }

    @Override
    public WebSocketServletFactory createFactory(WebSocketPolicy policy) {
        return new WebSocketServerFactory(policy);
    }

    private WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        if (websocket == null) {
            throw new InvalidWebSocketException("Unable to create Session from null websocket");
        }
        for (SessionFactory impl : this.sessionFactories) {
            if (!impl.supports(websocket)) continue;
            try {
                return impl.createSession(requestURI, websocket, connection);
            }
            catch (Throwable e) {
                throw new InvalidWebSocketException("Unable to create Session", e);
            }
        }
        throw new InvalidWebSocketException("Unable to create Session: unrecognized internal EventDriver type: " + websocket.getClass().getName());
    }

    @Override
    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        if (this.registeredSocketClasses.size() < 1) {
            throw new WebSocketException("No WebSockets have been registered with the factory.  Cannot use default implementation of WebSocketCreator.");
        }
        if (this.registeredSocketClasses.size() > 1) {
            LOG.warn("You have registered more than 1 websocket object, and are using the default WebSocketCreator! Using first registered websocket.", new Object[0]);
        }
        Class<?> firstClass = this.registeredSocketClasses.get(0);
        try {
            return firstClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WebSocketException("Unable to create instance of " + firstClass, e);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.closeAllConnections();
        super.doStop();
    }

    @Override
    public WebSocketCreator getCreator() {
        return this.creator;
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    @Override
    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public Set<WebSocketSession> getOpenSessions() {
        return Collections.unmodifiableSet(this.openSessions);
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.defaultPolicy;
    }

    @Override
    public void init() throws Exception {
        this.start();
    }

    @Override
    public boolean isUpgradeRequest(HttpServletRequest request, HttpServletResponse response) {
        if (!"GET".equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String connection = request.getHeader("connection");
        if (connection == null) {
            return false;
        }
        boolean foundUpgradeToken = false;
        Iterator<String> iter = QuoteUtil.splitAt(connection, ",");
        while (iter.hasNext()) {
            String token = iter.next();
            if (!"upgrade".equalsIgnoreCase(token)) continue;
            foundUpgradeToken = true;
            break;
        }
        if (!foundUpgradeToken) {
            return false;
        }
        String upgrade = request.getHeader("Upgrade");
        if (upgrade == null) {
            return false;
        }
        if (!"websocket".equalsIgnoreCase(upgrade)) {
            LOG.debug("Not a 'Upgrade: WebSocket' (was [Upgrade: " + upgrade + "])", new Object[0]);
            return false;
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            LOG.debug("Not a 'HTTP/1.1' request (was [" + request.getProtocol() + "])", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        this.openSessions.remove(session);
    }

    @Override
    public void onSessionOpened(WebSocketSession session) {
        this.openSessions.add(session);
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    @Override
    public void register(Class<?> websocketPojo) {
        this.registeredSocketClasses.add(websocketPojo);
    }

    public boolean sessionClosed(WebSocketSession session) {
        return this.isRunning() && this.sessions.remove(session);
    }

    public boolean sessionOpened(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Opened: {}", session);
        }
        if (!this.isRunning()) {
            LOG.warn("Factory is not running", new Object[0]);
            return false;
        }
        boolean ret = this.sessions.offer(session);
        session.open();
        return ret;
    }

    @Override
    public void setCreator(WebSocketCreator creator) {
        this.creator = creator;
    }

    public boolean upgrade(ServletUpgradeRequest request, ServletUpgradeResponse response, EventDriver driver) throws IOException {
        WebSocketHandshake handshaker;
        if (!"websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("Not a 'WebSocket: Upgrade' request");
        }
        if (!"HTTP/1.1".equals(request.getHttpVersion())) {
            throw new IllegalStateException("Not a 'HTTP/1.1' request");
        }
        int version = request.getHeaderInt("Sec-WebSocket-Version");
        if (version < 0) {
            version = request.getHeaderInt("Sec-WebSocket-Draft");
        }
        if ((handshaker = this.handshakes.get(version)) == null) {
            StringBuilder warn = new StringBuilder();
            warn.append("Client ").append(request.getRemoteAddress());
            warn.append(" (:").append(request.getRemotePort());
            warn.append(") User Agent: ");
            String ua = request.getHeader("User-Agent");
            if (ua == null) {
                warn.append("[unset] ");
            } else {
                warn.append('\"').append(ua.replaceAll("<", "&lt;")).append("\" ");
            }
            warn.append("requested WebSocket version [").append(version);
            warn.append("], Jetty supports version");
            if (this.handshakes.size() > 1) {
                warn.append('s');
            }
            warn.append(": [").append(this.supportedVersions).append("]");
            LOG.warn(warn.toString(), new Object[0]);
            response.setHeader("Sec-WebSocket-Version", this.supportedVersions);
            response.sendError(400, "Unsupported websocket version specification");
            return false;
        }
        ExtensionStack extensionStack = new ExtensionStack(this.getExtensionFactory());
        if (response.isExtensionsNegotiated()) {
            extensionStack.negotiate(response.getExtensions());
        } else {
            extensionStack.negotiate(request.getExtensions());
        }
        UpgradeContext context = WebSocketServerFactory.getActiveUpgradeContext();
        LogicalConnection connection = context.getConnection();
        if (connection == null) {
            HttpConnection http = HttpConnection.getCurrentConnection();
            EndPoint endp = http.getEndPoint();
            Executor executor = http.getConnector().getExecutor();
            ByteBufferPool bufferPool = http.getConnector().getByteBufferPool();
            WebSocketServerConnection wsConnection = new WebSocketServerConnection(endp, executor, this.scheduler, driver.getPolicy(), bufferPool, this);
            connection = wsConnection;
            extensionStack.setPolicy(driver.getPolicy());
            extensionStack.configure(wsConnection.getParser());
            extensionStack.configure(wsConnection.getGenerator());
            LOG.debug("HttpConnection: {}", http);
            LOG.debug("AsyncWebSocketConnection: {}", connection);
        }
        WebSocketSession session = this.createSession(request.getRequestURI(), driver, connection);
        session.setPolicy(driver.getPolicy());
        session.setUpgradeRequest(request);
        response.setExtensions(extensionStack.getNegotiatedExtensions());
        session.setUpgradeResponse(response);
        connection.setSession(session);
        connection.setNextIncomingFrames(extensionStack);
        extensionStack.setNextIncoming(session);
        session.setOutgoingHandler(extensionStack);
        extensionStack.setNextOutgoing(connection);
        try {
            session.start();
        }
        catch (Exception e) {
            throw new IOException("Unable to start Session", e);
        }
        try {
            extensionStack.start();
        }
        catch (Exception e) {
            throw new IOException("Unable to start Extension Stack", e);
        }
        request.setServletAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", connection);
        LOG.debug("Handshake Response: {}", handshaker);
        handshaker.doHandshakeResponse(request, response);
        LOG.debug("Websocket upgrade {} {} {} {}", request.getRequestURI(), version, response.getAcceptedSubProtocol(), connection);
        return true;
    }
}

