/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jetty.maven.plugin.AbstractUnassembledWebAppMojo;
import org.eclipse.jetty.maven.plugin.JettyDistroForker;
import org.eclipse.jetty.maven.plugin.JettyEmbedder;
import org.eclipse.jetty.maven.plugin.JettyForker;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.VALIDATE)
public class JettyStartMojo
extends AbstractUnassembledWebAppMojo {
    @Override
    public void startJettyEmbedded() throws MojoExecutionException {
        try {
            JettyEmbedder jetty = this.newJettyEmbedder();
            jetty.setExitVm(false);
            jetty.setStopAtShutdown(false);
            jetty.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    @Override
    public void startJettyForked() throws MojoExecutionException {
        try {
            JettyForker jetty = this.newJettyForker();
            jetty.setWaitForChild(false);
            jetty.setMaxChildStartChecks(this.maxChildStartChecks);
            jetty.setMaxChildStartCheckMs(this.maxChildStartCheckMs);
            jetty.setJettyOutputFile(this.getJettyOutputFile("jetty-start.out"));
            jetty.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    @Override
    public void startJettyDistro() throws MojoExecutionException {
        try {
            JettyDistroForker jetty = this.newJettyDistroForker();
            jetty.setWaitForChild(false);
            jetty.setMaxChildStartChecks(this.maxChildStartChecks);
            jetty.setMaxChildStartCheckMs(this.maxChildStartCheckMs);
            jetty.setJettyOutputFile(this.getJettyOutputFile("jetty-start.out"));
            jetty.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }
}

