/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.Map;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class InternalBuilder {
    static BuildManager buildManager;
    private ICommand command;
    private boolean forgetStateRequested = false;
    private IProject[] interestingProjects = ICoreConstants.EMPTY_PROJECT_ARRAY;
    private String label;
    private String natureId;
    private ElementTree oldState;
    private String pluginId;
    private IProject project;
    private boolean callOnEmptyDelta = false;

    protected abstract IProject[] build(int var1, Map var2, IProgressMonitor var3) throws CoreException;

    final boolean callOnEmptyDelta() {
        return this.callOnEmptyDelta;
    }

    protected abstract void clean(IProgressMonitor var1) throws CoreException;

    final void clearForgetLastBuiltState() {
        this.forgetStateRequested = false;
    }

    protected void forgetLastBuiltState() {
        this.oldState = null;
        this.forgetStateRequested = true;
    }

    protected ICommand getCommand() {
        return (ICommand)((BuildCommand)this.command).clone();
    }

    protected IResourceDelta getDelta(IProject aProject) {
        return buildManager.getDelta(aProject);
    }

    final IProject[] getInterestingProjects() {
        return this.interestingProjects;
    }

    final String getLabel() {
        return this.label;
    }

    final ElementTree getLastBuiltTree() {
        return this.oldState;
    }

    final String getNatureId() {
        return this.natureId;
    }

    final String getPluginId() {
        return this.pluginId;
    }

    protected IProject getProject() {
        return this.project;
    }

    protected boolean hasBeenBuilt(IProject aProject) {
        return buildManager.hasBeenBuilt(aProject);
    }

    public boolean isInterrupted() {
        return InternalBuilder.buildManager.autoBuildJob.isInterrupted();
    }

    protected void needRebuild() {
        buildManager.requestRebuild();
    }

    final void setCallOnEmptyDelta(boolean value) {
        this.callOnEmptyDelta = value;
    }

    final void setCommand(ICommand value) {
        this.command = value;
    }

    final void setInterestingProjects(IProject[] value) {
        this.interestingProjects = value;
    }

    final void setLabel(String value) {
        this.label = value;
    }

    final void setLastBuiltTree(ElementTree value) {
        this.oldState = value;
    }

    final void setNatureId(String id) {
        this.natureId = id;
    }

    final void setPluginId(String value) {
        this.pluginId = value;
    }

    final void setProject(IProject value) {
        Assert.isTrue((this.project == null ? 1 : 0) != 0);
        this.project = value;
    }

    protected abstract void startupOnInitialize();

    final boolean wasForgetStateRequested() {
        return this.forgetStateRequested;
    }
}

