/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableCharSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableCharSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

class ImmutableCharCharMapKeySet
extends AbstractImmutableCharSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private final char[] keysValues;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableCharCharMapKeySet(char[] keysValues, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keysValues = keysValues;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !ImmutableCharCharMapKeySet.isEmptyKey(key) && !ImmutableCharCharMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += 0;
        }
        if (this.containsOneKey) {
            ++result;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result += this.keysValues[i];
            }
        }
        return result;
    }

    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf('\u0000'));
                ++count;
            }
            if (this.containsOneKey) {
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf('\u0001'));
            }
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(this.keysValues[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    public char[] toArray() {
        char[] array = new char[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = '\u0000';
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = '\u0001';
            ++index;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                array[index] = this.keysValues[i];
                ++index;
            }
        }
        return array;
    }

    public char[] toArray(char[] array) {
        if (array.length < this.size()) {
            array = new char[this.size()];
        }
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = '\u0000';
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = '\u0001';
            ++index;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                array[index] = this.keysValues[i];
                ++index;
            }
        }
        return array;
    }

    public boolean contains(char value) {
        if (value == '\u0000') {
            return this.containsZeroKey;
        }
        if (value == '\u0001') {
            return this.containsOneKey;
        }
        return this.keysValues[this.probe(value)] == value;
    }

    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value('\u0000');
        }
        if (this.containsOneKey) {
            procedure.value('\u0001');
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                procedure.value(this.keysValues[i]);
            }
        }
    }

    public ImmutableCharSet select(CharPredicate predicate) {
        CharHashSet result = new CharHashSet();
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            result.add('\u0000');
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            result.add('\u0001');
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    public ImmutableCharSet reject(CharPredicate predicate) {
        CharHashSet result = new CharHashSet();
        if (this.containsZeroKey && !predicate.accept('\u0000')) {
            result.add('\u0000');
        }
        if (this.containsOneKey && !predicate.accept('\u0001')) {
            result.add('\u0001');
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    public <V> ImmutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf('\u0000'));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf('\u0001'));
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                target.add(function.valueOf(this.keysValues[i]));
            }
        }
        return target.toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            return '\u0000';
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            return '\u0001';
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return this.keysValues[i];
        }
        return ifNone;
    }

    public int count(CharPredicate predicate) {
        int count = 0;
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            ++count;
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            ++count;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            return true;
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            return true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        if (this.containsZeroKey && !predicate.accept('\u0000')) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept('\u0001')) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            return false;
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    public long sum() {
        long nextSum;
        long adjustedValue;
        long result = 0L;
        long compensation = 0L;
        if (this.containsZeroKey) {
            adjustedValue = 0L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.containsOneKey) {
            adjustedValue = 1L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                long adjustedValue2 = (long)this.keysValues[i] - compensation;
                long nextSum2 = result + adjustedValue2;
                compensation = nextSum2 - result - adjustedValue2;
                result = nextSum2;
            }
        }
        return result;
    }

    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        char max = '\u0000';
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max = '\u0000';
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || max < '\u0001')) {
            max = '\u0001';
            isMaxSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i]) || isMaxSet && max >= this.keysValues[i]) continue;
            max = this.keysValues[i];
            isMaxSet = true;
        }
        return max;
    }

    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        char min = '\u0000';
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min = '\u0000';
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || '\u0001' < min)) {
            min = '\u0001';
            isMinSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i]) || isMinSet && this.keysValues[i] >= min) continue;
            min = this.keysValues[i];
            isMinSet = true;
        }
        return min;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, '\u0000');
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, '\u0001');
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableCharCharMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result = function.valueOf(result, this.keysValues[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableCharSetSerializationProxy(this);
    }

    int probe(char element) {
        int index = this.mask(element) << 1;
        char keyAtIndex = this.keysValues[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        for (int i = 2; i < 16; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(char element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 16; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            char keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(char element, int removedIndex) {
        int nextIndex = SpreadFunctions.charSpreadOne(element) << 1;
        int spreadTwo = Integer.reverse(SpreadFunctions.charSpreadTwo(element)) | 1;
        char keyAtIndex;
        while ((keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1]) != element) {
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(char element) {
        int code = SpreadFunctions.charSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(char element) {
        int code = SpreadFunctions.charSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    private class InternalCharIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return this.count < ImmutableCharCharMapKeySet.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableCharCharMapKeySet.this.containsZeroKey) {
                    return '\u0000';
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableCharCharMapKeySet.this.containsOneKey) {
                    return '\u0001';
                }
            }
            char[] keysValues = ImmutableCharCharMapKeySet.this.keysValues;
            while (!ImmutableCharCharMapKeySet.isNonSentinel(keysValues[this.position])) {
                this.position += 2;
            }
            char result = ImmutableCharCharMapKeySet.this.keysValues[this.position];
            this.position += 2;
            return result;
        }
    }
}

