/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.MutableByteValuesMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedByteCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.primitive.AbstractByteIterable;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

public abstract class AbstractMutableByteValuesMap
extends AbstractByteIterable
implements MutableByteValuesMap {
    protected abstract int getOccupiedWithData();

    protected abstract SentinelValues getSentinelValues();

    protected abstract void setSentinelValuesNull();

    protected abstract byte getEmptyValue();

    protected abstract byte getValueAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract boolean isNonSentinelAtIndex(int var1);

    protected void addEmptyKeyValue(byte value) {
        this.getSentinelValues().containsZeroKey = true;
        this.getSentinelValues().zeroValue = value;
    }

    protected void removeEmptyKey() {
        if (this.getSentinelValues().containsOneKey) {
            this.getSentinelValues().containsZeroKey = false;
            this.getSentinelValues().zeroValue = this.getEmptyValue();
        } else {
            this.setSentinelValuesNull();
        }
    }

    protected void addRemovedKeyValue(byte value) {
        this.getSentinelValues().containsOneKey = true;
        this.getSentinelValues().oneValue = value;
    }

    protected void removeRemovedKey() {
        if (this.getSentinelValues().containsZeroKey) {
            this.getSentinelValues().containsOneKey = false;
            this.getSentinelValues().oneValue = this.getEmptyValue();
        } else {
            this.setSentinelValuesNull();
        }
    }

    public boolean contains(byte value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return source.allSatisfy((BytePredicate & Serializable)value -> this.contains(value));
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        MutableByteIterator iterator = this.byteIterator();
        byte max = iterator.next();
        while (iterator.hasNext()) {
            byte value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        MutableByteIterator iterator = this.byteIterator();
        byte min = iterator.next();
        while (iterator.hasNext()) {
            byte value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public int size() {
        return this.getOccupiedWithData() + (this.getSentinelValues() == null ? 0 : this.getSentinelValues().size());
    }

    public boolean isEmpty() {
        return this.getOccupiedWithData() == 0 && (this.getSentinelValues() == null || this.getSentinelValues().size() == 0);
    }

    public boolean notEmpty() {
        return this.getOccupiedWithData() != 0 || this.getSentinelValues() != null && this.getSentinelValues().size() != 0;
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(this.getSentinelValues().zeroValue));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.getSentinelValues().oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!this.isNonSentinelAtIndex(i)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getValueAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        int index = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                array[index] = this.getSentinelValues().zeroValue;
                ++index;
            }
            if (this.getSentinelValues().containsOneKey) {
                array[index] = this.getSentinelValues().oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            array[index] = this.getValueAtIndex(i);
            ++index;
        }
        return array;
    }

    public byte[] toArray(byte[] target) {
        if (target.length < this.size()) {
            target = new byte[this.size()];
        }
        int index = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                target[index] = this.getSentinelValues().zeroValue;
                ++index;
            }
            if (this.getSentinelValues().containsOneKey) {
                target[index] = this.getSentinelValues().oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            target[index] = this.getValueAtIndex(i);
            ++index;
        }
        return target;
    }

    public MutableByteBag select(BytePredicate predicate) {
        return (MutableByteBag)this.select(predicate, (MutableByteCollection)new ByteHashBag());
    }

    public MutableByteBag reject(BytePredicate predicate) {
        return (MutableByteBag)this.reject(predicate, (MutableByteCollection)new ByteHashBag());
    }

    public <V> MutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return (MutableBag)this.collect(function, HashBag.newBag(this.size()));
    }

    public byte detectIfNone(BytePredicate predicate, byte value) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                return this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                return this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            return this.getValueAtIndex(i);
        }
        return value;
    }

    public int count(BytePredicate predicate) {
        int count = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                ++count;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(this.getSentinelValues().zeroValue)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(this.getSentinelValues().oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || predicate.accept(this.getValueAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)ByteBags.mutable.withAll((ByteIterable)this));
            } else {
                MutableByteIterator iterator = this.byteIterator();
                while (iterator.hasNext()) {
                    MutableByteBag batch = ByteBags.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch);
                }
            }
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += (long)this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey) {
                result += (long)this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            result += (long)this.getValueAtIndex(i);
        }
        return result;
    }

    public boolean containsValue(byte value) {
        if (this.getSentinelValues() != null && this.getSentinelValues().containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || this.getValueAtIndex(i) != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(ByteProcedure procedure) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            procedure.value(this.getValueAtIndex(i));
        }
    }

    protected abstract class AbstractByteValuesCollection
    implements MutableByteCollection {
        protected AbstractByteValuesCollection() {
        }

        public void clear() {
            AbstractMutableByteValuesMap.this.clear();
        }

        public MutableByteCollection select(BytePredicate predicate) {
            return AbstractMutableByteValuesMap.this.select(predicate);
        }

        public MutableByteCollection reject(BytePredicate predicate) {
            return AbstractMutableByteValuesMap.this.reject(predicate);
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            return AbstractMutableByteValuesMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
            return AbstractMutableByteValuesMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            return (T)AbstractMutableByteValuesMap.this.injectInto(injectedValue, function);
        }

        public RichIterable<ByteIterable> chunk(int size) {
            return AbstractMutableByteValuesMap.this.chunk(size);
        }

        public long sum() {
            return AbstractMutableByteValuesMap.this.sum();
        }

        public byte max() {
            return AbstractMutableByteValuesMap.this.max();
        }

        public byte maxIfEmpty(byte defaultValue) {
            return AbstractMutableByteValuesMap.this.maxIfEmpty(defaultValue);
        }

        public byte min() {
            return AbstractMutableByteValuesMap.this.min();
        }

        public byte minIfEmpty(byte defaultValue) {
            return AbstractMutableByteValuesMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return AbstractMutableByteValuesMap.this.average();
        }

        public double median() {
            return AbstractMutableByteValuesMap.this.median();
        }

        public byte[] toSortedArray() {
            return AbstractMutableByteValuesMap.this.toSortedArray();
        }

        public MutableByteList toSortedList() {
            return AbstractMutableByteValuesMap.this.toSortedList();
        }

        public MutableByteCollection with(byte element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableByteCollection without(byte element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableByteCollection withAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableByteCollection withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableByteCollection asUnmodifiable() {
            return UnmodifiableByteCollection.of(this);
        }

        public MutableByteCollection asSynchronized() {
            return SynchronizedByteCollection.of(this);
        }

        public ImmutableByteCollection toImmutable() {
            return ByteLists.immutable.withAll((ByteIterable)this);
        }

        public boolean contains(byte value) {
            return AbstractMutableByteValuesMap.this.containsValue(value);
        }

        public boolean containsAll(byte ... source) {
            return AbstractMutableByteValuesMap.this.containsAll(source);
        }

        public boolean containsAll(ByteIterable source) {
            return AbstractMutableByteValuesMap.this.containsAll(source);
        }

        public MutableByteList toList() {
            return AbstractMutableByteValuesMap.this.toList();
        }

        public MutableByteSet toSet() {
            return AbstractMutableByteValuesMap.this.toSet();
        }

        public MutableByteBag toBag() {
            return AbstractMutableByteValuesMap.this.toBag();
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public boolean isEmpty() {
            return AbstractMutableByteValuesMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return AbstractMutableByteValuesMap.this.notEmpty();
        }

        public String makeString() {
            return AbstractMutableByteValuesMap.this.makeString();
        }

        public String makeString(String separator) {
            return AbstractMutableByteValuesMap.this.makeString(separator);
        }

        public String makeString(String start, String separator, String end) {
            return AbstractMutableByteValuesMap.this.makeString(start, separator, end);
        }

        public void appendString(Appendable appendable) {
            AbstractMutableByteValuesMap.this.appendString(appendable);
        }

        public void appendString(Appendable appendable, String separator) {
            AbstractMutableByteValuesMap.this.appendString(appendable, separator);
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            AbstractMutableByteValuesMap.this.appendString(appendable, start, separator, end);
        }

        public void forEach(ByteProcedure procedure) {
            this.each(procedure);
        }

        public void each(ByteProcedure procedure) {
            AbstractMutableByteValuesMap.this.each(procedure);
        }

        public int count(BytePredicate predicate) {
            return AbstractMutableByteValuesMap.this.count(predicate);
        }

        public boolean anySatisfy(BytePredicate predicate) {
            return AbstractMutableByteValuesMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(BytePredicate predicate) {
            return AbstractMutableByteValuesMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            return AbstractMutableByteValuesMap.this.noneSatisfy(predicate);
        }

        public boolean add(byte element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean removeAll(ByteIterable source) {
            int oldSize = AbstractMutableByteValuesMap.this.size();
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != AbstractMutableByteValuesMap.this.size();
        }

        public boolean removeAll(byte ... source) {
            int oldSize = AbstractMutableByteValuesMap.this.size();
            for (byte item : source) {
                this.remove(item);
            }
            return oldSize != AbstractMutableByteValuesMap.this.size();
        }

        public boolean retainAll(byte ... source) {
            return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
        }

        public int size() {
            return AbstractMutableByteValuesMap.this.size();
        }

        public byte[] toArray() {
            return AbstractMutableByteValuesMap.this.toArray();
        }

        public byte[] toArray(byte[] target) {
            return AbstractMutableByteValuesMap.this.toArray(target);
        }
    }

    protected static class SentinelValues
    extends AbstractSentinelValues {
        protected byte zeroValue;
        protected byte oneValue;

        protected SentinelValues() {
        }

        public boolean containsValue(byte value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }

        public SentinelValues copy() {
            SentinelValues sentinelValues = new SentinelValues();
            sentinelValues.zeroValue = this.zeroValue;
            sentinelValues.oneValue = this.oneValue;
            sentinelValues.containsOneKey = this.containsOneKey;
            sentinelValues.containsZeroKey = this.containsZeroKey;
            return sentinelValues;
        }
    }
}

