/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.CellContentHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.FlattenedTableRowHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;

public class FlattenedTableHandler
extends AbstractHandler {
    private CellContentHandler contentHandler;

    public FlattenedTableHandler(CellContentHandler contentHandler, Logger log, IHandler parent, ITableContent table) {
        super(log, parent, table);
        this.contentHandler = contentHandler;
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        String password;
        String name;
        if ((state.sheetName == null || state.sheetName.isEmpty()) && (name = table.getName()) != null && !name.isEmpty()) {
            state.sheetName = name;
        }
        if ((state.sheetPassword == null || state.sheetPassword.isEmpty()) && (password = EmitterServices.stringOption((ITaskOption)state.getRenderOptions(), table, "ExcelEmitter.SheetProtectPassword", null)) != null && !password.isEmpty()) {
            state.sheetPassword = password;
        }
    }

    @Override
    public void endTable(HandlerState state, ITableContent table) throws BirtException {
        state.setHandler(this.parent);
    }

    @Override
    public void startRow(HandlerState state, IRowContent row) throws BirtException {
        state.setHandler(new FlattenedTableRowHandler(this.contentHandler, this.log, this, row));
        state.getHandler().startRow(state, row);
    }

    @Override
    public void startTableBand(HandlerState state, ITableBandContent band) throws BirtException {
    }

    @Override
    public void endTableBand(HandlerState state, ITableBandContent band) throws BirtException {
    }

    @Override
    public void startTableGroup(HandlerState state, ITableGroupContent group) throws BirtException {
    }

    @Override
    public void endTableGroup(HandlerState state, ITableGroupContent group) throws BirtException {
    }
}

