/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;

public class TableContent
extends AbstractContent
implements ITableContent {
    protected List columns = new ArrayList();
    protected String caption;
    protected String captionKey;
    protected String summary;
    protected Boolean headerRepeat;
    protected static final short FIELD_COLUMNS = 1000;
    protected static final short FIELD_CAPTION = 1001;
    protected static final short FIELD_CAPTIONKEY = 1002;
    protected static final short FIELD_HEADERREPEAT = 1003;
    protected static final short FIELD_SUMMARY = 1004;

    TableContent(ITableContent table) {
        super(table);
        this.caption = table.getCaption();
        this.captionKey = table.getCaptionKey();
        this.headerRepeat = table.isHeaderRepeat();
        this.columns = table.getColumns();
        this.summary = table.getSummary();
    }

    @Override
    public int getContentType() {
        return 10;
    }

    @Override
    public void setHeaderRepeat(boolean headerRepeat) {
        boolean repeatHeader;
        if (this.generateBy instanceof TableItemDesign && (repeatHeader = ((TableItemDesign)this.generateBy).isRepeatHeader()) == headerRepeat) {
            this.headerRepeat = null;
            return;
        }
        this.headerRepeat = headerRepeat;
    }

    @Override
    public boolean isHeaderRepeat() {
        if (this.headerRepeat != null) {
            return this.headerRepeat;
        }
        if (this.generateBy instanceof TableItemDesign) {
            return ((TableItemDesign)this.generateBy).isRepeatHeader();
        }
        return false;
    }

    TableContent(IReportContent report) {
        super(report);
    }

    @Override
    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitTable(this, value);
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            if (this.generateBy instanceof TableItemDesign) {
                return ((TableItemDesign)this.generateBy).getCaption();
            }
            if (this.generateBy instanceof GridItemDesign) {
                return ((GridItemDesign)this.generateBy).getCaption();
            }
        }
        return this.caption;
    }

    @Override
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Override
    public void setCaptionKey(String key) {
        this.captionKey = key;
    }

    @Override
    public String getCaptionKey() {
        if (this.captionKey == null) {
            if (this.generateBy instanceof TableItemDesign) {
                return ((TableItemDesign)this.generateBy).getCaptionKey();
            }
            if (this.generateBy instanceof GridItemDesign) {
                return ((GridItemDesign)this.generateBy).getCaptionKey();
            }
        }
        return this.captionKey;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public IColumn getColumn(int index) {
        return (IColumn)this.columns.get(index);
    }

    @Override
    public void addColumn(IColumn column) {
        this.columns.add(column);
    }

    @Override
    public ITableBandContent getHeader() {
        return this.getTableBand(1);
    }

    @Override
    public ITableBandContent getFooter() {
        return this.getTableBand(2);
    }

    protected ITableBandContent getTableBand(int type) {
        if (this.children == null) {
            return null;
        }
        for (Object child : this.children) {
            ITableBandContent tableBand;
            if (!(child instanceof ITableBandContent) || (tableBand = (ITableBandContent)child).getBandType() != type) continue;
            return tableBand;
        }
        return null;
    }

    @Override
    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.columns != null) {
            IOUtil.writeShort(out, (short)1000);
            IOUtil.writeInt(out, this.columns.size());
            int i = 0;
            while (i < this.columns.size()) {
                Column column = (Column)this.columns.get(i);
                column.writeObject(out);
                ++i;
            }
        }
        if (this.caption != null) {
            IOUtil.writeShort(out, (short)1001);
            IOUtil.writeString(out, this.caption);
        }
        if (this.captionKey != null) {
            IOUtil.writeShort(out, (short)1002);
            IOUtil.writeString(out, this.captionKey);
        }
        if (this.headerRepeat != null) {
            IOUtil.writeShort(out, (short)1003);
            IOUtil.writeBool(out, this.headerRepeat);
        }
        if (this.summary != null) {
            IOUtil.writeShort(out, (short)1004);
            IOUtil.writeString(out, this.summary);
        }
    }

    @Override
    public boolean needSave() {
        return true;
    }

    @Override
    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 1000: {
                int columnsSize = IOUtil.readInt(in);
                int i = 0;
                while (i < columnsSize) {
                    Column column = new Column(this.report);
                    column.readObject(in, loader);
                    this.addColumn(column);
                    ++i;
                }
                break;
            }
            case 1001: {
                this.caption = IOUtil.readString(in);
                break;
            }
            case 1002: {
                this.captionKey = IOUtil.readString(in);
                break;
            }
            case 1004: {
                this.summary = IOUtil.readString(in);
                break;
            }
            case 1003: {
                this.headerRepeat = IOUtil.readBool(in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    @Override
    public List getColumns() {
        return this.columns;
    }

    @Override
    protected IContent cloneContent() {
        return new TableContent(this);
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getSummary() {
        if (this.summary == null) {
            if (this.generateBy instanceof TableItemDesign) {
                return ((TableItemDesign)this.generateBy).getSummary();
            }
            if (this.generateBy instanceof GridItemDesign) {
                return ((GridItemDesign)this.generateBy).getSummary();
            }
        }
        return this.summary;
    }
}

