/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;

public class TotalCount
extends AggrFunction {
    @Override
    public String getName() {
        return "COUNT";
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getDataType() {
        return 2;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, true, true, SupportedDataTypes.ANY, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalCount.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalCount.displayName");
    }

    @Override
    public Object getDefaultValue() {
        return 0;
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private int count = 0;
        boolean countByColumn = true;

        private MyAccumulator() {
        }

        @Override
        public void start() {
            super.start();
            this.count = 0;
        }

        @Override
        public void onRow(Object[] args) {
            if (!this.countByColumn || args == null || args.length == 0) {
                if (this.countByColumn) {
                    this.countByColumn = false;
                }
                ++this.count;
            } else if (args.length > 0 && args[0] != null) {
                ++this.count;
            }
        }

        @Override
        public Object getSummaryValue() {
            return this.count;
        }
    }
}

