/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;
import org.eclipse.birt.report.model.util.StructureRefUtil;

public class StructRefPropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(StructRefPropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.structRef";

    public StructRefPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public int getTypeCode() {
        return 19;
    }

    public String getName() {
        return "structRef";
    }

    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String name = StringUtil.trimString((String)value);
            return StructureRefUtil.resolve(module, defn, name);
        }
        if (value instanceof Structure) {
            Structure target = (Structure)value;
            return StructureRefUtil.resolve(module, defn, target);
        }
        logger.log(Level.SEVERE, "The value of the structure property: " + defn.getName() + " is invalid type");
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 15);
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return ReferenceValueUtil.needTheNamespacePrefix((StructRefValue)value, module);
    }

    public void resolve(Module module, PropertyDefn defn, StructRefValue ref) {
        if (ref.isResolved() || module == null) {
            return;
        }
        StructureDefn targetDefn = (StructureDefn)defn.getStructDefn();
        Structure target = null;
        Library targetModule = null;
        if ("libReference".equals(defn.getName())) {
            String namespace = ref.getLibraryNamespace();
            targetModule = module.getLibraryWithNamespace(namespace);
            if (targetModule != null && (target = StructureRefUtil.findStructure(targetModule, targetDefn, ref.getName())) != null) {
                ref.resolve(target);
            }
        } else {
            StructRefValue retValue = StructureRefUtil.resolve(module, defn, ReferenceValueUtil.needTheNamespacePrefix(ref, module));
            target = retValue.getStructure();
            ref.libraryNamespace = retValue.getLibraryNamespace();
            ref.name = retValue.getName();
            if (target != null) {
                ref.resolve(target);
            }
        }
    }
}

