/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.olap;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.TabularHierarchy;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class TabularCube
extends Cube {
    public TabularCube() {
    }

    public TabularCube(String name) {
        super(name);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitTabularCube(this);
    }

    public String getElementName() {
        return "TabularCube";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public TabularCubeHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new TabularCubeHandle(module, this);
        }
        return (TabularCubeHandle)this.handle;
    }

    public void setDefaultMeasureGroup(int index) {
        List<Object> groups = this.getListProperty(this.getRoot(), "measureGroups");
        if (groups == null || groups.isEmpty()) {
            return;
        }
        if (index >= 0 && index < groups.size()) {
            this.setProperty("defaultMeasureGroup", (Object)new ElementRefValue(null, (DesignElement)groups.get(index)));
        }
    }

    public DesignElement findLocalElement(String name, IElementDefn type) {
        if (StringUtil.isBlank(name) || type == null) {
            return null;
        }
        Module root = this.getRoot();
        if (root == null) {
            return null;
        }
        ElementDefn targetDefn = (ElementDefn)type;
        int nameSpaceID = targetDefn.getNameSpaceID();
        NameSpace tmpNS = root.getNameHelper().getNameSpace(nameSpaceID);
        DesignElement tmpSharedElement = tmpNS.getElement(name);
        if (tmpSharedElement instanceof TabularHierarchy) {
            Dimension tmpCubeDim = this.findLocalDimension((Dimension)tmpSharedElement.getContainer());
            if (tmpCubeDim == null) {
                return null;
            }
            return tmpCubeDim.getLocalHierarchy(root, name);
        }
        if (tmpSharedElement instanceof Dimension) {
            return this.findLocalDimension((Dimension)tmpSharedElement);
        }
        return null;
    }

    private Dimension findLocalDimension(Dimension sharedDim) {
        if (sharedDim.getContainer() == this) {
            return sharedDim;
        }
        Dimension tmpCubeDim = null;
        List<BackRef> cubeDims = sharedDim.getClientList();
        int i = 0;
        while (i < cubeDims.size()) {
            BackRef cubeDim = cubeDims.get(i);
            if (cubeDim.getElement().getContainer() == this) {
                tmpCubeDim = (Dimension)cubeDim.getElement();
                break;
            }
            ++i;
        }
        return tmpCubeDim;
    }
}

