/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ITextListener;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;

public class BlockTextRenderListener
implements ITextListener {
    private int textStartPos = -1;
    private int textLength = 0;
    private int readTextLength = 0;
    private boolean listeningStatus = false;
    private int offset = 0;
    private int dimension = 0;
    protected BlockTextArea blockContainer = null;

    public BlockTextRenderListener(BlockTextArea blockContainer, int offset, int dimension) {
        this.blockContainer = blockContainer;
        this.offset = offset;
        this.dimension = dimension;
        this.onNewLineEvent();
    }

    public void onAddEvent(TextArea textArea) {
        if (this.listeningStatus) {
            if (this.textStartPos == -1) {
                this.textStartPos = textArea.offset;
            }
            this.readTextLength += textArea.textLength;
        }
    }

    public void onNewLineEvent() {
        if (this.blockContainer.getCurrentBP() < this.offset || this.blockContainer.getCurrentBP() > this.offset + this.dimension) {
            this.listeningStatus = false;
        } else {
            this.listeningStatus = true;
            this.textLength = this.readTextLength;
        }
    }

    public void onTextEndEvent() {
        if (this.blockContainer.getCurrentBP() < this.offset || this.blockContainer.getCurrentBP() > this.offset + this.dimension) {
            this.listeningStatus = false;
        }
        if (this.listeningStatus) {
            this.textLength = this.readTextLength;
        }
    }

    public String getSplitText() {
        ITextContent textContent = (ITextContent)this.blockContainer.content;
        if (this.textStartPos == -1 || this.textLength == 0) {
            return "";
        }
        String splitText = textContent.getText().substring(this.textStartPos, this.textStartPos + this.textLength);
        return splitText;
    }
}

