/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html.buffer;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutorUtil;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.LayoutUtil;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.buffer.INode;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;

public class DummyPageBuffer
implements IPageBuffer {
    protected HTMLLayoutContext context;
    protected IReportExecutor executor;
    protected boolean isFirstContent = false;
    protected IContent pageContent = null;
    protected IContentEmitter pageEmitter = null;

    public DummyPageBuffer(HTMLLayoutContext context, IReportExecutor executor) {
        this.context = context;
        this.executor = executor;
    }

    public void endContainer(IContent content, boolean finished, IContentEmitter emitter, boolean visible) throws BirtException {
        if (!visible) {
            return;
        }
        if (this.isFirstContent) {
            this.startPageContent(content);
            this.isFirstContent = false;
        }
        if (emitter != null) {
            if (content.getContentType() == 7) {
                ContentEmitterUtil.endContent(this.pageContent, emitter);
                this.pageBreakEvent();
                this.context.getPageHintManager().clearPageHint();
            } else {
                ContentEmitterUtil.endContent(content, emitter);
            }
        }
    }

    protected void pageBreakEvent() {
        long pageNumber = this.context.getPageNumber();
        ILayoutPageHandler pageHandler = this.context.getLayoutEngine().getPageHandler();
        if (pageHandler != null) {
            pageHandler.onPage(pageNumber, this.context);
        }
    }

    public void startContainer(IContent content, boolean isFirst, IContentEmitter emitter, boolean visible) throws BirtException {
        if (!visible) {
            return;
        }
        if (content.getContentType() == 7) {
            this.isFirstContent = true;
            this.pageContent = content;
            this.pageEmitter = emitter;
        } else {
            if (this.isFirstContent) {
                this.startPageContent(content);
                this.isFirstContent = false;
            }
            if (emitter != null) {
                ContentEmitterUtil.startContent(content, emitter);
            }
        }
    }

    public void startContent(IContent content, IContentEmitter emitter, boolean visible) throws BirtException {
        if (!visible) {
            return;
        }
        if (this.isFirstContent) {
            this.startPageContent(content);
            this.isFirstContent = false;
        }
        if (emitter != null) {
            ContentEmitterUtil.startContent(content, emitter);
            ContentEmitterUtil.endContent(content, emitter);
        }
    }

    public boolean isRepeated() {
        return false;
    }

    public void setRepeated(boolean isRepeated) {
    }

    protected void startPageContent(IContent firstContent) throws BirtException {
        String masterPage = null;
        IStyle style = firstContent.getStyle();
        if (style != null) {
            masterPage = style.getMasterPage();
        }
        if (this.pageContent == null || this.pageEmitter == null) {
            return;
        }
        if (masterPage == null || "".equals(masterPage)) {
            ContentEmitterUtil.startContent(this.pageContent, this.pageEmitter);
        } else {
            Object mp = this.pageContent.getGenerateBy();
            if (mp != null && mp instanceof SimpleMasterPageDesign) {
                String mpStr = ((SimpleMasterPageDesign)mp).getName();
                if (masterPage.equals(mpStr)) {
                    ContentEmitterUtil.startContent(this.pageContent, this.pageEmitter);
                } else {
                    IReportContent report = this.pageContent.getReportContent();
                    MasterPageDesign defaultMasterPage = LayoutUtil.getDefaultMasterPage(report);
                    if (defaultMasterPage.getName().equals(masterPage)) {
                        ContentEmitterUtil.startContent(this.pageContent, this.pageEmitter);
                    } else {
                        this.pageContent = ReportExecutorUtil.executeMasterPage(this.executor, this.context.getPageNumber(), LayoutUtil.getMasterPage(report, masterPage));
                        if (this.pageContent != null && this.context.needLayoutPageContent()) {
                            this.context.getPageLM().layoutPageContent((IPageContent)this.pageContent);
                        }
                        if (this.pageContent != null) {
                            ContentEmitterUtil.startContent(this.pageContent, this.pageEmitter);
                        }
                    }
                }
            }
        }
    }

    public void closePage(INode[] nodeList) {
    }

    public boolean finished() {
        return false;
    }

    public void flush() {
    }

    public void openPage(INode[] nodeList) {
    }

    public INode[] getNodeStack() {
        return null;
    }

    public void addTableColumnHint(TableColumnHint hint) {
    }
}

