/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GraphicMasterPageDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.IOConstants;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.PageVariableDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.RuleDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineIRReaderImpl
implements IOConstants {
    protected Report reportDesign;
    protected String scriptLanguage = "javascript";
    protected long version;
    protected boolean checkDesignVersion = false;
    protected DataInputStream dis;

    protected EngineIRReaderImpl(DataInputStream dis, boolean checkDesignVersion) {
        this.checkDesignVersion = checkDesignVersion;
        this.dis = dis;
    }

    public Report read() throws IOException {
        String designVersion = IOUtil.readString(this.dis);
        if (this.checkDesignVersion && !"3.2.23".equals(designVersion)) {
            throw new IOException("un-compatable design version" + designVersion);
        }
        this.reportDesign = new Report();
        if (this.version == 0L || this.version == 1L) {
            IOUtil.readString(this.dis);
            IOUtil.readString(this.dis);
        }
        if (this.version <= 3L) {
            this.readReportV1_3(this.dis);
        } else {
            this.readReport(this.dis);
        }
        return this.reportDesign;
    }

    private void readReportV1_3(DataInputStream dis) throws IOException {
        int styleCount = IOUtil.readInt(dis);
        int i = 0;
        while (i < styleCount) {
            String styleName = IOUtil.readString(dis);
            IStyle style = this.readStyle(dis);
            this.reportDesign.addStyle(styleName, style);
            ++i;
        }
        String rootStyleName = IOUtil.readString(dis);
        this.reportDesign.setRootStyleName(rootStyleName);
        Map<String, Expression> namedExpressions = this.readExprMap(dis);
        if (namedExpressions != null && !namedExpressions.isEmpty()) {
            this.reportDesign.setUserProperties(namedExpressions);
        }
        PageSetupDesign pageSetup = this.reportDesign.getPageSetup();
        int masterPageCount = IOUtil.readInt(dis);
        int i2 = 0;
        while (i2 < masterPageCount) {
            SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)this.readDesign(dis);
            pageSetup.addMasterPage(masterPage);
            ++i2;
        }
        int count = IOUtil.readInt(dis);
        int i3 = 0;
        while (i3 < count) {
            ReportItemDesign item = (ReportItemDesign)this.readDesign(dis);
            this.reportDesign.addContent(item);
            ++i3;
        }
    }

    private void readReport(DataInputStream dis) throws IOException {
        short num = IOUtil.readShort(dis);
        short i = 0;
        while (i < num) {
            short reportSegmentType = IOUtil.readShort(dis);
            switch (reportSegmentType) {
                case 240: {
                    this.readReportSytles(dis);
                    break;
                }
                case 241: 
                case 254: {
                    this.readReportUserProperties(dis);
                    break;
                }
                case 242: {
                    this.readReportPageSetup(dis);
                    break;
                }
                case 243: {
                    this.readReportBodyContent(dis);
                    break;
                }
                case 245: {
                    this.readReportVariable(dis);
                    break;
                }
                case 246: {
                    Expression onPageStart = this.readExpression(dis);
                    this.reportDesign.setOnPageStart(onPageStart);
                    break;
                }
                case 247: {
                    Expression onPageEnd = this.readExpression(dis);
                    this.reportDesign.setOnPageStart(onPageEnd);
                    break;
                }
                case 248: {
                    String version = IOUtil.readString(dis);
                    this.reportDesign.setVersion(version);
                    break;
                }
                case 252: {
                    this.scriptLanguage = IOUtil.readString(dis);
                    break;
                }
                case 255: {
                    String locale = IOUtil.readString(dis);
                    this.reportDesign.setLocale(locale);
                    break;
                }
                default: {
                    throw new IOException("unknow report segment type:" + reportSegmentType);
                }
            }
            i = (short)(i + 1);
        }
    }

    private void readReportSytles(DataInputStream dis) throws IOException {
        int styleCount = IOUtil.readInt(dis);
        int i = 0;
        while (i < styleCount) {
            String styleName = IOUtil.readString(dis);
            IStyle style = this.readStyle(dis);
            this.reportDesign.addStyle(styleName, style);
            ++i;
        }
        String rootStyleName = IOUtil.readString(dis);
        this.reportDesign.setRootStyleName(rootStyleName);
    }

    private void readReportUserProperties(DataInputStream dis) throws IOException {
        Map<String, Expression> userProperties = this.readExprMap(dis);
        if (userProperties != null && !userProperties.isEmpty()) {
            this.reportDesign.setUserProperties(userProperties);
        }
    }

    private void readReportPageSetup(DataInputStream dis) throws IOException {
        PageSetupDesign pageSetup = this.reportDesign.getPageSetup();
        int masterPageCount = IOUtil.readInt(dis);
        int i = 0;
        while (i < masterPageCount) {
            SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)this.readDesign(dis);
            pageSetup.addMasterPage(masterPage);
            ++i;
        }
    }

    private void readReportBodyContent(DataInputStream dis) throws IOException {
        int count = IOUtil.readInt(dis);
        int i = 0;
        while (i < count) {
            ReportItemDesign item = (ReportItemDesign)this.readDesign(dis);
            this.reportDesign.addContent(item);
            ++i;
        }
    }

    private void readReportVariable(DataInputStream dis) throws IOException {
        Collection<PageVariableDesign> vars = this.reportDesign.getPageVariables();
        int varCount = IOUtil.readInt(dis);
        int i = 0;
        while (i < varCount) {
            String varName = IOUtil.readString(dis);
            String varScope = IOUtil.readString(dis);
            Expression expr = this.readExpression(dis);
            PageVariableDesign varDesign = new PageVariableDesign(varName, varScope);
            varDesign.setDefaultValue(expr);
            vars.add(varDesign);
            ++i;
        }
    }

    protected Object readDesign(DataInputStream in) throws IOException {
        short designType = IOUtil.readShort(in);
        byte[] buffer = IOUtil.readBytes(in);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buffer));
        switch (designType) {
            case 2: {
                ReportItemDesign item;
                SimpleMasterPageDesign masterPage = new SimpleMasterPageDesign();
                this.readSimpleMasterPage(dis, masterPage);
                int count = IOUtil.readInt(in);
                int i = 0;
                while (i < count) {
                    item = (ReportItemDesign)this.readDesign(in);
                    masterPage.addHeader(item);
                    ++i;
                }
                count = IOUtil.readInt(in);
                i = 0;
                while (i < count) {
                    item = (ReportItemDesign)this.readDesign(in);
                    masterPage.addFooter(item);
                    ++i;
                }
                return masterPage;
            }
            case 3: {
                GridItemDesign grid = new GridItemDesign();
                this.readGrid(dis, grid);
                int count = IOUtil.readInt(in);
                int i = 0;
                while (i < count) {
                    RowDesign row = (RowDesign)this.readDesign(in);
                    grid.addRow(row);
                    ++i;
                }
                return grid;
            }
            case 4: {
                FreeFormItemDesign freeForm = new FreeFormItemDesign();
                this.readFreeForm(dis, freeForm);
                int count = IOUtil.readInt(in);
                int i = 0;
                while (i < count) {
                    ReportItemDesign item = (ReportItemDesign)this.readDesign(in);
                    freeForm.addItem(item);
                    ++i;
                }
                return freeForm;
            }
            case 6: {
                RowDesign row = new RowDesign();
                this.readRow(dis, row);
                int count = IOUtil.readInt(in);
                int i = 0;
                while (i < count) {
                    CellDesign cell = (CellDesign)this.readDesign(in);
                    row.addCell(cell);
                    ++i;
                }
                return row;
            }
            case 7: {
                CellDesign cell = new CellDesign();
                this.readCell(dis, cell);
                int count = IOUtil.readInt(in);
                int i = 0;
                while (i < count) {
                    ReportItemDesign item = (ReportItemDesign)this.readDesign(in);
                    cell.addContent(item);
                    ++i;
                }
                return cell;
            }
            case 8: {
                ListItemDesign list = new ListItemDesign();
                this.readList(dis, list);
                if (IOUtil.readBool(in)) {
                    ListBandDesign header = (ListBandDesign)this.readDesign(in);
                    list.setHeader(header);
                }
                int count = IOUtil.readInt(in);
                int i = 0;
                while (i < count) {
                    ListGroupDesign group = (ListGroupDesign)this.readDesign(in);
                    list.addGroup(group);
                    ++i;
                }
                if (IOUtil.readBool(in)) {
                    ListBandDesign detail = (ListBandDesign)this.readDesign(in);
                    list.setDetail(detail);
                }
                if (IOUtil.readBool(in)) {
                    ListBandDesign footer = (ListBandDesign)this.readDesign(in);
                    list.setFooter(footer);
                }
                return list;
            }
            case 9: {
                ListGroupDesign listGroup = new ListGroupDesign();
                this.readListGroup(dis, listGroup);
                if (IOUtil.readBool(in)) {
                    ListBandDesign groupHeader = (ListBandDesign)this.readDesign(in);
                    listGroup.setHeader(groupHeader);
                }
                if (IOUtil.readBool(in)) {
                    ListBandDesign footer = (ListBandDesign)this.readDesign(in);
                    listGroup.setFooter(footer);
                }
                return listGroup;
            }
            case 10: {
                ListBandDesign listBand = new ListBandDesign();
                this.readListBand(dis, listBand);
                int count = IOUtil.readInt(in);
                int i = 0;
                while (i < count) {
                    ReportItemDesign item = (ReportItemDesign)this.readDesign(in);
                    listBand.addContent(item);
                    ++i;
                }
                return listBand;
            }
            case 11: {
                TableItemDesign table = new TableItemDesign();
                this.readTable(dis, table);
                if (IOUtil.readBool(in)) {
                    TableBandDesign header = (TableBandDesign)this.readDesign(in);
                    table.setHeader(header);
                }
                int count = IOUtil.readInt(in);
                int i = 0;
                while (i < count) {
                    TableGroupDesign group = (TableGroupDesign)this.readDesign(in);
                    table.addGroup(group);
                    ++i;
                }
                if (IOUtil.readBool(in)) {
                    TableBandDesign detail = (TableBandDesign)this.readDesign(in);
                    table.setDetail(detail);
                }
                if (IOUtil.readBool(in)) {
                    TableBandDesign footer = (TableBandDesign)this.readDesign(in);
                    table.setFooter(footer);
                }
                return table;
            }
            case 12: {
                TableGroupDesign tableGroup = new TableGroupDesign();
                this.readTableGroup(dis, tableGroup);
                if (IOUtil.readBool(in)) {
                    TableBandDesign groupHeader = (TableBandDesign)this.readDesign(in);
                    tableGroup.setHeader(groupHeader);
                }
                if (IOUtil.readBool(in)) {
                    TableBandDesign footer = (TableBandDesign)this.readDesign(in);
                    tableGroup.setFooter(footer);
                }
                return tableGroup;
            }
            case 13: {
                TableBandDesign band = new TableBandDesign();
                this.readTableBand(dis, band);
                int count = IOUtil.readInt(in);
                int i = 0;
                while (i < count) {
                    RowDesign row = (RowDesign)this.readDesign(in);
                    band.addContent(row);
                    ++i;
                }
                return band;
            }
            case 14: {
                LabelItemDesign design = new LabelItemDesign();
                this.readLabel(dis, design);
                return design;
            }
            case 15: {
                TextItemDesign design = new TextItemDesign();
                this.readText(dis, design);
                return design;
            }
            case 16: {
                DataItemDesign design = new DataItemDesign();
                this.readData(dis, design);
                return design;
            }
            case 17: {
                DynamicTextItemDesign design = new DynamicTextItemDesign();
                this.readDynamicText(dis, design);
                return design;
            }
            case 18: {
                ImageItemDesign design = new ImageItemDesign();
                this.readImage(dis, design);
                return design;
            }
            case 19: {
                TemplateDesign design = new TemplateDesign();
                this.readTemplate(dis, design);
                return design;
            }
            case 20: {
                ExtendedItemDesign design = new ExtendedItemDesign();
                this.readExtended(dis, design);
                if (this.version >= 3L) {
                    int count = IOUtil.readInt(in);
                    int i = 0;
                    while (i < count) {
                        design.getChildren().add(this.readDesign(in));
                        ++i;
                    }
                }
                return design;
            }
            case 21: {
                AutoTextItemDesign design = new AutoTextItemDesign();
                this.readAutoText(dis, design);
                return design;
            }
        }
        throw new IOException("unknow design type:" + designType);
    }

    protected void readReportElementField(DataInputStream in, ReportElementDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 0: {
                long id = IOUtil.readLong(in);
                design.setID(id);
                break;
            }
            case 1: {
                String name = IOUtil.readString(in);
                design.setName(name);
                break;
            }
            case 2: {
                String ext = IOUtil.readString(in);
                design.setExtends(ext);
                break;
            }
            case 3: {
                String javaClass = IOUtil.readString(in);
                design.setJavaClass(javaClass);
                break;
            }
            case 4: 
            case 253: {
                Map<String, Expression> userProperties = this.readExprMap(in);
                if (userProperties == null || userProperties.isEmpty()) break;
                design.setUserProperties(userProperties);
                break;
            }
            case 5: {
                IOUtil.readMap(in);
                break;
            }
            default: {
                throw new IOException("unknow field type " + fieldType);
            }
        }
    }

    protected void readStyledElementField(DataInputStream in, StyledElementDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 6: {
                String styleClass = IOUtil.readString(in);
                design.setStyleName(styleClass);
                break;
            }
            case 7: {
                MapDesign map = this.readMap(in);
                design.setMap(map);
                break;
            }
            case 8: {
                HighlightDesign highlight = this.readHighlight(in);
                design.setHighlight(highlight);
                break;
            }
            default: {
                this.readReportElementField(in, design, fieldType);
            }
        }
    }

    protected void readReportItemField(DataInputStream in, ReportItemDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 20: {
                design.setX(this.readDimension(in));
                break;
            }
            case 21: {
                design.setY(this.readDimension(in));
                break;
            }
            case 22: {
                design.setHeight(this.readDimension(in));
                break;
            }
            case 23: {
                design.setWidth(this.readDimension(in));
                break;
            }
            case 24: {
                Expression bookmark = this.readExpression(in);
                design.setBookmark(bookmark);
                break;
            }
            case 25: {
                Expression toc = this.readExpression(in);
                design.setTOC(toc);
                break;
            }
            case 26: {
                Expression onCreate = this.readExpression(in);
                design.setOnCreate(onCreate);
                break;
            }
            case 27: {
                Expression onRender = this.readExpression(in);
                design.setOnRender(onRender);
                break;
            }
            case 28: {
                Expression onPageBreak = this.readExpression(in);
                design.setOnPageBreak(onPageBreak);
                break;
            }
            case 29: {
                VisibilityDesign visibility = this.readVisibility(in);
                design.setVisibility(visibility);
                break;
            }
            case 112: {
                ActionDesign action = this.readAction(in);
                design.setAction(action);
                break;
            }
            case 113: {
                ActionDesign action1 = this.readActionV1(in);
                design.setAction(action1);
                break;
            }
            case 230: {
                boolean useCachedResult = IOUtil.readBool(in);
                design.setUseCachedResult(useCachedResult);
                break;
            }
            default: {
                this.readStyledElementField(in, design, fieldType);
            }
        }
    }

    protected void readMasterPageField(DataInputStream in, MasterPageDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 200: {
                String pageType = IOUtil.readString(in);
                design.setPageType(pageType);
                break;
            }
            case 201: {
                DimensionType width = this.readDimension(in);
                DimensionType height = this.readDimension(in);
                design.setPageSize(width, height);
                break;
            }
            case 202: {
                DimensionType top = this.readDimension(in);
                DimensionType left = this.readDimension(in);
                DimensionType bottom = this.readDimension(in);
                DimensionType right = this.readDimension(in);
                design.setMargin(top, left, bottom, right);
                break;
            }
            case 203: {
                String orientation = IOUtil.readString(in);
                design.setOrientation(orientation);
                break;
            }
            case 204: {
                String bodyStyleName = IOUtil.readString(in);
                design.setBodyStyleName(bodyStyleName);
                break;
            }
            default: {
                this.readStyledElementField(in, design, fieldType);
            }
        }
    }

    protected void readSimpleMasterPage(DataInputStream in, SimpleMasterPageDesign design) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readSimpleMasterPageField(in, design, fieldType);
        }
    }

    protected void readSimpleMasterPageField(DataInputStream in, SimpleMasterPageDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 210: {
                boolean showHeaderOnFirst = IOUtil.readBool(in);
                design.setShowHeaderOnFirst(showHeaderOnFirst);
                break;
            }
            case 211: {
                boolean showFooterOnLast = IOUtil.readBool(in);
                design.setShowFooterOnLast(showFooterOnLast);
                break;
            }
            case 212: {
                boolean floatingFooter = IOUtil.readBool(in);
                design.setFloatingFooter(floatingFooter);
                break;
            }
            case 213: {
                DimensionType headerHeight = this.readDimension(in);
                design.setHeaderHeight(headerHeight);
                break;
            }
            case 214: {
                DimensionType footerHeight = this.readDimension(in);
                design.setFooterHeight(footerHeight);
                break;
            }
            default: {
                this.readMasterPageField(in, design, fieldType);
            }
        }
    }

    protected void readGraphicMasterPageField(DataInputStream in, GraphicMasterPageDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 70: {
                int columns = IOUtil.readInt(in);
                design.setColumns(columns);
                break;
            }
            case 220: {
                DimensionType columnSpacing = this.readDimension(in);
                design.setColumnSpacing(columnSpacing);
                break;
            }
            default: {
                this.readMasterPageField(in, design, fieldType);
            }
        }
    }

    protected void readListingField(DataInputStream in, ListingDesign listing, short fieldType) throws IOException {
        switch (fieldType) {
            case 31: {
                listing.setRepeatHeader(IOUtil.readBool(in));
                break;
            }
            case 30: {
                int pageBreakInterval = IOUtil.readInt(in);
                listing.setPageBreakInterval(pageBreakInterval);
                break;
            }
            default: {
                this.readReportItemField(in, listing, fieldType);
            }
        }
    }

    protected void readGroupField(DataInputStream in, GroupDesign group, short fieldType) throws IOException {
        switch (fieldType) {
            case 40: {
                int groupLevel = IOUtil.readInt(in);
                group.setGroupLevel(groupLevel);
                break;
            }
            case 41: {
                String pageBreakBefore = IOUtil.readString(in);
                group.setPageBreakBefore(pageBreakBefore);
                break;
            }
            case 42: {
                String pageBreakAfter = IOUtil.readString(in);
                group.setPageBreakAfter(pageBreakAfter);
                break;
            }
            case 45: {
                String pageBreakInside = IOUtil.readString(in);
                group.setPageBreakInside(pageBreakInside);
                break;
            }
            case 44: {
                boolean hideDetail = IOUtil.readBool(in);
                group.setHideDetail(hideDetail);
                break;
            }
            case 43: {
                Boolean headerRepeat = IOUtil.readBool(in);
                group.setHeaderRepeat(headerRepeat);
                break;
            }
            default: {
                this.readReportItemField(in, group, fieldType);
            }
        }
    }

    protected void readBandField(DataInputStream in, BandDesign band, short fieldType) throws IOException {
        switch (fieldType) {
            case 50: {
                int bandType = IOUtil.readInt(in);
                band.setBandType(bandType);
                break;
            }
            default: {
                this.readReportItemField(in, band, fieldType);
            }
        }
    }

    protected void readList(DataInputStream in, ListItemDesign list) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readListField(in, list, fieldType);
        }
    }

    protected void readListField(DataInputStream in, ListItemDesign list, short fieldType) throws IOException {
        this.readListingField(in, list, fieldType);
    }

    protected void readListGroup(DataInputStream in, ListGroupDesign listGroup) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readListGroupField(in, listGroup, fieldType);
        }
    }

    protected void readListGroupField(DataInputStream in, ListGroupDesign group, short fieldType) throws IOException {
        this.readGroupField(in, group, fieldType);
    }

    protected void readListBand(DataInputStream in, ListBandDesign listBand) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readListBandField(in, listBand, fieldType);
        }
    }

    protected void readListBandField(DataInputStream in, ListBandDesign listBand, short fieldType) throws IOException {
        this.readBandField(in, listBand, fieldType);
    }

    protected void readTable(DataInputStream in, TableItemDesign table) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readTableField(in, table, fieldType);
        }
    }

    protected void readTableField(DataInputStream in, TableItemDesign table, short fieldType) throws IOException {
        switch (fieldType) {
            case 60: {
                String captionKey = IOUtil.readString(in);
                String caption = IOUtil.readString(in);
                table.setCaption(captionKey, caption);
                break;
            }
            case 71: {
                String summary = IOUtil.readString(in);
                table.setSummary(summary);
                break;
            }
            case 70: {
                int columnCount = IOUtil.readInt(in);
                int i = 0;
                while (i < columnCount) {
                    byte[] bytes = IOUtil.readBytes(in);
                    DataInputStream buffer = new DataInputStream(new ByteArrayInputStream(bytes));
                    ColumnDesign column = new ColumnDesign();
                    this.readColumn(buffer, column);
                    table.addColumn(column);
                    ++i;
                }
                break;
            }
            default: {
                this.readListingField(in, table, fieldType);
            }
        }
    }

    protected void readTableGroup(DataInputStream in, TableGroupDesign tableGroup) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readTableGroupField(in, tableGroup, fieldType);
        }
    }

    protected void readTableGroupField(DataInputStream in, TableGroupDesign group, short fieldType) throws IOException {
        this.readGroupField(in, group, fieldType);
    }

    protected void readTableBand(DataInputStream in, TableBandDesign tableBand) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readTableBandField(in, tableBand, fieldType);
        }
    }

    protected void readTableBandField(DataInputStream in, TableBandDesign tableBand, short fieldType) throws IOException {
        this.readBandField(in, tableBand, fieldType);
    }

    protected void readGrid(DataInputStream in, GridItemDesign grid) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readGridField(in, grid, fieldType);
        }
    }

    protected void readGridField(DataInputStream in, GridItemDesign grid, short fieldType) throws IOException {
        switch (fieldType) {
            case 60: {
                String captionKey = IOUtil.readString(in);
                String caption = IOUtil.readString(in);
                grid.setCaption(captionKey, caption);
                break;
            }
            case 71: {
                String summary = IOUtil.readString(in);
                grid.setSummary(summary);
                break;
            }
            case 70: {
                int columnCount = IOUtil.readInt(in);
                int i = 0;
                while (i < columnCount) {
                    byte[] bytes = IOUtil.readBytes(in);
                    ColumnDesign column = new ColumnDesign();
                    this.readColumn(new DataInputStream(new ByteArrayInputStream(bytes)), column);
                    grid.addColumn(column);
                    ++i;
                }
                break;
            }
            default: {
                this.readReportItemField(in, grid, fieldType);
            }
        }
    }

    protected void readColumn(DataInputStream in, ColumnDesign column) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readColumnField(in, column, fieldType);
        }
    }

    protected void readColumnField(DataInputStream in, ColumnDesign column, short fieldType) throws IOException {
        switch (fieldType) {
            case 82: {
                boolean isColumnHeader = IOUtil.readBool(in);
                column.setColumnHeaderState(isColumnHeader);
                break;
            }
            case 23: {
                DimensionType width = this.readDimension(in);
                column.setWidth(width);
                break;
            }
            case 80: {
                boolean suppressDuplicate = IOUtil.readBool(in);
                column.setSuppressDuplicate(suppressDuplicate);
                break;
            }
            case 29: {
                VisibilityDesign visibility = this.readVisibility(in);
                column.setVisibility(visibility);
                break;
            }
            case 81: {
                boolean hasDataItemsInDetail = IOUtil.readBool(in);
                column.setHasDataItemsInDetail(hasDataItemsInDetail);
                break;
            }
            default: {
                this.readStyledElementField(in, column, fieldType);
            }
        }
    }

    protected void readRow(DataInputStream in, RowDesign row) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readRowField(in, row, fieldType);
        }
    }

    protected void readRowField(DataInputStream in, RowDesign row, short fieldType) throws IOException {
        switch (fieldType) {
            case 90: {
                boolean isStartOfGroup = IOUtil.readBool(in);
                row.setStartOfGroup(isStartOfGroup);
                break;
            }
            case 91: {
                boolean isRepeatable = IOUtil.readBool(in);
                row.setRepeatable(isRepeatable);
                break;
            }
            default: {
                this.readReportItemField(in, row, fieldType);
            }
        }
    }

    protected void readCell(DataInputStream in, CellDesign cell) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readCellField(in, cell, fieldType);
        }
    }

    protected void readCellField(DataInputStream in, CellDesign cell, short fieldType) throws IOException {
        switch (fieldType) {
            case 100: {
                int column = IOUtil.readInt(in);
                cell.setColumn(column);
                break;
            }
            case 101: {
                int colSpan = IOUtil.readInt(in);
                cell.setColSpan(colSpan);
                break;
            }
            case 102: {
                int rowSpan = IOUtil.readInt(in);
                cell.setRowSpan(rowSpan);
                break;
            }
            case 103: {
                String drop = IOUtil.readString(in);
                cell.setDrop(drop);
                break;
            }
            case 104: {
                boolean displayGroupIcon = IOUtil.readBool(in);
                cell.setDisplayGroupIcon(displayGroupIcon);
                break;
            }
            case 105: {
                int diagonalNumber = IOUtil.readInt(in);
                cell.setDiagonalNumber(diagonalNumber);
                break;
            }
            case 106: {
                String diagonalStyle = IOUtil.readString(in);
                cell.setDiagonalStyle(diagonalStyle);
                break;
            }
            case 107: {
                DimensionType diagonalWidth = this.readDimension(in);
                cell.setDiagonalWidth(diagonalWidth);
                break;
            }
            case 111: {
                String diagonalColor = IOUtil.readString(in);
                cell.setDiagonalColor(diagonalColor);
                break;
            }
            case 108: {
                int antidiagonalNumber = IOUtil.readInt(in);
                cell.setAntidiagonalNumber(antidiagonalNumber);
                break;
            }
            case 109: {
                String antidiagonalStyle = IOUtil.readString(in);
                cell.setAntidiagonalStyle(antidiagonalStyle);
                break;
            }
            case 110: {
                DimensionType antidiagonalWidth = this.readDimension(in);
                cell.setAntidiagonalWidth(antidiagonalWidth);
                break;
            }
            case 112: {
                String antidiagonalColor = IOUtil.readString(in);
                cell.setAntidiagonalColor(antidiagonalColor);
                break;
            }
            case 99: {
                Expression headers = this.readExpression(in);
                cell.setHeaders(headers);
                break;
            }
            case 98: {
                String scope = IOUtil.readString(in);
                cell.setScope(scope);
                break;
            }
            default: {
                this.readReportItemField(in, cell, fieldType);
            }
        }
    }

    protected void readFreeForm(DataInputStream in, FreeFormItemDesign freeForm) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readFreeFormField(in, freeForm, fieldType);
        }
    }

    protected void readFreeFormField(DataInputStream in, FreeFormItemDesign freeForm, short fieldType) throws IOException {
        this.readReportItemField(in, freeForm, fieldType);
    }

    protected void readLabel(DataInputStream in, LabelItemDesign label) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readLabelField(in, label, fieldType);
        }
    }

    protected void readLabelField(DataInputStream in, LabelItemDesign label, short fieldType) throws IOException {
        switch (fieldType) {
            case 110: {
                String textKey = IOUtil.readString(in);
                String text = IOUtil.readString(in);
                label.setText(textKey, text);
                break;
            }
            case 111: {
                String helpTextKey = IOUtil.readString(in);
                String helpText = IOUtil.readString(in);
                label.setHelpText(helpTextKey, helpText);
                break;
            }
            default: {
                this.readReportItemField(in, label, fieldType);
            }
        }
    }

    protected void readData(DataInputStream in, DataItemDesign data) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readDataField(in, data, fieldType);
        }
    }

    protected void readDataField(DataInputStream in, DataItemDesign data, short fieldType) throws IOException {
        switch (fieldType) {
            case 120: {
                String value = IOUtil.readString(in);
                try {
                    String columnName = ExpressionUtil.getColumnBindingName(value);
                    if (columnName == null) break;
                    data.setBindingColumn(columnName);
                }
                catch (BirtException birtException) {}
                break;
            }
            case 121: {
                String bindingColumn = IOUtil.readString(in);
                data.setBindingColumn(bindingColumn);
                break;
            }
            case 80: {
                boolean suppressDuplicate = IOUtil.readBool(in);
                data.setSuppressDuplicate(suppressDuplicate);
                break;
            }
            case 111: {
                String helpTextKey = IOUtil.readString(in);
                String helpText = IOUtil.readString(in);
                data.setHelpText(helpTextKey, helpText);
                break;
            }
            case 122: {
                IOUtil.readBool(in);
                break;
            }
            default: {
                this.readReportItemField(in, data, fieldType);
            }
        }
    }

    protected void readText(DataInputStream in, TextItemDesign design) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readTextField(in, design, fieldType);
        }
    }

    protected void readTextField(DataInputStream in, TextItemDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 130: {
                String textType = IOUtil.readString(in);
                design.setTextType(textType);
                break;
            }
            case 110: {
                String textKey = IOUtil.readString(in);
                String text = IOUtil.readString(in);
                design.setText(textKey, text);
                break;
            }
            case 249: {
                boolean hasExpr = IOUtil.readBool(in);
                design.setHasExpression(hasExpr);
                break;
            }
            default: {
                this.readReportItemField(in, design, fieldType);
            }
        }
    }

    protected void readDynamicText(DataInputStream in, DynamicTextItemDesign design) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readDynamicTextField(in, design, fieldType);
        }
    }

    protected void readDynamicTextField(DataInputStream in, DynamicTextItemDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 140: {
                String contentType = IOUtil.readString(in);
                design.setContentType(contentType);
                break;
            }
            case 141: {
                Expression content = this.readExpression(in);
                design.setContent(content);
                break;
            }
            default: {
                this.readReportItemField(in, design, fieldType);
            }
        }
    }

    protected void readImage(DataInputStream in, ImageItemDesign image) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readImageField(in, image, fieldType);
        }
    }

    protected void readImageField(DataInputStream in, ImageItemDesign image, short fieldType) throws IOException {
        block0 : switch (fieldType) {
            case 150: {
                int imageSource = IOUtil.readInt(in);
                switch (imageSource) {
                    case 1: {
                        Expression imageName = this.readExpression(in);
                        image.setImageName(imageName);
                        break block0;
                    }
                    case 3: {
                        Expression imageFile = this.readExpression(in);
                        image.setImageFile(imageFile);
                        break block0;
                    }
                    case 0: {
                        Expression imageUri = this.readExpression(in);
                        image.setImageUri(imageUri);
                        break block0;
                    }
                    case 2: {
                        Expression imageExpr = this.readExpression(in);
                        Expression imageFormat = this.readExpression(in);
                        image.setImageExpression(imageExpr, imageFormat);
                        break block0;
                    }
                }
                throw new IOException("invalid image source: " + imageSource);
            }
            case 151: {
                String altTextKey = IOUtil.readString(in);
                String altText = IOUtil.readString(in);
                image.setAltText(altTextKey, altText);
                break;
            }
            case 111: {
                String helpTextKey = IOUtil.readString(in);
                String helpText = IOUtil.readString(in);
                image.setHelpText(helpTextKey, helpText);
                break;
            }
            case 152: {
                Boolean isFitToContainer = IOUtil.readBool(in);
                image.setFitToContainer(isFitToContainer);
                break;
            }
            case 153: {
                image.setProportionalScale(IOUtil.readBool(in));
                break;
            }
            default: {
                this.readReportItemField(in, image, fieldType);
            }
        }
    }

    protected void readExtended(DataInputStream in, ExtendedItemDesign extended) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readExtendedField(in, extended, fieldType);
        }
    }

    protected void readExtendedField(DataInputStream in, ExtendedItemDesign extended, short fieldType) throws IOException {
        switch (fieldType) {
            case 151: {
                String altTextKey = IOUtil.readString(in);
                String altText = IOUtil.readString(in);
                extended.setAltText(altTextKey, altText);
                break;
            }
            default: {
                this.readReportItemField(in, extended, fieldType);
            }
        }
    }

    protected void readAutoText(DataInputStream in, AutoTextItemDesign autoText) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readAutoTextField(in, autoText, fieldType);
        }
    }

    protected void readAutoTextField(DataInputStream in, AutoTextItemDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 160: {
                String type = IOUtil.readString(in);
                design.setType(type);
                break;
            }
            case 110: {
                String textKey = IOUtil.readString(in);
                String text = IOUtil.readString(in);
                design.setText(textKey, text);
                break;
            }
            default: {
                this.readReportItemField(in, design, fieldType);
            }
        }
    }

    protected void readTemplate(DataInputStream in, TemplateDesign design) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort(in);
            this.readTemplateField(in, design, fieldType);
        }
    }

    protected void readTemplateField(DataInputStream in, TemplateDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 170: {
                String allowedType = IOUtil.readString(in);
                design.setAllowedType(allowedType);
                break;
            }
            case 171: {
                String promptTextKey = IOUtil.readString(in);
                String promptText = IOUtil.readString(in);
                design.setPromptText(promptText);
                design.setPromptTextKey(promptTextKey);
                break;
            }
            default: {
                this.readReportItemField(in, design, fieldType);
            }
        }
    }

    protected DimensionType readDimension(DataInputStream in) throws IOException {
        boolean notNull = IOUtil.readBool(in);
        if (notNull) {
            DimensionType dimension = new DimensionType();
            dimension.readObject(in);
            return dimension;
        }
        return null;
    }

    protected VisibilityDesign readVisibility(DataInputStream in) throws IOException {
        VisibilityDesign visibility = new VisibilityDesign();
        int ruleCount = IOUtil.readInt(in);
        int i = 0;
        while (i < ruleCount) {
            VisibilityRuleDesign rule = new VisibilityRuleDesign();
            String format = IOUtil.readString(in);
            Expression expr = this.readExpression(in);
            rule.setFormat(format);
            rule.setExpression(expr);
            visibility.addRule(rule);
            ++i;
        }
        return visibility;
    }

    protected MapDesign readMap(DataInputStream in) throws IOException {
        MapDesign map = new MapDesign();
        int ruleCount = IOUtil.readInt(in);
        int i = 0;
        while (i < ruleCount) {
            MapRuleDesign rule = new MapRuleDesign();
            this.readRuleDesign(in, rule);
            String displayText = IOUtil.readString(in);
            String displayKey = IOUtil.readString(in);
            rule.setDisplayText(displayKey, displayText);
            map.addRule(rule);
            ++i;
        }
        return map;
    }

    protected HighlightDesign readHighlight(DataInputStream in) throws IOException {
        HighlightDesign highlight = new HighlightDesign();
        int ruleCount = IOUtil.readInt(in);
        int i = 0;
        while (i < ruleCount) {
            HighlightRuleDesign rule = new HighlightRuleDesign();
            this.readRuleDesign(in, rule);
            IStyle style = this.readStyle(in);
            rule.setStyle(style);
            highlight.addRule(rule);
            ++i;
        }
        return highlight;
    }

    protected void readRuleDesign(DataInputStream in, RuleDesign rule) throws IOException {
        if (this.version < 7L) {
            this.readRuleDesignV6(in, rule);
        } else {
            this.readRuleDesignV7(in, rule);
        }
    }

    protected void readRuleDesignV6(DataInputStream in, RuleDesign rule) throws IOException {
        String testExpr = IOUtil.readString(in);
        String oper = IOUtil.readString(in);
        Object object1 = IOUtil.readObject(in);
        Object object2 = IOUtil.readObject(in);
        rule.setTestExpression(Expression.newScript(testExpr));
        if (object1 instanceof List) {
            List list = (List)object1;
            ArrayList<Expression> exprs = new ArrayList<Expression>(list.size());
            for (Object expr : list) {
                if (expr instanceof String) {
                    exprs.add(Expression.newScript((String)expr));
                    continue;
                }
                exprs.add(null);
            }
            rule.setExpression(oper, exprs);
            rule.setValueIsList(true);
        } else {
            Expression.Script expr1 = object1 == null ? null : Expression.newScript((String)object1);
            Expression.Script expr2 = object2 == null ? null : Expression.newScript((String)object2);
            rule.setExpression(oper, expr1, expr2);
            rule.setValueIsList(false);
        }
    }

    protected void readRuleDesignV7(DataInputStream in, RuleDesign rule) throws IOException {
        Expression testExpr = this.readExpression(in);
        String oper = IOUtil.readString(in);
        boolean isList = IOUtil.readBool(in);
        if (isList) {
            int size = IOUtil.readInt(in);
            ArrayList<Expression> exprs = new ArrayList<Expression>(size);
            int i = 0;
            while (i < size) {
                Expression expr = this.readExpression(in);
                exprs.add(expr);
                ++i;
            }
            rule.setExpression(oper, exprs);
        } else {
            Expression expr1 = this.readExpression(in);
            Expression expr2 = this.readExpression(in);
            rule.setExpression(oper, expr1, expr2);
        }
        rule.setValueIsList(isList);
        rule.setTestExpression(testExpr);
    }

    protected IStyle readStyle(DataInputStream in) throws IOException {
        if (this.version <= 3L) {
            String cssText = IOUtil.readString(in);
            IStyle style = (IStyle)this.reportDesign.getCSSEngine().parseStyleDeclaration(cssText);
            return style;
        }
        StyleDeclaration style = new StyleDeclaration(this.reportDesign.getCSSEngine());
        if (style != null) {
            style.read(in);
        }
        return style;
    }

    protected ActionDesign readAction(DataInputStream in) throws IOException {
        ActionDesign action = new ActionDesign();
        int actionType = IOUtil.readInt(in);
        switch (actionType) {
            case 2: {
                Expression bookmark = this.readExpression(in);
                action.setBookmark(bookmark);
                break;
            }
            case 3: {
                DrillThroughActionDesign drillThrough = this.readDrillThrough(in);
                action.setDrillThrough(drillThrough);
                break;
            }
            case 1: {
                Expression hyperlink = this.readExpression(in);
                action.setHyperlink(hyperlink);
                break;
            }
            default: {
                throw new IOException("invalid action type:" + actionType);
            }
        }
        if (this.version == 0L) {
            IOUtil.readBool(in);
        }
        String targetWindow = IOUtil.readString(in);
        action.setTargetWindow(targetWindow);
        return action;
    }

    protected ActionDesign readActionV1(DataInputStream in) throws IOException {
        ActionDesign action = this.readAction(in);
        String tooltip = IOUtil.readString(in);
        action.setTooltip(tooltip);
        return action;
    }

    protected DrillThroughActionDesign readDrillThrough(DataInputStream in) throws IOException {
        DrillThroughActionDesign drillThrough = new DrillThroughActionDesign();
        Expression reportName = this.readExpression(in);
        String fileType = null;
        if (this.version >= 7L) {
            fileType = IOUtil.readString(in);
        }
        Map<String, List<Expression>> parameters = this.readDrillThroughExprMap(in);
        Map search = IOUtil.readMap(in);
        String format = IOUtil.readString(in);
        boolean bookmarkType = IOUtil.readBool(in);
        drillThrough.setBookmarkType(bookmarkType);
        Expression bookmark = this.readExpression(in);
        drillThrough.setReportName(reportName);
        drillThrough.setTargetFileType(fileType);
        drillThrough.setParameters(parameters);
        drillThrough.setSearch(search);
        drillThrough.setFormat(format);
        drillThrough.setBookmark(bookmark);
        return drillThrough;
    }

    private Map<String, Expression> readExprMap(DataInputStream dis) throws IOException {
        HashMap<String, Expression> exprs = new HashMap<String, Expression>();
        if (this.version < 7L) {
            Map map = IOUtil.readMap(dis);
            for (Map.Entry entry : map.entrySet()) {
                String name = (String)entry.getKey();
                Expression.Script expr = Expression.newScript((String)entry.getValue());
                exprs.put(name, expr);
            }
        } else {
            int size = IOUtil.readInt(dis);
            int i = 0;
            while (i < size) {
                String name = IOUtil.readString(dis);
                Expression expr = this.readExpression(dis);
                exprs.put(name, expr);
                ++i;
            }
        }
        return exprs;
    }

    private Map<String, List<Expression>> readDrillThroughExprMap(DataInputStream dis) throws IOException {
        HashMap<String, List<Expression>> exprs = new HashMap<String, List<Expression>>();
        if (this.version < 7L) {
            Map map = IOUtil.readMap(dis);
            for (Map.Entry entry : map.entrySet()) {
                String name = (String)entry.getKey();
                Expression.Script expr = Expression.newScript((String)entry.getValue());
                ArrayList<Expression.Script> exprList = new ArrayList<Expression.Script>(1);
                exprList.add(expr);
                exprs.put(name, exprList);
            }
        } else if (this.version < 8L) {
            int size = IOUtil.readInt(dis);
            int i = 0;
            while (i < size) {
                String name = IOUtil.readString(dis);
                Expression expr = this.readExpression(dis);
                ArrayList<Expression> exprList = new ArrayList<Expression>(1);
                exprList.add(expr);
                exprs.put(name, exprList);
                ++i;
            }
        } else {
            int size = IOUtil.readInt(dis);
            int i = 0;
            while (i < size) {
                String name = IOUtil.readString(dis);
                int exprSize = IOUtil.readInt(dis);
                ArrayList<Expression> exprList = new ArrayList<Expression>(exprSize);
                int j = 0;
                while (j < exprSize) {
                    Expression expr = this.readExpression(dis);
                    exprList.add(expr);
                    ++j;
                }
                exprs.put(name, exprList);
                ++i;
            }
        }
        return exprs;
    }

    protected Expression readExpression(DataInputStream in) throws IOException {
        if (this.version < 7L) {
            String scriptText = IOUtil.readString(in);
            if (scriptText != null) {
                return Expression.newScript(scriptText);
            }
            return null;
        }
        boolean isNull = IOUtil.readBool(in);
        if (!isNull) {
            int exprType = IOUtil.readInt(in);
            switch (exprType) {
                case 0: {
                    int valueType = IOUtil.readInt(in);
                    String scriptText = IOUtil.readString(in);
                    return Expression.newConstant(valueType, scriptText);
                }
                case 1: {
                    short scriptType = IOUtil.readShort(in);
                    if (scriptType == 250) {
                        String language = IOUtil.readString(in);
                        String expression = IOUtil.readString(in);
                        return Expression.newScript(language, expression);
                    }
                    if (scriptType != 251) break;
                    String expression = IOUtil.readString(in);
                    return Expression.newScript(expression);
                }
            }
        }
        return null;
    }
}

