/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.css;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLProcessor {
    private static Logger logger = Logger.getLogger(HTMLProcessor.class.getName());
    protected ReportDesignHandle design;
    protected String rootPath;
    private Map appContext;
    private static String[] FONT_SIZE = new String[]{"7.5pt", "7.5pt", "7.5pt", "7.5pt", "7.5pt", "7.5pt", "10pt", "7.5pt", "7.5pt", "10pt", "12pt", "13.8pt", "18pt", "23pt", "36pt"};
    private static Pattern pattern = Pattern.compile("[ ]*([^:]*)[ ]*:[ ]*([^;]*)[ ]*[;]*");

    public HTMLProcessor(ReportDesignHandle design, Map context) {
        this.design = design;
        this.rootPath = null;
        this.appContext = context;
    }

    public HTMLProcessor(String rootPath) {
        this.design = null;
        this.rootPath = rootPath;
    }

    public void execute(Element ele, HashMap styles) {
        HashMap<String, String> cssStyle = new HashMap<String, String>();
        if (ele.hasAttribute("style")) {
            String src;
            String inlineStyle = ele.getAttribute("style");
            if (inlineStyle != null && !"".equals(inlineStyle)) {
                new StringBuffer();
                Matcher matcher = pattern.matcher(inlineStyle);
                while (matcher.find()) {
                    String name = matcher.group(1);
                    String value = matcher.group(2);
                    if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
                    cssStyle.put(name, value.trim());
                }
                ele.removeAttribute("style");
                String src2 = (String)cssStyle.get("background-image");
                if (src2 != null) {
                    URL url;
                    if (src2.startsWith("url(") && src2.length() > 5) {
                        src2 = src2.substring(4, src2.length() - 1);
                    } else if ((src2.startsWith("\"") || src2.startsWith("'")) && src2.length() > 2) {
                        src2 = src2.substring(1, src2.length() - 1);
                    }
                    if (this.design != null && (url = this.design.findResource(src2, 1, this.appContext)) != null) {
                        src2 = url.toExternalForm();
                    }
                    if (this.rootPath != null && FileUtil.isLocalResource(src2)) {
                        src2 = FileUtil.getAbsolutePath(this.rootPath, src2);
                    }
                    if (src2 != null) {
                        cssStyle.put("background-image", src2);
                    } else {
                        cssStyle.remove("background-image");
                    }
                }
            }
            if ("b".equals(ele.getTagName())) {
                this.addToStyle(cssStyle, "font-weight", "bold");
                ele = this.replaceElement(ele, "span");
            } else if ("center".equals(ele.getTagName())) {
                this.addToStyle(cssStyle, "text-align", "center");
                ele = this.replaceElement(ele, "div");
            } else if ("font".equals(ele.getTagName())) {
                this.addToStyle(cssStyle, "color", ele.getAttribute("color"));
                this.addToStyle(cssStyle, "font-family", ele.getAttribute("face"));
                if (ele.hasAttribute("size")) {
                    try {
                        int size = Integer.parseInt(ele.getAttribute("size"));
                        this.addToStyle(cssStyle, "font-size", FONT_SIZE[size + 7]);
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "There is a invalid value for property SIZE of element FONT in the HTML.");
                    }
                }
                ele.removeAttribute("color");
                ele.removeAttribute("face");
                ele.removeAttribute("size");
                ele = this.replaceElement(ele, "span");
            } else if ("i".equals(ele.getTagName())) {
                this.addToStyle(cssStyle, "font-style", "italic");
                ele = this.replaceElement(ele, "span");
            } else if ("u".equals(ele.getTagName())) {
                String decoration = (String)cssStyle.get("text-decoration");
                if (decoration != null && decoration.indexOf("underline") == -1 && decoration.indexOf("none") == -1 && decoration.indexOf("inherit") == -1) {
                    decoration = String.valueOf(decoration) + " underline";
                } else if (decoration == null) {
                    decoration = "underline";
                }
                cssStyle.put("text-decoration", decoration);
                ele = this.replaceElement(ele, "span");
            } else if ("img".equals(ele.getTagName()) && (src = ele.getAttribute("src")) != null) {
                URL url;
                if ((src.startsWith("\"") || src.startsWith("'")) && src.length() > 2) {
                    src = src.substring(1, src.length() - 1);
                }
                if (this.design != null && (url = this.design.findResource(src, 1, this.appContext)) != null) {
                    src = url.toExternalForm();
                }
                if (this.rootPath != null && FileUtil.isLocalResource(src)) {
                    src = FileUtil.getAbsolutePath(this.rootPath, src);
                }
                if (src != null) {
                    ele.removeAttribute("src");
                    ele.setAttribute("src", src);
                }
            }
            styles.put(ele, cssStyle);
        }
        int i = 0;
        while (i < ele.getChildNodes().getLength()) {
            Node child = ele.getChildNodes().item(i);
            if (child.getNodeType() == 1) {
                this.execute((Element)child, styles);
            }
            ++i;
        }
    }

    private Element replaceElement(Element oldEle, String tag) {
        Element newEle = oldEle.getOwnerDocument().createElement(tag);
        int i = 0;
        while (i < oldEle.getAttributes().getLength()) {
            String attrName = oldEle.getAttributes().item(i).getNodeName();
            newEle.setAttribute(attrName, oldEle.getAttribute(attrName));
            ++i;
        }
        Node child = oldEle.getFirstChild();
        while (child != null) {
            newEle.appendChild(child);
            child = oldEle.getFirstChild();
        }
        oldEle.getParentNode().replaceChild(newEle, oldEle);
        return newEle;
    }

    private void addToStyle(HashMap style, String attrName, String attrValue) {
        if (attrValue == null || attrValue.trim().length() == 0) {
            return;
        }
        if (style.get(attrName) == null) {
            style.put(attrName, attrValue);
        }
    }
}

