/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import javax.olap.OLAPException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.DataItemDesign;

public class DataItemExecutor
extends QueryItemExecutor {
    public DataItemExecutor(ExecutorManager manager) {
        super(manager, 7);
    }

    public IContent execute() {
        DataItemDesign dataDesign = (DataItemDesign)this.getDesign();
        IDataContent dataContent = this.report.createDataContent();
        this.setContent(dataContent);
        this.executeQuery();
        this.initializeContent(dataDesign, dataContent);
        this.processAction(dataDesign, dataContent);
        this.processBookmark(dataDesign, dataContent);
        this.processStyle(dataDesign, dataContent);
        this.processVisibility(dataDesign, dataContent);
        this.processUserProperties(dataDesign, dataContent);
        Object value = null;
        IBaseResultSet rset = this.context.getResultSet();
        if (rset != null) {
            String bindingColumn;
            if (rset.getType() == 0) {
                String bindingColumn2 = dataDesign.getBindingColumn();
                if (bindingColumn2 != null) {
                    try {
                        value = ((IQueryResultSet)rset).getValue(bindingColumn2);
                    }
                    catch (BirtException ex) {
                        this.context.addException(dataDesign, ex);
                    }
                }
            } else if (rset.getType() == 1 && (bindingColumn = dataDesign.getBindingColumn()) != null) {
                try {
                    value = ((ICubeResultSet)rset).getCubeCursor().getObject(bindingColumn);
                }
                catch (OLAPException ex) {
                    this.context.addException(dataDesign, (BirtException)new EngineException(ex));
                }
            }
        }
        dataContent.setValue(value);
        this.processMappingValue(dataDesign, dataContent);
        if (this.context.isInFactory()) {
            this.handleOnCreate(dataContent);
        }
        this.startTOCEntry(dataContent);
        return this.content;
    }

    public void close() throws BirtException {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
    }
}

