/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrillOnDimensionHierarchy {
    private Map<DimLevel, List<IEdgeDrillFilter>> drillOnLevelsMap = new HashMap<DimLevel, List<IEdgeDrillFilter>>();
    private IEdgeDrillFilter[] drill;
    private List<List<IEdgeDrillFilter>> sortedDrillFilter = new ArrayList<List<IEdgeDrillFilter>>();

    public DrillOnDimensionHierarchy(IDimensionDefinition dimension, IEdgeDrillFilter[] drill) {
        if (dimension == null || drill.length == 0) {
            return;
        }
        this.drill = drill;
        int i = 0;
        while (i < dimension.getHierarchy().get(0).getLevels().size()) {
            ILevelDefinition level = dimension.getHierarchy().get(0).getLevels().get(i);
            ArrayList<IEdgeDrillFilter> drillList = new ArrayList<IEdgeDrillFilter>();
            int j = 0;
            while (j < drill.length) {
                if (drill[j].getTargetLevelName().equals(level.getName())) {
                    drillList.add(drill[j]);
                }
                ++j;
            }
            this.drillOnLevelsMap.put(new DimLevel(dimension.getName(), level.getName()), drillList);
            this.sortedDrillFilter.add(drillList);
            ++i;
        }
    }

    public List<IEdgeDrillFilter> getDrillFilterByLevel(DimLevel dimLevel) {
        return this.drillOnLevelsMap.get(dimLevel);
    }

    public Iterator<List<IEdgeDrillFilter>> getDrillFilterIterator() {
        return this.sortedDrillFilter.iterator();
    }

    public IEdgeDrillFilter[] getDrillByDimension() {
        return this.drill;
    }

    public boolean contains(IEdgeDrillFilter targetDrill) {
        int i = 0;
        while (i < this.drill.length) {
            if (this.drill[i].equals(targetDrill)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

