/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import com.ibm.icu.util.Calendar;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Hierarchy;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredHierarchy
extends Hierarchy {
    private Set<String> notAccessibleLevels;
    private long nullTime;

    public SecuredHierarchy(IDocumentManager documentManager, String dimensionName, String hierarchyName, Set<String> notAccessibleLevels) {
        super(documentManager, dimensionName, hierarchyName);
        this.notAccessibleLevels = notAccessibleLevels;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(0, 0, 1, 0, 0, 0);
        this.nullTime = calendar.getTimeInMillis();
    }

    @Override
    protected Member[] populateLevelMembers() throws IOException {
        Member[] levelMembers = new Member[this.levels.length];
        int i = 0;
        while (i < levelMembers.length) {
            levelMembers[i] = this.readLevelMember(this.levels[i]);
            if (this.notAccessibleLevels.contains(this.levels[i].getName())) {
                if (levelMembers[i].getKeyValues() != null) {
                    int j = 0;
                    while (j < levelMembers[i].getKeyValues().length) {
                        levelMembers[i].getKeyValues()[j] = this.createNullValueReplacer(levelMembers[i].getKeyValues()[j]);
                        ++j;
                    }
                }
                if (levelMembers[i].getAttributes() != null) {
                    Arrays.fill(levelMembers[i].getAttributes(), null);
                }
            }
            ++i;
        }
        return levelMembers;
    }

    private Object createNullValueReplacer(Object o) {
        switch (DataTypeUtil.toApiDataType(o.getClass())) {
            case 6: {
                return new Date(this.nullTime);
            }
            case 9: {
                return new java.sql.Date(this.nullTime);
            }
            case 10: {
                return new Time(this.nullTime);
            }
            case 1: {
                return Boolean.FALSE;
            }
            case 4: {
                return new BigDecimal(0);
            }
            case 3: {
                return new Double(0.0);
            }
            case 2: {
                return 0;
            }
            case 5: {
                return "";
            }
        }
        return "";
    }
}

