/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import org.eclipse.birt.data.engine.api.timefunction.IParallelPeriod;
import org.eclipse.birt.data.engine.api.timefunction.IPeriodsFunction;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.MonthToDateFunction;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.PreviousNPeriodsFunction;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.QuarterToDateFunction;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TrailingFunction;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.WeekToDateFunciton;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.YearToDateFunction;

public class TimeFunctionFactory {
    public static IPeriodsFunction createPeriodsToDateFunction(String levelType, boolean isCurrent) {
        AbstractMDX function = null;
        if (levelType.equals("year")) {
            function = new YearToDateFunction();
        } else if (levelType.equals("quarter")) {
            function = new QuarterToDateFunction();
        } else if (levelType.equals("month")) {
            function = new MonthToDateFunction();
        } else if (levelType.equals("week-of-month")) {
            function = new WeekToDateFunciton();
        } else if (levelType.equals("week-of-year")) {
            function = new WeekToDateFunciton();
        }
        if (isCurrent) {
            ((AbstractMDX)function).setIsCurrent(isCurrent);
        }
        return function;
    }

    public static IPeriodsFunction createTrailingFunction(String levelType, int Offset2) {
        return new TrailingFunction(levelType, Offset2);
    }

    public static IParallelPeriod createParallelPeriodFunction(String levelType, int Offset2) {
        return new PreviousNPeriodsFunction(levelType, Offset2);
    }
}

