/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AbstractRowAccessor;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationRowAccessor
extends AbstractRowAccessor {
    private IAggregationResultSet resultSet;
    private IBindingValueFetcher fetcher;
    private Map<String, Object> currentAxisValue;

    public AggregationRowAccessor(IAggregationResultSet resultSet, IBindingValueFetcher fetcher) {
        this.resultSet = resultSet;
        this.fetcher = fetcher;
        this.currentAxisValue = new HashMap<String, Object>();
        this.populateFieldIndexMap();
    }

    @Override
    protected void populateFieldIndexMap() {
        int i = 0;
        while (i < this.resultSet.getLevelCount()) {
            DimLevel level = this.resultSet.getAllLevels()[i];
            int j = 0;
            while (j < this.resultSet.getLevelKeyColCount(i)) {
                String levelKeyName = this.resultSet.getLevelKeyName(i, j);
                String name = OlapExpressionUtil.getAttrReference(level.getDimensionName(), level.getLevelName(), levelKeyName);
                this.fieldIndexMap.put(name, new AggregationKeyIndex(i, j));
                ++j;
            }
            String[] attrNames = this.resultSet.getLevelAttributes(i);
            if (attrNames != null) {
                int j2 = 0;
                while (j2 < attrNames.length) {
                    String attrName = this.parseAttributeName(attrNames[j2]);
                    String name = OlapExpressionUtil.getAttrReference(level.getDimensionName(), level.getLevelName(), attrName);
                    this.fieldIndexMap.put(name, new AggregationAttrIndex(i, j2));
                    ++j2;
                }
            }
            ++i;
        }
    }

    @Override
    public Object getAggrValue(String aggrName) throws DataException {
        try {
            int aggrIndex = this.resultSet.getAggregationIndex(aggrName);
            if (aggrIndex == -1) {
                return this.getFieldValue(aggrName);
            }
            return this.resultSet.getAggregationValue(aggrIndex);
        }
        catch (IOException e) {
            throw new DataException("", e);
        }
    }

    @Override
    public Object getFieldValue(String fieldName) throws DataException {
        AbstractRowAccessor.FieldIndex index = (AbstractRowAccessor.FieldIndex)this.fieldIndexMap.get(fieldName);
        if (index != null) {
            return index.getValue();
        }
        if (this.currentAxisValue.containsKey(fieldName)) {
            return this.currentAxisValue.get(fieldName);
        }
        if (this.fetcher != null) {
            return this.fetcher.getValue(fieldName, this, this.resultSet.getPosition());
        }
        return null;
    }

    @Override
    public boolean isTimeDimensionRow() {
        return false;
    }

    public boolean isAxisLevel(String name) {
        return this.currentAxisValue.containsKey(name);
    }

    public void setCurrentAxisValue(Map<String, Object> currentAxisValue) {
        if (currentAxisValue != null) {
            this.currentAxisValue = currentAxisValue;
        } else {
            this.currentAxisValue.clear();
        }
    }

    class AggregationAttrIndex
    extends AbstractRowAccessor.AttributeIndex {
        AggregationAttrIndex(int levelIndex, int keyIndex) {
            super(levelIndex, keyIndex);
        }

        Object getValue() {
            return AggregationRowAccessor.this.resultSet.getLevelAttribute(this.levelIndex, this.attrIndex);
        }
    }

    class AggregationKeyIndex
    extends AbstractRowAccessor.KeyIndex {
        AggregationKeyIndex(int levelIndex, int keyIndex) {
            super(levelIndex, keyIndex);
        }

        Object getValue() {
            return AggregationRowAccessor.this.resultSet.getLevelKeyValue(this.levelIndex)[this.keyIndex];
        }
    }
}

