/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.IDataPointEntry;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;

public final class StockEntry
implements IDataPointEntry {
    private double dOpen;
    private double dLow;
    private double dHigh;
    private double dClose;

    public StockEntry(double dOpen, double dLow, double dHigh, double dClose) {
        this.dOpen = dOpen;
        this.dLow = dLow;
        this.dHigh = dHigh;
        this.dClose = dClose;
    }

    public StockEntry(Object[] oaFourComponents) {
        assert (oaFourComponents.length == 4);
        this.dHigh = oaFourComponents[0] instanceof Number ? ((Number)oaFourComponents[0]).doubleValue() : Double.NaN;
        this.dLow = oaFourComponents[1] instanceof Number ? ((Number)oaFourComponents[1]).doubleValue() : Double.NaN;
        this.dOpen = oaFourComponents[2] instanceof Number ? ((Number)oaFourComponents[2]).doubleValue() : Double.NaN;
        this.dClose = oaFourComponents[3] instanceof Number ? ((Number)oaFourComponents[3]).doubleValue() : Double.NaN;
    }

    public String toString() {
        return this.getFormattedString(null, ULocale.getDefault());
    }

    public final double getClose() {
        return this.dClose;
    }

    public final void setClose(double close) {
        this.dClose = close;
    }

    public final double getHigh() {
        return this.dHigh;
    }

    public final void setHigh(double high) {
        this.dHigh = high;
    }

    public final double getLow() {
        return this.dLow;
    }

    public final void setLow(double low) {
        this.dLow = low;
    }

    public final double getOpen() {
        return this.dOpen;
    }

    public final void setOpen(double open) {
        this.dOpen = open;
    }

    public String getFormattedString(String type, FormatSpecifier formatter, ULocale locale) {
        double dValue;
        String str;
        block7: {
            str = null;
            dValue = Double.NaN;
            if ("stock_high".equals(type)) {
                dValue = this.dHigh;
                break block7;
            }
            if ("stock_low".equals(type)) {
                dValue = this.dLow;
                break block7;
            }
            if ("stock_open".equals(type)) {
                dValue = this.dOpen;
                break block7;
            }
            if ("stock_close".equals(type)) {
                dValue = this.dClose;
                break block7;
            }
            return null;
        }
        try {
            str = formatter == null ? Double.toString(dValue) : ValueFormatter.format(new Double(dValue), formatter, locale, null);
        }
        catch (ChartException e) {
            Logger.getLogger("org.eclipse.birt.chart.engine/exception").log(e);
        }
        return str;
    }

    public String getFormattedString(FormatSpecifier formatter, ULocale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append('H');
        sb.append(this.getFormattedString("stock_high", formatter, locale));
        sb.append(" L");
        sb.append(this.getFormattedString("stock_low", formatter, locale));
        sb.append(" O");
        sb.append(this.getFormattedString("stock_open", formatter, locale));
        sb.append(" C");
        sb.append(this.getFormattedString("stock_close", formatter, locale));
        return sb.toString();
    }

    public boolean isValid() {
        return !Double.isNaN(this.dHigh) && !Double.isNaN(this.dLow) && !Double.isNaN(this.dClose) && !Double.isNaN(this.dOpen);
    }
}

